unit USimpleLogMain;

interface

uses
  Windows, SysUtils, UNsmConsts, UNsmTypes, UNsmInfo, UNsmPluginMain;

const
  // vOC
  NMP_INFO_APIVER       = NSM_API_VERSION;
  NMP_INFO_MODULENAME   = NMM_ADDIN + '/SimpleLog';
  NMP_INFO_TITLE        = 'Simple Log';
  NMP_INFO_DESCRIPTION  = 'Simple Message Logger for Regnessem';
  NMP_INFO_AUTHOR       = 'Yamaneko';
  NMP_INFO_COPYRIGHT    = 'Copyright (c) 2001-2003 Yamaneko';
  NMP_INFO_PLUGINVER    = '0.1.6';

type
  // ̃vOC̏ۂɍsCNX
  TSimpleLogMain = class(TNsmPluginMain)
  private
    FNsmInfo: TNsmGetInfo;
    function GetLogDir(Session: HNsmSession; MsgInfo: TMessageInfo): String;
    function MakeLogStr(Session: HNsmSession; MsgInfo: TMessageInfo): WideString;
    function RGBSwap(const Value: Cardinal): Cardinal;
    function EncodeControlChar(const Source: WideString): WideString;
    function TextAttrToStr(TextAttr: TTextAttributeInfo): WideString;
    procedure SaveLog(const FileName: String; const LogStr: WideString);
  protected
    procedure DoInitialize; override;
    procedure DoTerminate; override;
    procedure DoAllModulesLoaded; override;
  public
    constructor Create; override;
    procedure SaveMessage(Session: HNsmSession; MsgInfo: TMessageInfo);
  end;

  // Oۑp̃f[^ EnumMember R[obN֐֓n߂̍\
  TSaveLogData = record
    LogStr: WideString;
    BaseDir: String;
  end;
  PSaveLogData = ^TSaveLogData;

  // õAJEg烍Ot@C̃pX𓾂ƎT[rXŎgp\
  TGetLogFileNameInfo = record
    lpProtocol: LPCTSTR;        // vgR
    lpUserAccount: LPCTSTR;     // [UAJEg
    lpAccount: LPCTSTR;         // ΏۃoAJEg
    lpLogName: LPTSTR;          // Ot@Ci[obt@
    nBuffSize: Integer;         // obt@TCY
  end;
  PGetLogFileNameInfo = ^TGetLogFileNameInfo;

// Cxgnh
function OnSendMessage(wParam, lParam: Cardinal): Integer; Stdcall;
function OnReceiveMessage(wParam, lParam: Cardinal): Integer; Stdcall;
// T[rX֐
function DoGetLogFileName(wParam, lParam: Cardinal): Integer; Stdcall;

implementation

var
  SimpleLogMain: TSimpleLogMain;

const
  WideTab: WideChar     = WideChar(#09);
  WideCR: WideChar      = WideChar(#13);
  WideLF: WideChar      = WideChar(#10);
  WideCRLF: WideString  = WideString(#13#10);

// TSimpleLogMain --------------------------------------------------------------

constructor TSimpleLogMain.Create;
begin
  inherited;
  PluginInfo[NMPI_APIVER]        := NMP_INFO_APIVER;
  PluginInfo[NMPI_MODULENAME]    := NMP_INFO_MODULENAME;
  PluginInfo[NMPI_TITLE]         := NMP_INFO_TITLE;
  PluginInfo[NMPI_DESCRIPTION]   := NMP_INFO_DESCRIPTION;
  PluginInfo[NMPI_AUTHOR]        := NMP_INFO_AUTHOR;
  PluginInfo[NMPI_COPYRIGHT]     := NMP_INFO_COPYRIGHT;
  PluginInfo[NMPI_PLUGINVER]     := NMP_INFO_PLUGINVER;
end;

// 
procedure TSimpleLogMain.DoInitialize;
begin
  inherited;
  FNsmInfo := TNsmGetInfo.Create(InitInfo);

  // ƎT[rX̓o^iSimpleUIƘAgj
  CreateService(NMP_INFO_MODULENAME + '/GetLogFileName', DoGetLogFileName);
end;

// I
procedure TSimpleLogMain.DoTerminate;
begin
  inherited;
  FNsmInfo.Free;
end;

procedure TSimpleLogMain.DoAllModulesLoaded;
begin
  inherited;
  // KvȃCxgtbNo^
  HookEvent(NME_SYSTEM_SESSION_SENDMESSAGE, OnSendMessage);
  HookEvent(NME_SYSTEM_SESSION_RECEIVEMESSAGE, OnReceiveMessage);
end;

function EnumMember(lpAccount: LPTSTR; nData: Integer): Integer; StdCall;
var
  LogData: TSaveLogData;
begin
  LogData := PSaveLogData(nData)^;
  SimpleLogMain.SaveLog(LogData.BaseDir + lpAccount + '.log', LogData.LogStr);
  Result := 0;
end;

// MbZ[WOt@Cɕۑ
procedure TSimpleLogMain.SaveMessage(Session: HNsmSession; MsgInfo: TMessageInfo);
var
  EnumInfo: TEnumMemberInfo;
  LogInfo: TSaveLogData;
begin
  // o񋓊֐ɓn߂̃f[^i[
  with LogInfo do
  begin
    BaseDir := GetLogDir(Session, MsgInfo);
    LogStr := MakeLogStr(Session, MsgInfo);
  end;
  // o񋓗p̍\
  with EnumInfo do
  begin
    cbSize := SizeOf(EnumInfo);
    nFlags := 0;
    lpCallBackProc := EnumMember;
    nData := Integer(@LogInfo);
  end;
  // ZbVɎQĂ郁o
  // oɃOt@C쐬ďo
  CallService(NMS_SYSTEM_SESSION_MEMBERS_ENUM, Session, Cardinal(@EnumInfo));
end;

// ۑ̃Ot@CԂ
function TSimpleLogMain.GetLogDir(Session: HNsmSession; MsgInfo: TMessageInfo): String;
var
  Connection: HNsmConnection;
  Protocol, UserAccount: String;
begin
  // ZbVLRlNV̎ʎq𓾂
  Connection :=
      HNsmConnection(FNsmInfo.GetSessionInfoInt(Session, NMSI_CONNECTION));
  // ZbVLvgR𓾂
  Protocol := FNsmInfo.GetConnectionInfo(Connection, NMCI_PROTOCOL);
  // [ŨAJEg𓾂
  UserAccount := FNsmInfo.GetConnectionInfo(Connection, NMCI_USER_ACCOUNT);

  Result := WorkDir + 'Logs\' + Protocol + '\' + UserAccount + '\';
end;

// Oۑp쐬
function TSimpleLogMain.MakeLogStr(Session: HNsmSession; MsgInfo: TMessageInfo): WideString;
var
  Connection: HNsmConnection;
  UserAccount, Account, Name: WideString;
begin
  // ZbVLRlNV̎ʎq𓾂
  Connection := FNsmInfo.GetSessionInfoInt(Session, NMSI_CONNECTION);
  // [ŨAJEg𓾂
  UserAccount := FNsmInfo.GetConnectionInfo(Connection, NMCI_USER_ACCOUNT);

  Account := WideString(MsgInfo.lpFrom);
  if (Account = '') or (Account = UserAccount) then
  begin
    // [Ug̔̏ꍇ
    Name := FNsmInfo.GetConnectionInfo(Connection, NMCI_USER_NAME);
    Account := UserAccount;
  end else
    // ̃o̔̏ꍇ
    Name := FNsmInfo.GetSessionMemberInfo(Session, MsgInfo.lpFrom, NMMI_NAME);

  // Oۑp
  Result := Account + WideTab +Name + WideTab + FloatToStr(Now) + WideTab +
            TextAttrToStr(MsgInfo.lpTextAttribute^) + WideTab +
            EncodeControlChar(MsgInfo.lpBody) + WideCRLF;
end;

// RRGGBB <-> BBGGRR
function TSimpleLogMain.RGBSwap(const Value: Cardinal): Cardinal;
begin
  Result := (( Value and $FF0000 ) shr 16)
          + (Value and $FF00 )
          + (( Value and $FF ) shl 16);
end;

// sA^uGR[h
function TSimpleLogMain.EncodeControlChar(const Source: WideString): WideString;
var
  I: Integer;
begin
  Result := '';
  I := 1;
  while I <= Length(Source) do
  begin
    if Source[I] = WideChar('\') then
    begin
      Result := Result + WideString('\\');
      Inc(I);
    end else
    if Source[I] = WideTab then
    begin
      Result := Result + WideString('\t');
      Inc(I);
    end else
    if (I < Length(Source)) and
       (Source[I] = WideCR) and (Source[I + 1] = WideLF) then
    begin
      Result := Result + WideString('\n');
      Inc(I, 2);
    end else
    begin
      Result := Result + Source[I];
      Inc(I);
    end;
  end;
end;

// CSS݊ɕϊĂ݂
function TSimpleLogMain.TextAttrToStr(TextAttr: TTextAttributeInfo): WideString;
begin
  Result := '';
  if TextAttr.lpFontName <> '' then
    Result := Result + Format('font-family:%s;', [WideString(TextAttr.lpFontName)]);
  if TextAttr.nFontSize > -1 then
    Result := Result + Format('font-size:%dpt;', [TextAttr.nFontSize]);
  if TextAttr.nFontColor > -1 then
    Result := Result + Format('color:#%s;', [IntToHex(RGBSwap(TextAttr.nFontColor), 6)]);
  if TextAttr.nBgColor > -1 then
    Result := Result + Format('background-color:#%s;', [IntToHex(RGBSwap(TextAttr.nBgColor), 6)]);
  if (TextAttr.nStyles and NMFS_BOLD) <> 0 then
    Result := Result + 'font-weight:bold;';
  if (TextAttr.nStyles and NMFS_ITALIC) <> 0 then
    Result := Result + 'font-style:italic;';
  if (TextAttr.nStyles and NMFS_UNDERLINE) <> 0 then
    Result := Result + 'text-decoration:underline;';
  if (TextAttr.nStyles and NMFS_STRIKEOUT) <> 0 then
    Result := Result + 'text-decoration:line-through;';
end;

// Ot@Cɕۑ
procedure TSimpleLogMain.SaveLog(const FileName: String; const LogStr: WideString);
var
  FHandle: Integer;
  LogDir: String;
begin
  LogDir := ExtractFilePath(FileName);

  // fBNgȂΌ@
  if not DirectoryExists(LogDir) then
    ForceDirectories(LogDir);
  // Ot@CȂ΍
  if not FileExists(FileName) then
    FHandle := FileCreate(FileName)
  else
    FHandle := FileOpen(FileName, fmOpenWrite or fmShareDenyWrite);
  if FHandle < 0 then Exit;
  try
    // t@C̏I[ɏ
    FileSeek(FHandle, 0, 2);
    FileWrite(FHandle, PWideChar(LogStr)^, Length(LogStr) * 2);
  finally
    FileClose(FHandle);
  end;
end;

// -----------------------------------------------------------------------------
// bZ[WMCxg
//  wParam  : MZbVnh
//  lParam  : PMessageInfo
//  Return  : 0
function OnSendMessage(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  SimpleLogMain.SaveMessage(wParam, PMessageInfo(lParam)^);
  Result := 0;
end;

// bZ[WMCxg
//  wParam  : MZbVnh
//  lParam  : PMessageInfo
//  Return  : 0
function OnReceiveMessage(wParam, lParam: Cardinal): Integer; Stdcall;
begin
  SimpleLogMain.SaveMessage(wParam, PMessageInfo(lParam)^);
  Result := 0;
end;

// õAJEg烍Ot@C̃pX𓾂ƎT[rX(SimpleUIƘAg)
//  wParam : PGetLogFileName
//  lParam : 0
//  Return : obt@ɏ񂾃TCY
function DoGetLogFileName(wParam, lParam: Cardinal): Integer;
var
  GLFNI: TGetLogFileNameInfo;
  LogName: String;
begin
  GLFNI := PGetLogFileNameInfo(wParam)^;
  LogName := SimpleLogMain.GetWorkDir + 'Logs\' +
        GLFNI.lpProtocol + '\' +
        GLFNI.lpUserAccount + '\' +
        GLFNI.lpAccount + '.log';
  lstrcpyn(GLFNI.lpLogName, PChar(LogName), GLFNI.nBuffSize);
  Result := lstrlen(GLFNI.lpLogName);
end;

// -----------------------------------------------------------------------------

initialization
  SimpleLogMain := TSimpleLogMain.Create;

finalization
  SimpleLogMain.Free;

end.
