unit UFrmAbout;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, StdCtrls, ActnList, ExtCtrls, ExSpeedButton, USkinResource,
  ExButton, ExPanel, UNsmConsts, UNsmTypes, ComCtrls, Menus,
  ExRichEdit, UVersionInfo, Clipbrd, USimpleUICore, (*ExLabel,*) ResizeArea;

type
  TFrmAbout = class(TFrmBase)
    lblSystemTitle: TLabel;
    lblSystemCopy: TLabel;
    btnOk: TExButton;
    lblPlugins: TLabel;
    lblSystemVersion: TLabel;
    imgIcon: TImage;
    redPlugins: TExRichEdit;
    btnCopyInfo: TExButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure btnCopyInfoClick(Sender: TObject);
    procedure redPluginsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure redPluginsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure redPluginsURLClick(Sender: TObject; URL: WideString);
  private
    procedure GetModuleInformations;
  public
  end;

implementation

const
  EasterEggs: array[0..0] of String = (
    '    (ͥ) I love 2ch !'#13#10 +
    '    REGNESSEM  2ch Ă܂B'
  );

{$R *.dfm}

procedure TFrmAbout.GetModuleInformations;
var
  Modules: TStringList;
  I: Integer;
begin
  Modules := TStringList.Create;
  try
    lblSystemTitle.Caption :=
        SimpleUICore.GetInfo.GetPluginInfo(NMM_SYSTEM, NMPI_TITLE);
    lblSystemVersion.Caption :=
        'Version ' + SimpleUICore.GetInfo.GetPluginInfo(NMM_SYSTEM, NMPI_PLUGINVER);
    lblSystemCopy.Caption :=
        SimpleUICore.GetInfo.GetPluginInfo(NMM_SYSTEM, NMPI_COPYRIGHT);

    SimpleUICore.GetModuleList(Modules);
    redPlugins.Text := '';
    for I := 0 to Modules.Count - 1 do
    begin
      redPlugins.SelAttributes.Style := [fsBold];
      redPlugins.SelText := '"' +
          SimpleUICore.GetInfo.GetPluginInfo(Modules[I], NMPI_TITLE) + '" ' +
          SimpleUICore.GetInfo.GetPluginInfo(Modules[I], NMPI_PLUGINVER) + #13#10;
      redPlugins.SelAttributes.Style := [];
      redPlugins.SelText :=
          SimpleUICore.GetInfo.GetPluginInfo(Modules[I], NMPI_COPYRIGHT);
      if I < Modules.Count - 1 then
        redPlugins.SelText := #13#10;
    end;
  finally
    Modules.Free;
  end;
end;

procedure TFrmAbout.FormCreate(Sender: TObject);
begin
  inherited;
  Caption := 'o[W';
  Sizeable := False;
  redPlugins.AutoURLDetect := True;  
end;

procedure TFrmAbout.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  Action := caFree;
end;

procedure TFrmAbout.FormShow(Sender: TObject);
begin
  inherited;
  GetModuleInformations;
  imgIcon.Picture.Assign(Self.Icon);
end;

procedure TFrmAbout.btnCopyInfoClick(Sender: TObject);
var
  Modules: TStringList;
  I: Integer;
  InfoStr: String;
begin
  inherited;
  InfoStr :=
    'OS :'#13#10'  ' + GetWin32VersionInfo + #13#10 +
    'System :'#13#10'  ' + lblSystemTitle.Caption + ' ' +
    lblSystemVersion.Caption + #13#10 +
    'Plugins :'#13#10;
  Modules := TStringList.Create;
  try
    SimpleUICore.GetModuleList(Modules);
    for I := 0 to Modules.Count - 1 do
      InfoStr := InfoStr + '  "' +
          SimpleUICore.GetInfo.GetPluginInfo(Modules[I], NMPI_TITLE) + '" ' +
          SimpleUICore.GetInfo.GetPluginInfo(Modules[I], NMPI_PLUGINVER) + #13#10;
  finally
    Modules.Free;
  end;
  Clipboard.SetTextBuf(PChar(InfoStr));
end;

procedure TFrmAbout.redPluginsDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
  inherited;
  redPlugins.Text :=  #13#10 + EasterEggs[Trunc(Random(Length(EasterEggs)))];
  redPlugins.ReadOnly := False;
end;

procedure TFrmAbout.redPluginsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  inherited;
  Accept := (Source = imgIcon);
end;

procedure TFrmAbout.redPluginsURLClick(Sender: TObject; URL: WideString);
begin
  inherited;
  SimpleUICore.OpenURL(URL);
end;

end.
