unit UFrmChat;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseContainer, Menus, ExtCtrls, ActnList, ExTabSet, ExPanel,
  ExSpeedButton, StdCtrls, UStrResource, USkinResource, ComCtrls, ToolWin,
  UConfig, ResizeArea, UFrmBase;

type
  TFrmChat = class(TFrmBaseContainer)
    MainMenu: TMainMenu;
    mnuFile: TMenuItem;
    mnuCommands: TMenuItem;
    CoolBar: TCoolBar;
    MenuBar: TToolBar;
    mnuEdit: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
  protected
    procedure UpdateSkinObjects; override;
    procedure SetActiveDockedForm(Value: TFrmBase); override;
  public
    procedure UpdateActions; override;  
    procedure ApplyConfig; override;
    procedure ApplyPrivateConfig; override;
    procedure UpdateConfig; override;
    procedure FloatWindow(Form: TFrmBase); override;
  end;

var
  FrmChat: TFrmChat;

implementation

uses
  UFrmSession;

{$R *.dfm}

procedure TFrmChat.ApplyConfig;
begin
  inherited;
  if Config.ChatTransparency > 0 then
  begin
    AlphaBlend := True;
    AlphaBlendValue := (100 - Config.ChatTransparency) * 255 div 100;
  end else
    AlphaBlend := False;
end;

procedure TFrmChat.ApplyPrivateConfig;
begin
  inherited;
  with Config do
  begin
    SetBounds(ChatLeft, ChatTop, ChatWidth, ChatHeight);
    WindowState := ChatWinState;
    StayOnTop := ChatStayOnTop;
    SetTabSetPosition(ChatTabPosition);
  end;
end;

procedure TFrmChat.UpdateConfig;
var
  R: TRect;
begin
  inherited;
  R := NormalWindowRect;
  Config.ChatWidth    := R.Right - R.Left;
  Config.ChatHeight   := R.Bottom - R.Top;
  Config.ChatLeft     := R.Left;
  Config.ChatTop      := R.Top;
  Config.ChatWinState := WindowState;
  Config.ChatStayOnTop    := StayOnTop;
  Config.ChatTabPosition  := TabSet.TabPosition;
end;

procedure TFrmChat.UpdateActions;
begin
  inherited;
end;

procedure TFrmChat.UpdateSkinObjects;
begin
  inherited;
  MainMenu.Images := SkinResources.MenuImages;  
end;

procedure TFrmChat.FloatWindow(Form: TFrmBase);
begin
  inherited;
  Form.StayOnTop := Self.StayOnTop;
end;

procedure TFrmChat.SetActiveDockedForm(Value: TFrmBase);
begin
  inherited;
  SyncMenuItems([mnuFile, mnuCommands, mnuEdit]);
end;

procedure TFrmChat.FormCreate(Sender: TObject);
begin
  inherited;
  WindowKind := wkChat;
  Caption := RS_FORM_CHATTITLE;
end;

procedure TFrmChat.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  Action := caFree;
end;

procedure TFrmChat.FormDestroy(Sender: TObject);
begin
  inherited;
  FrmChat := nil;
end;

procedure TFrmChat.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  I: Integer;
begin
  inherited;
  for I := TabSet.Items.Count - 1 downto 0 do
    TCustomForm(TabSet.Items[I].Data).Close;
  CanClose := (TabSet.Items.Count = 0);
end;

procedure TFrmChat.FormActivate(Sender: TObject);
var
  Form: TCustomForm;
begin
  inherited;
  Form := ActiveDockedForm;
  if Assigned(Form) and (Form is TFrmSession) then
    TFrmSession(Form).ResetUnreadCount;
end;

end.
