unit UFrmEditNotify;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, StdCtrls, ExButton, Menus, ExtCtrls, ActnList,
  ExPanel, ExSpeedButton, UStrResource, UNotify, uOpenSaveDialogEx,
  ResizeArea;

type
  TFrmEditNotify = class(TFrmBase)
    btnOk: TExButton;
    btnCancel: TExButton;
    edtSoundFile: TEdit;
    lblSoundFile: TLabel;
    cbSoundEnabled: TCheckBox;
    cbNotifyEnabled: TCheckBox;
    btnSoundFile: TExButton;
    OpenDialog: TOpenDialogEx;
    btnPlaySound: TExButton;
    procedure FormCreate(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure btnSoundFileClick(Sender: TObject);
    procedure btnPlaySoundClick(Sender: TObject);
  private
    FNotify: TEventNotifyItem;
  public
    procedure SetNotify(ANotify: TEventNotifyItem);
  end;

implementation

{$R *.dfm}

procedure TFrmEditNotify.FormCreate(Sender: TObject);
begin
  inherited;
  Caption := RS_FORM_EDITNOTIFY;
  Sizeable := False;
end;

procedure TFrmEditNotify.SetNotify(ANotify: TEventNotifyItem);
begin
  FNotify := ANotify;
  cbSoundEnabled.Checked := FNotify.SoundEnabled;
  cbNotifyEnabled.Checked := FNotify.NotifyEnabled;
  edtSoundFile.Text := FNotify.SoundFileName;
end;

procedure TFrmEditNotify.btnOkClick(Sender: TObject);
begin
  inherited;
  FNotify.SoundEnabled := cbSoundEnabled.Checked;
  FNotify.NotifyEnabled := cbNotifyEnabled.Checked;
  FNotify.SoundFileName := edtSoundFile.Text;
end;

procedure TFrmEditNotify.btnSoundFileClick(Sender: TObject);
begin
  inherited;
  OpenDialog.FileName := edtSoundFile.Text;
  if OpenDialog.Execute then
    edtSoundFile.Text := OpenDialog.FileName;
end;

procedure TFrmEditNotify.btnPlaySoundClick(Sender: TObject);
var
  Temp: TEventNotifyItem;
begin
  inherited;
  Temp := TEventNotifyItem.Create(FNotify.NotifyType);
  Temp.Assign(FNotify);
  Temp.SoundFileName := edtSoundFile.Text;
  Temp.PlaySound(True);
  temp.Free;
end;

end.
