unit UFrmEditProfile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmQuickLogin, ActnList, ResizeArea, StdCtrls, ExButton, ExPanel,
  ExSpeedButton, UStrResource;

type
  TFrmEditProfile = class(TFrmQuickLogin)
    edtProfileName: TEdit;
    lblProfileName: TLabel;
    cbAutoConnect: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure edtAccountChange(Sender: TObject);
  private
    function GetProfileName: String;
    function GetAutoConnect: Boolean;
    procedure SetProfileName(Value: String);
    procedure SetAutoConnect(Value: Boolean);
  public
    property ProfileName: String read GetProfileName write SetProfileName;
    property AutoConnect: Boolean read GetAutoConnect write SetAutoConnect;
  end;

implementation

{$R *.dfm}

function TFrmEditProfile.GetProfileName: String;
begin
  Result := edtProfileName.Text;
end;

function TFrmEditProfile.GetAutoConnect: Boolean;
begin
  Result := cbAutoConnect.Checked;
end;

procedure TFrmEditProfile.SetProfileName(Value: String);
begin
  edtProfileName.Text := Value;
end;

procedure TFrmEditProfile.SetAutoConnect(Value: Boolean);
begin
  cbAutoConnect.Checked := Value;
end;

procedure TFrmEditProfile.FormCreate(Sender: TObject);
begin
  inherited;
  Caption := RS_FORM_PROFILETITLE;  
  edtProfileName.Text := RS_NEWPROFILENAME;
end;

procedure TFrmEditProfile.edtAccountChange(Sender: TObject);
begin
  inherited;
  btnOk.Enabled := (Length(edtAccount.Text) > 0) and
                   (Length(edtProfileName.Text) > 0) and
                   (Length(edtPassword.Text) > 0);
end;

end.
