unit UFrmInput;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, StdCtrls, ExButton, ExtCtrls, ActnList, ExPanel,
  ExSpeedButton, Menus, ResizeArea, ComCtrls, ExRichEdit;

type
  TFrmInput = class(TFrmBase)
    btnOk: TExButton;
    btnCancel: TExButton;
    lblPrompt: TLabel;
    edtValue: TExRichEdit;
    procedure FormCreate(Sender: TObject);
    procedure edtValueChange(Sender: TObject);
    procedure edtValueKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edtValueEnter(Sender: TObject);
  private
    FMultiLine: Boolean;
    function GetPrompt: String;
    procedure SetPrompt(S: String);
    function GetValue: WideString;
    procedure SetValue(S: WideString);
    procedure SetMultiLine(Value: Boolean);
  public
    property Prompt: String read GetPrompt write SetPrompt;
    property Value: WideString read GetValue write SetValue;
    property MultiLine: Boolean read FMultiLine write SetMultiLine;
  end;

function ExInputBox(Owner: TCustomForm; const ACaption, APrompt: String;
  var AValue: WideString; MultiLine: Boolean = False): Boolean;

implementation

{$R *.dfm}

function ExInputBox(Owner: TCustomForm; const ACaption, APrompt: String;
  var AValue: WideString; MultiLine: Boolean = False): Boolean;
var
  Form: TFrmInput;
begin
  Form := TFrmInput.CreateAsDialog(Owner);
  try
    Form.Caption := ACaption;
    Form.Prompt := APrompt;
    Form.Value := AValue;
    Form.MultiLine := MultiLine;
    if Form.ShowModal = mrOk then
    begin
      AValue := Form.Value;
      Result := True;
    end else
      Result := False;
  finally
    Form.Release;
  end;
end;

function TFrmInput.GetPrompt: String;
begin
  Result := lblPrompt.Caption;
end;

procedure TFrmInput.SetPrompt(S: String);
begin
  lblPrompt.Caption := S;
end;

function TFrmInput.GetValue: WideString;
begin
  Result := edtValue.WideText;
end;

procedure TFrmInput.SetValue(S: WideString);
begin
  edtValue.WideText := S;
end;

procedure TFrmInput.SetMultiLine(Value: Boolean);
begin
  FMultiLine := Value;
  if not FMultiLine then
  begin
    ClientHeight := 140;
    edtValue.Height := 20;
    edtValue.ScrollBars := ssNone;
    edtValue.WordWrap := False;
    edtValue.WantReturns := False;
  end else
  begin
    ClientHeight := 200;
    edtValue.Height := 80;
    edtValue.ScrollBars := ssVertical;
    edtValue.WordWrap := True;
    edtValue.WantReturns := True;
  end;
end;

procedure TFrmInput.FormCreate(Sender: TObject);
begin
  inherited;
  Sizeable := False;
  edtValue.TextMode := tmPlainText;
end;

procedure TFrmInput.edtValueChange(Sender: TObject);
begin
  inherited;
  btnOk.Enabled := (Length(edtValue.Text) > 0); 
end;

procedure TFrmInput.edtValueKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_RETURN then
    Key := $0;
end;

procedure TFrmInput.edtValueEnter(Sender: TObject);
begin
  inherited;
  edtValue.SelectAll;
end;

end.
