unit UFrmLogIn;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, ExtCtrls, ActnList, ExPanel, ExSpeedButton, StdCtrls,
  ExButton, UNsmUI, UNsmTypes, UNsmConsts, Menus, UStrResource;

type
  TFrmLogIn = class(TFrmBase)
    btnOK: TExButton;
    btnCancel: TExButton;
    cmbProtocol: TComboBox;
    lblProtocol: TLabel;
    edtAccount: TEdit;
    lblAccount: TLabel;
    edtPassword: TEdit;
    lblPassword: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure edtAccountChange(Sender: TObject);
  private
    function GetProtocol: String;
    function GetAccount: String;
    function GetPassword: String;
  public
    property Protocol: String read GetProtocol;
    property Account: String read GetAccount;
    property Password: String read GetPassword;
  end;

var
  FrmLogIn: TFrmLogIn;

implementation

{$R *.dfm}

function TFrmLogin.GetProtocol: String;
begin
  Result := cmbProtocol.Items[cmbProtocol.ItemIndex];
end;

function TFrmLogin.GetAccount: String;
begin
  Result := edtAccount.Text;
end;

function TFrmLogin.GetPassword: String;
begin
  Result := edtPassword.Text;
end;

procedure TFrmLogIn.FormCreate(Sender: TObject);
begin
  inherited;
  Caption := RS_FORM_LOGINTITLE;
  Sizeable := False;
end;

function EnumProtocol(lpProtocol: PChar; nData: Integer): Integer; StdCall;
begin
  FrmLogin.cmbProtocol.Items.Add(lpProtocol);
  Result := 0;
end;

procedure TFrmLogIn.FormShow(Sender: TObject);
begin
  inherited;
  // vgR
  cmbProtocol.Items.Clear;
  NsmUI.InitInfo.CallService(NMS_SYSTEM_ENUMPROTOCOLS,
      Cardinal(@EnumProtocol), 0);
  cmbProtocol.ItemIndex := 0;
end;

procedure TFrmLogIn.edtAccountChange(Sender: TObject);
begin
  inherited;
  btnOk.Enabled := (Length(edtAccount.Text) > 0) and
                   (Length(edtPassword.Text) > 0);
end;

end.
