unit UFrmPrivacy;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, ExButton, StdCtrls, ExtCtrls, ComCtrls, Menus,
  ActnList, ResizeArea, ExPanel, ExSpeedButton,  USkinResource,
  UNsmUIPluginMainEx;

type
  TFrmPrivacy = class(TFrmBase)
    PageControl: TPageControl;
    tsBlockList: TTabSheet;
    SrcLabel: TLabel;
    DstLabel: TLabel;
    Label1: TLabel;
    lvAllowList: TListView;
    lvBlockList: TListView;
    TabSheet1: TTabSheet;
    Label2: TLabel;
    lvReverseList: TListView;
    btnOk: TExButton;
    btnCancel: TExButton;
    btnBlock: TExButton;
    btnBlockAll: TExButton;
    btnAllow: TExButton;
    btnAllowAll: TExButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    FConnection: TNsmUIConnection;
    procedure SetConnection(Value: TNsmUIConnection);
    procedure UpdateAllowList;
    procedure UpdateBlockList;
    procedure UpdateReverseList;
  protected
    procedure UpdateSkinObjects; override;
  public
    property Connection: TNsmUIConnection read FConnection write SetConnection;
  end;

implementation

{$R *.dfm}

procedure TFrmPrivacy.UpdateSkinObjects;
begin
  Inherited;
  lvAllowList.SmallImages := SkinResources.StateImages;
  lvBlockList.SmallImages := SkinResources.StateImages;
  lvReverseList.SmallImages := SkinResources.StateImages;
end;

procedure TFrmPrivacy.SetConnection(Value: TNsmUIConnection);
begin
  FConnection := Value;
  if Assigned(FConnection) then
  begin
    UpdateAllowList;
    UpdateBlockList;
    UpdateReverseList;
  end else
  begin
    lvAllowList.Clear;
    lvBlockList.Clear;
    lvReverseList.Clear;
  end;
end;

procedure TFrmPrivacy.UpdateAllowList;
var
  I: Integer;
begin
  lvAllowList.Clear;
  for I := 0 to FConnection.AllowMembers.Count - 1 do
  begin
    with lvAllowList.Items.Add do
    begin
      Caption := FConnection.AllowMembers[I].Name;
      ImageIndex := 0;
    end;
  end;
end;

procedure TFrmPrivacy.UpdateBlockList;
var
  I: Integer;
begin
  lvBlockList.Clear;
  for I := 0 to FConnection.BlockMembers.Count - 1 do
  begin
    with lvBlockList.Items.Add do
    begin
      Caption := FConnection.BlockMembers[I].Name;
      ImageIndex := 0;
    end;
  end;
end;

procedure TFrmPrivacy.UpdateReverseList;
var
  I: Integer;
begin
  lvReverseList.Clear;
  for I := 0 to FConnection.ReverseMembers.Count - 1 do
  begin
    with lvReverseList.Items.Add do
    begin
      Caption := FConnection.ReverseMembers[I].Name;
      ImageIndex := 0;
    end;
  end;
end;

procedure TFrmPrivacy.FormCreate(Sender: TObject);
begin
  inherited;
  Sizeable := False;
  Caption := 'vCoV[ݒ';
end;

procedure TFrmPrivacy.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  Action := caFree;
end;

end.
