unit UFrmQuickLogin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, ExtCtrls, ActnList, ExPanel, ExSpeedButton, StdCtrls,
  ExButton, UNsmTypes, UNsmConsts, Menus, UStrResource, ResizeArea,
  USimpleUICore;

type
  TFrmQuickLogin = class(TFrmBase)
    btnOK: TExButton;
    btnCancel: TExButton;
    cmbProtocol: TComboBox;
    lblProtocol: TLabel;
    edtAccount: TEdit;
    lblAccount: TLabel;
    edtPassword: TEdit;
    lblPassword: TLabel;
    cbHiddenLogIn: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure edtAccountChange(Sender: TObject);
  private
    function GetProtocol: String;
    function GetAccount: String;
    function GetPassword: String;
    function GetStatus: Integer;
    procedure SetProtocol(Value: String);
    procedure SetAccount(Value: String);
    procedure SetPassword(Value: String);
    procedure SetStatus(Value: Integer);
  public
    property Protocol: String read GetProtocol write SetProtocol;
    property Account: String read GetAccount write SetAccount;
    property Password: String read GetPassword write SetPassword;
    property Status: Integer read GetStatus write SetStatus;
  end;

implementation

{$R *.dfm}

function TFrmQuickLogin.GetProtocol: String;
begin
  Result := cmbProtocol.Items[cmbProtocol.ItemIndex];
end;

function TFrmQuickLogin.GetAccount: String;
begin
  Result := edtAccount.Text;
end;

function TFrmQuickLogin.GetPassword: String;
begin
  Result := edtPassword.Text;
end;

function TFrmQuickLogin.GetStatus: Integer;
begin
  if cbHIddenLogIn.Checked then
    Result := NMST_HIDDEN
  else
    Result := NMST_ONLINE;
end;

procedure TFrmQuickLogin.SetProtocol(Value: String);
begin
  cmbProtocol.ItemIndex := cmbProtocol.Items.IndexOf(Value);
end;

procedure TFrmQuickLogin.SetAccount(Value: String);
begin
  edtAccount.Text := Value;
end;

procedure TFrmQuickLogin.SetPassword(Value: String);
begin
  edtPassword.Text := Value;
end;

procedure TFrmQuickLogin.SetStatus(Value: Integer);
begin
  cbHIddenLogIn.Checked := (Value = NMST_HIDDEN);
end;

function EnumProtocol(lpProtocol: PChar; nData: Integer): Integer; StdCall;
begin
  TStrings(nData).Add(lpProtocol);
  Result := 0;
end;

procedure TFrmQuickLogin.FormCreate(Sender: TObject);
begin
  inherited;
  Caption := RS_FORM_QUICKLOGINTITLE;
  Sizeable := False;

  // vgR
  cmbProtocol.Items.Clear;
  SimpleUICore.CallService(NMS_SYSTEM_ENUMPROTOCOLS,
      Cardinal(@EnumProtocol), Cardinal(cmbProtocol.Items));
  cmbProtocol.ItemIndex := 0;
end;

procedure TFrmQuickLogin.edtAccountChange(Sender: TObject);
begin
  inherited;
  btnOk.Enabled := (Length(edtAccount.Text) > 0) and
                   (Length(edtPassword.Text) > 0);
end;

end.
