unit UFrmSession;

interface

uses
  Windows, Messages, SysUtils, Graphics, Controls, Forms, UFrmWebBrowser,
  Classes, ActnList, ExtCtrls, StdCtrls, ExTabSet, ComCtrls,  Menus, ToolWin,
  USkinResource, ExSpeedButton, ExButton, ExPanel, UNsmConsts,
  UStrResource, UFrmBase, UConfig, UNsmTypes, OleCtrls, SHDocVw_TLB, MSHTML_TLB,
  ActiveX, USimpleUICore, StrUtils, DateUtils, UNsmUtils, Dialogs,
  ExRichEdit, (*ExLabelList,*) Clipbrd, ResizeArea, UWideUtils,
  uOpenSaveDialogEx, ImgList, ExToolBar, ExSplitter, UNsmUIPluginMainEx,
  FontDialogEx;

type
  TFrmSession = class(TFrmWebBrowser)
    MainMenu: TMainMenu;
    mnuFile: TMenuItem;
    mnuCommands: TMenuItem;
    CoolBar: TCoolBar;
    MenuBar: TToolBar;
    pnlChat: TExPanel;
    pnlInfo: TExPanel;
    lblFrom: TLabel;
    pnlInput: TExPanel;
    pnlButton: TExPanel;
    btnSend: TExButton;
    pnlStatus: TExPanel;
    pnlStatus2: TExPanel;
    lblStatus1: TLabel;
    actInvite: TAction;
    I1: TMenuItem;
    actCloseSession: TAction;
    mnuClose: TMenuItem;
    imgSessionStatus: TImage;
    tmrConnecting: TTimer;
    actSendMessage: TAction;
    pnlWebBrowser: TPanel;
    actFont: TAction;
    Font1: TMenuItem;
    N1: TMenuItem;
    FontDialog: TFontDialogEx;
    redInput: TExRichEdit;
    lblTo: TLabel;
    actClearPastMsgs: TAction;
    C1: TMenuItem;
    N2: TMenuItem;
    actSave: TAction;
    mnuSave: TMenuItem;
    SaveDialog: TSaveDialogEx;
    N3: TMenuItem;
    mnuEdit: TMenuItem;
    actCopy: TAction;
    actCut: TAction;
    actPaste: TAction;
    actDelete: TAction;
    actSelectAll: TAction;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Delete1: TMenuItem;
    Paste1: TMenuItem;
    SelectAll1: TMenuItem;
    N4: TMenuItem;
    actUndo: TAction;
    Undo1: TMenuItem;
    N5: TMenuItem;
    actStayOnTop: TAction;
    T1: TMenuItem;
    N6: TMenuItem;
    imlToolIcon: TImageList;
    actFontBold: TAction;
    actFontItalic: TAction;
    actFontUnderline: TAction;
    actFontStrikeout: TAction;
    Splitter: TExSplitter;
    ToolBar: TExToolBar;
    cmbFontName: TComboBox;
    ToolButton4: TToolButton;
    tbTextColor: TToolButton;
    ToolButton3: TToolButton;
    tbBold: TToolButton;
    tbItalic: TToolButton;
    tbUnderline: TToolButton;
    tbStrikeOUt: TToolButton;
    cmbFontSize: TComboBox;
    ToolButton1: TToolButton;
    tbBgColor: TToolButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure actInviteExecute(Sender: TObject);
    procedure actCloseSessionExecute(Sender: TObject);
    procedure pnlInfoResize(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure tmrConnectingTimer(Sender: TObject);
    procedure actSendMessageExecute(Sender: TObject);
    procedure pnlWebBrowserResize(Sender: TObject);
    procedure actFontExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure actClearPastMsgsExecute(Sender: TObject);
    procedure actSaveExecute(Sender: TObject);
    procedure mnuCloseClick(Sender: TObject);
    procedure actUndoExecute(Sender: TObject);
    procedure actCutExecute(Sender: TObject);
    procedure actCopyExecute(Sender: TObject);
    procedure actPasteExecute(Sender: TObject);
    procedure actDeleteExecute(Sender: TObject);
    procedure actSelectAllExecute(Sender: TObject);
    procedure actStayOnTopExecute(Sender: TObject);
    procedure actFontBoldExecute(Sender: TObject);
    procedure actFontItalicExecute(Sender: TObject);
    procedure actFontUnderlineExecute(Sender: TObject);
    procedure actFontStrikeoutExecute(Sender: TObject);
    procedure cmbFontNameChange(Sender: TObject);
    procedure ToolBarCustomDraw(Sender: TToolBar; const ARect: TRect;
      var DefaultDraw: Boolean);
    procedure tbTextColorMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure cmbFontSizeSelect(Sender: TObject);
    procedure redInputEnter(Sender: TObject);
    procedure redInputExit(Sender: TObject);
    procedure cmbFontSizeKeyPress(Sender: TObject; var Key: Char);
  private
    FSession: TNsmUISession;
    FAnimPos: Integer;
    FUnreadCount: Integer;
    procedure UpdateCaption;
    procedure InitFontBar;
    procedure UpdateFontBar;
    procedure TextColorSelect(Sender: TObject; AColor: TColor);
    procedure BgColorSelect(Sender: TObject; AColor: TColor);
  protected
    procedure UpdateSkinObjects; override;
    procedure SetParent(AParent: TWinControl); override;
    procedure DockToContainer; override;
  public
    procedure UpdateActions; override;  
    procedure ResetUnreadCount;
    procedure ApplyConfig; override;
    procedure ApplyPrivateConfig; override;
    procedure UpdateConfig; override;
    procedure UpdateSessionInfo;
    procedure UpdateMemberList;
    procedure DoSendMessage(MsgInfo: TMessageInfo);
    procedure DoReceiveMessage(MsgInfo: TMessageInfo);
    property Session: TNsmUISession read FSession write FSession;
  end;

implementation

uses UFrmChat, UFrmInput, UFrmMain, UFrmColor;

{$R *.dfm}

procedure TFrmSession.ApplyConfig;
begin
  inherited;
  MsgHead := Config.MsgHead;
  // DoubleBuffered
  pnlInfo.DoubleBuffered := Config.DoubleBuffered;
  pnlChat.DoubleBuffered := Config.DoubleBuffered;
  pnlInput.DoubleBuffered := Config.DoubleBuffered;
  pnlStatus.DoubleBuffered := Config.DoubleBuffered;
  pnlStatus2.DoubleBuffered := Config.DoubleBuffered;
end;

function FontToStr(font: TFont; bgcolor: TColor): string;
begin
   Result := '';
   Result := Result + font.Name + '#9';
   Result := Result + IntToStr(font.Size) + '#9';
   Result := Result + IntToStr(Integer(font.Color)) + '#9';
   if(fsBold in font.Style) then
      Result := Result + '-1#9'
   else
      Result := Result + '0#9';
   if(fsItalic in font.Style) then
      Result := Result + '-1#9'
   else
      Result := Result + '0#9';
   if(fsUnderline in font.Style) then
      Result := Result + '-1#9'
   else
      Result := Result + '0#9';
   if(fsStrikeout in font.Style) then
      Result := Result + '-1#9'
   else
      Result := Result + '0#9';
   Result := Result + IntToStr(Integer(bgcolor));
end;

function tok(sep: string; var s: string): string;
function isoneof(c, s: string): Boolean;
var iTmp: integer;
begin
   Result := False;
   for iTmp := 1 to Length(s) do
   begin
      if c = Copy(s, iTmp, 1) then
      begin
         Result := True;
         Exit;
      end;
   end;
end;
var c, t: string;
begin
   if s = '' then
   begin
      Result := s;
      Exit;
   end;
   c := Copy(s, 1, 1);
   while isoneof(c, sep) do
   begin
      s := Copy(s, 2, Length(s) - 1);
      c := Copy(s, 1, 1);
   end;
   t := '';
   while (not isoneof(c, sep)) and (s <> '') do
   begin
      t := t + c;
      s := Copy(s, 2, length(s)-1);
      c := Copy(s, 1, 1);
   end;
   Result := t;
end;

procedure StrToFont(str: string; font: TFont; var bgcolor: TColor);
begin
   if str = '' then Exit;
   font.Name := tok('#9',str);
   font.Size := StrToInt(tok('#9',str));
   font.Color := TColor(StrToInt(tok('#9',str)));
   font.Style := [];
   if( StrToInt(tok('#9',str)) < 0 ) then font.Style := font.Style + [fsBold];
   if( StrToInt(tok('#9',str)) < 0 ) then font.Style := font.Style + [fsItalic];
   if( StrToInt(tok('#9',str)) < 0 ) then font.Style := font.Style + [fsUnderline];
   if( StrToInt(tok('#9',str)) < 0 ) then font.Style := font.Style + [fsStrikeout];
   bgcolor := TColor(StrToInt(tok('#9',str)));
end;

procedure TFrmSession.ApplyPrivateConfig;
var
  BgColor: TColor;
begin
  inherited;
  StayOnTop := Config.ChatStayOnTop;

  BgColor := redInput.Color;
  StrToFont(Config.MsgFont, redInput.Font, BgColor);
  redInput.Color := BgColor;
  UpdateFontBar;
end;

procedure TFrmSession.UpdateConfig;
begin
  inherited;
  Config.ChatStayOnTop := StayOnTop;
  Config.MsgFont := FontToStr(redInput.Font, redInput.Color);
end;

procedure TFrmSession.UpdateSkinObjects;
begin
  inherited;
  MainMenu.Images := SkinResources.MenuImages;
  actUndo.ImageIndex := MENUICON_UNDO;
  actCut.ImageIndex := MENUICON_CUT;
  actCopy.ImageIndex := MENUICON_COPY;
  actDelete.ImageIndex := MENUICON_DELETE;
  actPaste.ImageIndex := MENUICON_PASTE;
end;

procedure TFrmSession.UpdateActions;
begin
  inherited;
  actUndo.Enabled := redInput.Focused and redInput.CanUndo;
  actCut.Enabled := redInput.Focused and (redInput.SelLength > 0);
  actCopy.Enabled := redInput.Focused and (redInput.SelLength > 0);
  actPaste.Enabled := redInput.Focused and Clipboard.HasFormat(CF_TEXT);
  actDelete.Enabled := redInput.Focused and (redInput.SelLength > 0);
  actStayOnTop.Checked := StayOnTop;
end;

procedure TFrmSession.SetParent(AParent: TWinControl);
begin
  inherited;
  if not Application.Terminated and (ControlCount > 0) then
    CoolBar.Visible := not Assigned(AParent);
end;

procedure TFrmSession.DockToContainer;
begin
  if not Assigned(FrmChat) then
    FrmChat := TFrmChat.Create(FrmMain);
  if not FrmChat.Visible then
    FrmChat.Show;
  Container := FrmChat;
  inherited;
end;

procedure TFrmSession.UpdateCaption;
begin
  if Assigned(FSession) then
  begin
    if FUnreadCount = 0 then
      Caption := FSession.Caption
    else
      Caption := FSession.Caption + Format('(%d)', [FUnreadCount]);
  end else
    Caption := RS_FORM_CHATTITLE;
end;

procedure TFrmSession.UpdateSessionInfo;
var
  ImgIdx: Integer;
begin
  UpdateCaption;
  if Assigned(FSession) then
  begin
    if Assigned(FSession.Connection) then
      lblFrom.Caption := Format('From : %s <%s>', [FSession.Connection.UserName,
          FSession.Connection.UserAccount]);
    case FSession.Status of
    NMCS_CONNECTED      :
    begin
      tmrConnecting.Enabled := False;
      lblStatus1.Caption := RS_NMCS_CONNECTED;
      ImgIdx := NMNI_CONNECT;
    end;
    NMCS_DISCONNECTING  :
    begin
      tmrConnecting.Enabled := True;
      lblStatus1.Caption := RS_NMCS_DISCONNECTING;
      ImgIdx := NMNI_DISCONNECT;
    end;
    NMCS_CONNECTING     :
    begin
      tmrConnecting.Enabled := True;
      lblStatus1.Caption := RS_NMCS_CONNECTING;
      ImgIdx := NMNI_DISCONNECT;
    end;
    else
    begin
      tmrConnecting.Enabled := False;
      lblStatus1.Caption := RS_NMCS_DISCONNECTED;
      ImgIdx := NMNI_DISCONNECT;
    end;    
    end;
    imgSessionStatus.Picture.Bitmap.Assign(nil);
    SkinResources.CommonImages.GetBitmap(ImgIdx, imgSessionStatus.Picture.Bitmap);
  end;
end;

procedure TFrmSession.UpdateMemberList;
var
  I: Integer;
begin
  lblTo.Caption := 'To : ';
  for I := 0 to FSession.Members.Count - 1 do
  begin
    lblTo.Caption := lblTo.Caption +
      Format('%s <%s>', [FSession.Members[I].Name,
      FSession.Members[I].Account]);
    if I < FSession.Members.Count - 1 then
      lblTo.Caption := lblTo.Caption + '; ';
  end;
  pnlInfo.Height := lblFrom.Height + lblTo.Height + pnlInfo.Padding * 2;
end;

procedure  TFrmSession.ResetUnreadCount;
begin
  FUnreadCount := 0;
  UpdateCaption;
end;

procedure TFrmSession.DoSendMessage(MsgInfo: TMessageInfo);
var
  Name, Account, Body: WideString;
  BgColor: TColor;
begin
  Name := FSession.Connection.UserName;
  Account := FSession.Connection.UserAccount;
  Body := MsgInfo.lpBody;
  if MsgInfo.lpTextAttribute.nBgColor <> -1 then
    BgColor := MsgInfo.lpTextAttribute.nBgColor
  else
    BgColor := clNone;
  OutputMessage(MakeMsgHeader(Name, Account, Now),
                MakeMsgBody(Body, MsgInfo.lpTextAttribute^), BgColor);
end;

procedure TFrmSession.DoReceiveMessage(MsgInfo: TMessageInfo);
var
  Name, Account, Body: WideString;
  BgColor: TColor;
  Idx: Integer;
begin
  Account := MsgInfo.lpFrom;
  Idx := FSession.Members.IndexOfAccount(MsgInfo.lpFrom);
  if Idx > -1 then
    Name := FSession.Members[Idx].Name
  else
    Name := MsgInfo.lpFrom;
  Body := MsgInfo.lpBody;
  if MsgInfo.lpTextAttribute.nBgColor <> -1 then
    BgColor := MsgInfo.lpTextAttribute.nBgColor
  else
    BgColor := clNone;
  OutputMessage(MakeMsgHeader(Name, Account, Now),
                MakeMsgBody(Body, MsgInfo.lpTextAttribute^), BgColor);
  Blink(3);
  if not (Showing and ParentFormActive) then
  begin
    Inc(FUnreadCount);
    UpdateCaption;
  end;
end;

procedure TFrmSession.InitFontBar;
var
  I: Integer;
begin
  cmbFontName.Clear;
  for I := 0 to Screen.Fonts.Count - 1 do
    if not AnsiStartsStr('@', Screen.Fonts[I]) then
      cmbFontName.Items.Add(Screen.Fonts[I]);
  UpdateFontBar;
end;

procedure TFrmSession.UpdateFontBar;
begin
  cmbFontName.ItemIndex := cmbFontName.Items.IndexOf(redInput.Font.Name);
  cmbFontSize.Text := IntToStr(redInput.Font.Size);

  actFontBold.Checked       := (fsBold in redInput.Font.Style);
  actFontItalic.Checked     := (fsItalic in redInput.Font.Style);
  actFontUnderline.Checked  := (fsUnderline in redInput.Font.Style);
  actFontStrikeout.Checked  := (fsStrikeOut in redInput.Font.Style);
end;

procedure TFrmSession.FormCreate(Sender: TObject);
begin
  WebBrowserParent := pnlWebBrowser;
  inherited;
  WindowKind := wkChat;
  Container := FrmChat;
  redInput.TextMode := tmPlainText;
  FUnreadCount := 0;
  InitFontBar;
end;

procedure TFrmSession.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  actCloseSession.Execute;
  Action := caFree;
end;

procedure TFrmSession.FormShow(Sender: TObject);
begin
  inherited;
  UpdateSessionInfo;
  UpdateMemberList;
  ResetUnreadCount;
  if redInput.CanFocus then
    redInput.SetFocus;
end;

procedure TFrmSession.FormActivate(Sender: TObject);
begin
  inherited;
  ResetUnreadCount;
end;

procedure TFrmSession.actInviteExecute(Sender: TObject);
var
  Account: WideString;
  OwnerForm: TCustomForm;
begin
  inherited;
  if Assigned(ParentForm) then
    OwnerForm := ParentForm
  else
    OwnerForm := Self;
  if ExInputBox(OwnerForm, '',
    'bɏ҂AJEg͂ĂB', Account) then
  begin
    FSession.InviteMember(Account);
  end;
end;

procedure TFrmSession.actCloseSessionExecute(Sender: TObject);
begin
  inherited;
  FSession.Close;
end;

procedure TFrmSession.pnlInfoResize(Sender: TObject);
begin
  inherited;
  lblFrom.AutoSize := False; lblFrom.AutoSize := True;
  lblTo.AutoSize := False; lblTo.AutoSize := True;
  pnlInfo.Height := lblFrom.Height + lblTo.Height + pnlInfo.Padding * 2;
end;

procedure TFrmSession.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  inherited;
  CanClose := True;
  if FSession.Members.Count > 1 then
  begin
    CanClose := (MessageBox(Handle,
      'EBhEƂ̃ZbṼCX^gbZ[W͎MłȂȂ܂B' +
      #13#10'̉bސȂĂ낵łH',
      PChar(String(Caption)), MB_ICONINFORMATION or MB_OKCANCEL) = ID_OK);
  end;
end;

procedure TFrmSession.tmrConnectingTimer(Sender: TObject);
begin
  inherited;
  imgSessionStatus.Picture.Bitmap.Assign(nil);
  SkinResources.CommonImages.GetBitmap(NMNI_CONNECT + (FAnimPos mod 2),
      imgSessionStatus.Picture.Bitmap);
  Inc(FAnimPos);
end;

procedure TFrmSession.actSendMessageExecute(Sender: TObject);
var
  MsgInfo: TMessageInfo;
  Attr: TTextAttributeInfo;
  Style: Integer;
  MsgBody: WideString;
begin
  inherited;
  if Length(redInput.Text) = 0 then Exit;
  // ȂsCRLFȊO̎悤Ȃ̂Œu
  MsgBody := WideReplaceStrEx(redInput.WideText,
      [WideCR, WideCRLF, WideLF, WideCRLF, WideChar($0B), WideCRLF]);

  Style := 0;
  if fsBold in redInput.Font.Style then
    Style := Style or NMFS_BOLD;
  if fsItalic in redInput.Font.Style then
    Style := Style or NMFS_ITALIC;
  if fsUnderline in redInput.Font.Style then
    Style := Style or NMFS_UNDERLINE;
  if fsStrikeout in redInput.Font.Style then
    Style := Style or NMFS_STRIKEOUT;
  with Attr do
  begin
    cbSize := SizeOf(Attr);
    lpFontName := PWideChar(WideString(redInput.Font.Name));
    nCharSet := redInput.Font.Charset;
    nFontSize := redInput.Font.Size;
    nFontColor := ColorToRGB(redInput.Font.Color);
    nBgColor := ColorToRGB(redInput.Color);
    nStyles := Style;
  end;
  with MsgInfo do
  begin
    cbSize := SizeOf(TMessageInfo);
    lpFrom := nil;
    lpBody := PWideChar(MsgBody);
    lpTextAttribute := @Attr;
    nFlags := 0;
  end;
  FSession.SendMessage(MsgInfo);
  redInput.Clear;
  if redInput.CanFocus then
    redInput.SetFocus;
end;

procedure TFrmSession.pnlWebBrowserResize(Sender: TObject);
begin
  inherited;
  AdjustWebBrowserBounds;
end;

procedure TFrmSession.actFontExecute(Sender: TObject);
begin
  inherited;
  FontDialog.Font := redInput.Font;
  if FontDialog.Execute then
  begin
    redInput.Font := FontDialog.Font;
    UpdateFontBar;
  end;
end;

procedure TFrmSession.actClearPastMsgsExecute(Sender: TObject);
begin
  inherited;
  ClearPastMsgs;
end;

procedure TFrmSession.actSaveExecute(Sender: TObject);
begin
  inherited;
  if SaveDialog.Execute then
  begin
    Screen.Cursor := crHourGlass;
    try
      case SaveDialog.FilterIndex of
      1: SaveToFile(SaveDialog.FileName, dtText);     // Plane Text
      2: SaveToFile(SaveDialog.FileName, dtUTF8Text); // UTF8 Text
      3: SaveToFile(SaveDialog.FileName, dtHtml);     // HTML
      end;
    finally
      Screen.Cursor := crDefault;
    end;
  end;
end;

procedure TFrmSession.mnuCloseClick(Sender: TObject);
begin
  inherited;
  if Assigned(Parent) and Assigned(Container) and
     Container.ContainsDockWindow(Self) then
    Container.Close
  else
    Close;
end;

procedure TFrmSession.actUndoExecute(Sender: TObject);
begin
  inherited;
  if redInput.Focused then
    redInput.Undo;
end;

procedure TFrmSession.actCutExecute(Sender: TObject);
begin
  inherited;
  if redInput.Focused then
    redInput.CutToClipboard;
end;

procedure TFrmSession.actCopyExecute(Sender: TObject);
begin
  inherited;
  if redInput.Focused then
    redInput.CopyToClipboard;
end;

procedure TFrmSession.actPasteExecute(Sender: TObject);
begin
  inherited;
  if redInput.Focused then
    redInput.PasteFromClipboard;
end;

procedure TFrmSession.actDeleteExecute(Sender: TObject);
begin
  inherited;
  if redInput.Focused then
    redInput.ClearSelection;
end;

procedure TFrmSession.actSelectAllExecute(Sender: TObject);
begin
  inherited;
  if redInput.Focused then
    redInput.SelectAll;
end;

procedure TFrmSession.actStayOnTopExecute(Sender: TObject);
begin
  inherited;
  if Assigned(Parent) and Assigned(Container) and
     Container.ContainsDockWindow(Self) then
    Container.StayOnTop :=  not StayOnTop;
  StayOnTop := not StayOnTop;
end;

procedure TFrmSession.actFontBoldExecute(Sender: TObject);
begin
  inherited;
  if actFontBold.Checked then
    redInput.Font.Style := redInput.Font.Style + [fsBold]
  else
    redInput.Font.Style := redInput.Font.Style - [fsBold];
end;

procedure TFrmSession.actFontItalicExecute(Sender: TObject);
begin
  inherited;
  if actFontItalic.Checked then
    redInput.Font.Style := redInput.Font.Style + [fsItalic]
  else
    redInput.Font.Style := redInput.Font.Style - [fsItalic];
end;

procedure TFrmSession.actFontUnderlineExecute(Sender: TObject);
begin
  inherited;
  if actFontUnderline.Checked then
    redInput.Font.Style := redInput.Font.Style + [fsUnderline]
  else
    redInput.Font.Style := redInput.Font.Style - [fsUnderline];
end;

procedure TFrmSession.actFontStrikeoutExecute(Sender: TObject);
begin
  inherited;
  if actFontStrikeout.Checked then
    redInput.Font.Style := redInput.Font.Style + [fsStrikeout]
  else
    redInput.Font.Style := redInput.Font.Style - [fsStrikeout];
end;

procedure TFrmSession.ToolBarCustomDraw(Sender: TToolBar;
  const ARect: TRect; var DefaultDraw: Boolean);
begin
  inherited;
  pnlChat.DrawChildBackground(ToolBar, ToolBar.Canvas, ARect);
  DefaultDraw := True;
end;

procedure TFrmSession.tbTextColorMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  P: TPoint;
begin
  inherited;
  P := ToolBar.ClientToScreen(Point(TToolButton(Sender).Left,
                                    TToolButton(Sender).Top +
                                    TToolButton(Sender).Height));
  with TFrmColor.Create(Self) do
  begin
    if Sender = tbTextColor then
    begin
      Selected := redInput.Font.Color;
      OnSelect := TextColorSelect;
    end else
    if Sender = tbBgColor then
    begin
      Selected := redInput.Color;
      OnSelect := BgColorSelect;
    end;

    Left := P.X;
    Top := P.Y;
    MakeFullyVisible;
    Show;
  end;
end;

procedure TFrmSession.TextColorSelect(Sender: TObject; AColor: TColor);
begin
  redInput.Font.Color := AColor;
end;

procedure TFrmSession.BgColorSelect(Sender: TObject; AColor: TColor);
begin
  redInput.Color := AColor;
end;

procedure TFrmSession.redInputEnter(Sender: TObject);
begin
  inherited;
  btnSend.Default := True;
end;

procedure TFrmSession.redInputExit(Sender: TObject);
begin
  inherited;
  btnSend.Default := False;
end;

procedure TFrmSession.cmbFontNameChange(Sender: TObject);
begin
  inherited;
  if cmbFontName.ItemIndex > -1 then
    redInput.Font.Name := cmbFontName.Items[cmbFontName.ItemIndex];
end;

procedure TFrmSession.cmbFontSizeSelect(Sender: TObject);
var
  Value: Integer;
begin
  inherited;
  Value := StrToIntDef(cmbFontSize.Text, redInput.Font.Size);
  if Value < 1 then
    Value := 1
  else if Value > 99 then
    Value := 99;
  cmbFontSize.Text := IntToStr(Value);
  redInput.Font.Size := Value;
end;

procedure TFrmSession.cmbFontSizeKeyPress(Sender: TObject; var Key: Char);
begin
  inherited;
  if Key = Char(VK_RETURN) then
  begin
    cmbFontSizeSelect(cmbFontSize);
    if redInput.CanFocus then
      redInput.SetFocus;
    Key := #0;
  end;
end;

end.
