unit UFrmWebBrowser;
(* bO\ WebBrowser tH[̊NX *)

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, Menus, ExtCtrls, ActnList, ExPanel, ExSpeedButton,
  StdCtrls, SHDocVw_TLB, MSHTML_TLB, ActiveX, UNsmTypes, UNsmConsts, OleCtrls,
  UNsmUtils, USimpleUICore, USkinResource, StrUtils, UConfig, DateUtils,
  UFrmBaseClient, UWideUtils, UWideClasses, (*ExLabel,*) ResizeArea;

type
  TWBDocType = (dtText, dtUTF8Text, dtHtml);
  TFrmWebBrowser = class(TFrmBaseClient)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FPastMsgs: TWideStringList;
    FHtmlBasePath: String;
    FHeadTemplate: WideString;
    FMsgTemplate: WideString;
    FMsgHead: String;
    FReplaceTable: TWideStringDynArray;
    FWebBrowserParent: TWinControl;
    FBrowserInitialized: Boolean;

    procedure LoadTemplate;
    procedure LoadReplaceTable;
    function MakeHtmlHeader: WideString;
    procedure OutputHtmlHeader;
    procedure OutputPastMessages;
    function GetMsgCount: Integer;

    procedure WebBrowserBeforeNavigate2(Sender: TObject;
      const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
      Headers: OleVariant; var Cancel: WordBool);
    procedure WebBrowserDocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
  protected
    procedure UpdateSkinObjects; override;
    procedure ApplyBorderStyle; override;
    procedure CreateWnd; override;

    procedure CreateWebBrowser;
    procedure InitWebBrowser;
    procedure AdjustWebBrowserBounds;
    function PreProcessMsg(S: WideString): WideString;
    function MakeMsgHeader(Name, Account: WideString; DateTime: TDateTime): WideString;
    function MakeMsgBody(Msg: WideString; TextAttr: TTextAttributeInfo): WideString;
    function MakeMessage(Head, Body: WideString; BgColor: TColor; MsgNo: Integer = -1): WideString;
    procedure OutputMessage(Head, Body: WideString; BgColor: TColor; Scroll: Boolean = True);
    procedure ScrollToMsg(MsgNo: Integer);
    procedure WriteString(Str: WideString);
    function GetSelectedText: WideString;
  public
    WebBrowser: TWebBrowser;
    property MsgHead: String read FMsgHead write FMsgHead;
    property WebBrowserParent: TWinControl read FWebBrowserParent write FWebBrowserParent;
    property MsgCount: Integer read GetMsgCount;
    procedure ClearPastMsgs;
    procedure SaveToFile(const FileName: String; DocType: TWBDocType);
  end;

implementation

{$R *.dfm}

procedure TFrmWebBrowser.UpdateSkinObjects;
begin
  inherited;
  {
  LoadTemplate;
  LoadReplaceTable;
  InitWebBrowser;
  }
end;

procedure TFrmWebBrowser.ApplyBorderStyle;
begin
  // BorderStyle ύX WebBrowser ̋̂ŁA
  // 폜ĂĐĂ݂eXgB
  // Ƃ肠ɓ삵Ă݂...
  FreeAndNil(WebBrowser);
  inherited;
  CreateWebBrowser;
  InitWebBrowser;
end;

procedure TFrmWebBrowser.CreateWnd;
begin
//  FreeAndNil(WebBrowser);
  inherited;
//  CreateWebBrowser;
//  InitWebBrowser;
end;

// WebBrowser 쐬
procedure TFrmWebBrowser.CreateWebBrowser;
begin
  if not Assigned(WebBrowser) then
  begin
    WebBrowser := TWebBrowser.Create(Self);
    TOleControl(WebBrowser).Parent := FWebBrowserParent;
    AdjustWebBrowserBounds;
    WebBrowser.OnBeforeNavigate2 := WebBrowserBeforeNavigate2;
    WebBrowser.OnDocumentComplete := WebBrowserDocumentComplete;
    WebBrowser.TabStop := True;
    WebBrowser.Show;
  end;
end;

// TWebBrowser 
procedure TFrmWebBrowser.InitWebBrowser;
var
  URL, flag: OleVariant;
begin
  URL := 'about:blank';
  flag := $0E;
  FBrowserInitialized := False;
  WebBrowser.Navigate2(URL, flag);
  // ̂ WebBrowserDocumentComplete Ă΂ď
end;

procedure TFrmWebBrowser.AdjustWebBrowserBounds;
begin
  if Assigned(WebBrowser) and Assigned(FWebBrowserParent) then
    WebBrowser.SetBounds(-2, -2, FWebBrowserParent.ClientWidth + 4,
        FWebBrowserParent.ClientHeight + 4);
end;

// WebBrowser ɕo
procedure TFrmWebBrowser.WriteString(Str: WideString);
begin
  if FBrowserInitialized then
    OleVariant(WebBrowser.Document as IHTMLDocument2).Write(Str);
end;

// HTML ev[gǍ
procedure TFrmWebBrowser.LoadTemplate;
begin
  FHtmlBasePath := SkinResources.SkinFolder;
  // HTML wb_ev[gǍ
  FHeadTemplate := LoadStringFromFile(SkinResources.SkinFolder +
    SkinResources.ReadSkinString('HtmlTemplates', 'HeaderTemplate', 'Header.html'));
  if FHeadTemplate = '' then
    FHeadTemplate := '<HTML><HEAD>'#13#10 +
                     '<!--BASE-->'#13#10 +
                     '</HEAD><BODY>'#13#10 +
                     '<DL>'#13#10;
  // bZ[Wev[gǍ
  FMsgTemplate := LoadStringFromFile(SkinResources.SkinFolder +
    SkinResources.ReadSkinString('HtmlTemplates', 'MessageTemplate', 'Msg.html'));
  if FMsgTemplate = '' then
    FMsgTemplate := '<DT><B><!--MSGHEAD--></B></DT>'#13#10 +
                    '<DD><!--MSGBODY--></DD>'#13#10;
end;

// ue[uǍ
procedure TFrmWebBrowser.LoadReplaceTable;
var
  Source: WideString;
begin
  Source := LoadStringFromFile(SkinResources.SkinFolder +
    SkinResources.ReadSkinString('HtmlTemplates', 'ReplaceTable', ''));
  Source := WideReplaceStr(Source, WideCRLF, WideTab);
  WideSplit(Source, WideTab, FReplaceTable);
end;

// HTML wb_쐬
function TFrmWebBrowser.MakeHtmlHeader: WideString;
begin
  Result := WideReplaceStr(FHeadTemplate, '<!--BASE-->',
      '<BASE href="' + FHtmlBasePath + '">');
end;

// HTML wb_o
procedure TFrmWebBrowser.OutputHtmlHeader;
begin
  WriteString(MakeHtmlHeader);
end;

// bZ[W̏o͑O
function TFrmWebBrowser.PreProcessMsg(S: WideString): WideString;
  function GetUrlStr(Str: WideString; Idx: Integer): WideString;
  begin
    Result := '';
    while Idx <= Length(Str) do
    begin
      case Char(Str[Idx]) of
      #$21, #$23..#$3B, #$3D, #$3F..#$7E:
        Result := Result + Str[Idx];
      else
        Break;
      end;
      Inc(Idx);
    end;
  end;
var
  I: Integer;
  URL: WideString;
const
  ReplaceStrs: array[0..17] of WideString =
      ('&', '&amp;', '<', '&lt;', '>', '&gt;', ' ', '&nbsp;', WideCRLF, '<BR>',
      WideCR, '<BR>', WideLF, '<BR>', WideChar($0B), '<BR>', WideLS, '<BR>');
begin
  I := 1;
  // HTML ^O𖳌
  S := WideReplaceStrEx(S, ReplaceStrs);
  S := WideReplaceTextEx(S, FReplaceTable);
  // URLN
  while I <= Length(S) do
  begin
    if WideCopy(S, I, 7) = 'http://' then
    begin
      URL := GetUrlStr(S, I);
      Delete(S, I, Length(URL));
      URL := '<A HREF="' + URL + '">' + URL + '</A>';
      Insert(URL, S, I);
      Inc(I, Length(URL) - 1);
    end;
    Inc(I);
  end;
  Result := S;
end;

// bZ[W̃wb_쐬
function TFrmWebBrowser.MakeMsgHeader(Name, Account: WideString; DateTime: TDateTime): WideString;
begin
  Name := PreProcessMsg(Name);
  Account := PreProcessMsg(Account);
  Result := WideReplaceStrEx(FMsgHead, [
    '<!--NAME-->',    Name,
    '<!--ACCOUNT-->', Account,
    '<!--NOW-->',     DateTimeToStr(DateTime),
    '<!--DATE-->',    DateToStr(DateTime),
    '<!--TIME-->',    TimeToStr(DateTime),
    '<!--HOUR-->',    IntToStr(HourOf(DateTime)),
    '<!--MINUTE-->',  IntToStr(MinuteOf(DateTime)),
    '<!--SECOND-->',  IntToStr(SecondOf(DateTime)),
    '<!--YEAR-->',    IntToStr(YearOf(DateTime)),
    '<!--MONTH-->',   IntToStr(MonthOf(DateTime)),
    '<!--DAY-->',     IntToStr(DayOf(DateTime))
  ]);
end;

// bZ[W{쐬
function TFrmWebBrowser.MakeMsgBody(Msg: WideString;
  TextAttr: TTextAttributeInfo): WideString;
var
  Style: WideString;
begin
  Style := '';
  if TextAttr.lpFontName <> '' then
    Style := Style + WideFormat('font-family:%s;', [WideString(TextAttr.lpFontName)]);
  if TextAttr.nFontSize > -1 then
    Style := Style + WideFormat('font-size:%dpt;', [TextAttr.nFontSize]);
  if TextAttr.nFontColor > -1 then
    Style := Style + WideFormat('color:#%s;', [IntToHex(RGBSwap(TextAttr.nFontColor), 6)]);
  if (TextAttr.nStyles and NMFS_BOLD) <> 0 then
    Style := Style + 'font-weight:bold;';
  if (TextAttr.nStyles and NMFS_ITALIC) <> 0 then
    Style := Style + 'font-style:italic;';
  if (TextAttr.nStyles and NMFS_UNDERLINE) <> 0 then
    Style := Style + 'text-decoration:underline;';
  if (TextAttr.nStyles and NMFS_STRIKEOUT) <> 0 then
    Style := Style + 'text-decoration:line-through;';

  Result := '<SPAN STYLE="' + Style + '">' + PreProcessMsg(Msg) + '</SPAN>';
end;

function TFrmWebBrowser.MakeMessage(Head, Body: WideString;
  BgColor: TColor; MsgNo: Integer = -1): WideString;
var
  MsgStyle: String;
begin
  if MsgNo = -1 then
    MsgNo := GetMsgCount;
  if BgColor <> clNone then
    MsgStyle := WideFormat('background-color:#%s;', [IntToHex(RGBSwap(BgColor), 6)]);

  Result := WideReplaceStr(FMsgTemplate, '<!--MSGHEAD-->', Head);
  Result := WideReplaceStr(Result, '<!--MSGBODY-->', Body);
  Result := WideFormat('<A NAME="%d">', [MsgNo]) + Result;
  Result := '<DIV STYLE="' + MsgStyle + '">' + Result + '</DIV>'#13#10;
end;

// bZ[Wo
procedure TFrmWebBrowser.OutputMessage(Head, Body: WideString; BgColor: TColor;
  Scroll: Boolean = True);
var
  Msg: WideString;
begin
  Msg := MakeMessage(Head, Body, BgColor);
  FPastMsgs.Add(Msg);

  WriteString(Msg);
  if Scroll then
    ScrollToMsg(GetMsgCount - 1);
end;

// ߋOo
procedure TFrmWebBrowser.OutputPastMessages;
var
  I, MsgCnt: Integer;
begin
  MsgCnt := GetMsgCount;
  for I := 0 to MsgCnt - 1 do
    WriteString(FPastMsgs[I]);
  ScrollToMsg(MsgCnt - 1);
end;

// ߋOobt@S
procedure TFrmWebBrowser.ClearPastMsgs;
begin
  FPastMsgs.Clear;
  InitWebBrowser;
end;

// w肳ꂽbZ[WԍɃXN[
procedure TFrmWebBrowser.ScrollToMsg(MsgNo: Integer);
var
  Doc: OleVariant;
begin
  if (MsgNo >= 0) and (MsgNo < GetMsgCount) and   FBrowserInitialized then
  begin
    Doc := OleVariant(WebBrowser.Document as IHTMLDocument2);
	  Doc.body.scrollTop := Doc.anchors.item(IntToStr(MsgNo)).offsetTop;
  end;
end;

// bZ[Wt@Cɕۑ
procedure TFrmWebBrowser.SaveToFile(const FileName: String; DocType: TWBDocType);
var
  I, MsgCnt: Integer;
  Doc: WideString;
begin
  Doc := MakeHtmlHeader;
  MsgCnt := GetMsgCount;
  for I := 0 to MsgCnt - 1 do
    Doc := Doc + MakeMessage(FPastMsgs[I * 2], FPastMsgs[I * 2 + 1], I);

  case DocType of
  dtText:     SaveStringToFile(FileName, HtmlToText(Doc));
  dtUTF8Text: SaveStringToFile(FileName, UTF8Encode(HtmlToText(Doc)));
  dtHtml:     SaveStringToFile(FileName, UTF8Encode(Doc));
  end;
end;

function TFrmWebBrowser.GetMsgCount: Integer;
begin
  Result := FPastMsgs.Count;
end;

function TFrmWebBrowser.GetSelectedText: WideString;
var
  TextRange: OleVariant;
begin
  TextRange := OleVariant(WebBrowser.Document as IHTMLDocument2).selection;
  TextRange := TextRange.createRange();
  Result := TextRange.text;
end;

procedure TFrmWebBrowser.WebBrowserBeforeNavigate2(Sender: TObject;
  const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
  Headers: OleVariant; var Cancel: WordBool);
begin
  inherited;
  if URL = 'about:blank' then
    exit;
  if AnsiStartsStr('menu:', URL) then
  begin

  end
  else
  begin
    Cancel := True;
    SimpleUICore.OpenURL(URL);
  end;
end;

procedure TFrmWebBrowser.WebBrowserDocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  inherited;
  if URL = 'about:blank' then
  begin
    FBrowserInitialized := True;
    OutputHtmlHeader;
    OutputPastMessages;
  end;
end;
procedure TFrmWebBrowser.FormCreate(Sender: TObject);
begin
  if not Assigned(FWebBrowserParent) then
    FWebBrowserParent := pnlBack;
  FPastMsgs := TWideStringList.Create;
  inherited;
  LoadTemplate;
  LoadReplaceTable;
//  InitWebBrowser;
end;

procedure TFrmWebBrowser.FormDestroy(Sender: TObject);
begin
  inherited;
  FPastMsgs.Free;
end;

end.
