unit UConfig;

interface

uses
  IniFiles, SysUtils;

type
  TMsnConfig = class(TObject)
  public
    MsnHost: String;
    MsnPort: Integer;
    SendPing: Boolean;
    PingInterval: Integer;

    procedure Initialize;
    procedure LoadFromFile(const FileName: String);
    procedure SaveToFile(const FileName: String);
  end;

var
  Config: TMsnConfig;

implementation

procedure TMsnConfig.Initialize;
begin
  MsnHost         := 'messenger.hotmail.com';
  MsnPort         := 1863;
  SendPing        := True;
  PingInterval    := 1;
end;

procedure TMsnConfig.LoadFromFile(const FileName: String);
var
  Ini: TIniFile;
begin
  if not FileExists(FileName) then Exit;
  Ini := TIniFile.Create(FileName);
  try
    MsnHost         := Ini.ReadString('Connection', 'MsnHost', MsnHost);
    MsnPort         := Ini.ReadInteger('Connection', 'MsnPort', MsnPort);
    SendPing        := Ini.ReadBool('Connection', 'SendPing', SendPing);
    PingInterval    := Ini.ReadInteger('Connection', 'PingInterval', PingInterval);
  finally
    Ini.Free;
  end;
end;

procedure TMsnConfig.SaveToFile(const FileName: String);
var
  Ini: TIniFile;
begin
  if not DirectoryExists(ExtractFileDir(FileName)) then
    ForceDirectories(ExtractFileDir(FileName));
  Ini := TIniFile.Create(FileName);
  try
    Ini.WriteString('Connection', 'MsnHost', MsnHost);
    Ini.WriteInteger('Connection', 'MsnPort', MsnPort);
    Ini.WriteBool('Connection', 'SendPing', SendPing);
    Ini.WriteInteger('Connection', 'PingInterval', PingInterval);
  finally
    Ini.Free;
  end;
end;

initialization
  Config := TMsnConfig.Create;
  Config.Initialize;

finalization
  Config.Free;
end.
