unit UDlgOption;
(* Copyright (C) 2001-2002 Yamaneko <ymnk160@hotmail.com> *)

interface

uses
  Windows, Messages, SysUtils, UConfig;

function ShowOptionDialog(Parent: HWND): Integer;

implementation

{$I Dialog.inc}

const
  UDM_SETRANGE            = WM_USER+101; // ŏlƍől̐ݒ
  UDM_GETRANGE            = WM_USER+102; // ŏlƍől̎擾
  UDM_SETPOS              = WM_USER+103; // ݈ʒu̐ݒ
  UDM_GETPOS              = WM_USER+104; // ݈ʒu̎擾

procedure OnInitDialog(hDialog: HWnd);
  procedure SetEditStr(Item: Integer; Text: String);
  begin
    SendDlgItemMessage(hDialog, Item, WM_SETTEXT, 0, Integer(PChar(Text)));
  end;
begin
  SetEditStr(IDC_EDTHOST, Config.MsnHost);
  SetEditStr(IDC_EDTPORT, IntToStr(Config.MsnPort));
  SendDlgItemMessage(hDialog, IDC_UDCPINGINTERVAL, UDM_SETRANGE, 0, MAKELONG(99, 1));
  SendDlgItemMessage(hDialog, IDC_UDCPINGINTERVAL, UDM_SETPOS, 0, MAKELONG(Config.PingInterval, 0));
  if Config.SendPing then
    SendDlgItemMessage(hDialog, IDC_CHKSENDPING, BM_SETCHECK, BST_CHECKED, 0)
end;

procedure OnEndDialog(hDialog: HWnd; ModalResult: Integer);
  function GetEditStr(Item: Integer): String;
  var
    Len: Integer;
  begin
    SetLength(Result, 256);
    Len := SendDlgItemMessage(hDialog, Item, WM_GETTEXT, 256, Integer(PChar(Result)));
    SetLength(Result, Len);
  end;
begin
  if ModalResult = ID_OK then
  begin
    Config.MsnHost := GetEditStr(IDC_EDTHOST);
    Config.MsnPort := StrToIntDef(GetEditStr(IDC_EDTPORT), Config.MsnPort);
    Config.SendPing := Boolean(SendDlgItemMessage(hDialog, IDC_CHKSENDPING, BM_GETCHECK, 0, 0));
    Config.PingInterval := SendDlgItemMessage(hDialog, IDC_UDCPINGINTERVAL, UDM_GETPOS, 0,0);
  end;
end;

function DialogFunc(hDialog: HWnd; AMessage, WParam: UINT;
    LParam: LPARAM): Bool; stdcall;
var
  ModalResult: Integer;
begin
  Result := True;
  case AMessage of
    WM_INITDIALOG:
    begin
      OnInitDialog(hDialog);
      Exit;
    end;
    WM_COMMAND:
    begin
      ModalResult := 0;
      case LOWORD(WParam) of
        IDCANCEL, IDC_BTNCANCEL:
                    ModalResult := ID_CANCEL;
        IDC_BTNOK:  ModalResult := ID_OK;
      end;
      if ModalResult <> 0 then
      begin
        OnEndDialog(hDialog, ModalResult);
        EndDialog(hDialog, ModalResult);
        Exit;
      end;
    end;
  end;
  Result := False;
end;

function ShowOptionDialog(Parent: HWND): Integer;
begin
  Result := DialogBox(hInstance, 'IDD_OPTION', Parent, @DialogFunc);
end;

end.
