unit UNsmConnection;
(* NSM RlNV֘Ajbg *)

interface

uses
  Classes, SyncObjs, UNsmMemberList;

type
  TNsmConnectionList = class;
  // RlNVNX
  TNsmConnection = class(TObject)
  private
    FOwner: TNsmConnectionList;
    FProtocol: String;
    FCaption: WideString;
    FUser: TNsmUser;
    FStatus: Integer;
    FMembers: TNsmMemberList;
    FAllowMembers: TNsmMemberList;
    FBlockMembers: TNsmMemberList;
    FReverseMembers: TNsmMemberList;
    FGroups: TNsmGroupList;
  public
    constructor Create(AOwner: TNsmConnectionList);
    destructor Destroy; override;
    property Protocol: String read FProtocol write FProtocol;
    property Caption: WideString read FCaption write FCaption;
    property User: TNsmUser read FUser;
    property Status: Integer read FStatus write FStatus;
    property Members: TNsmMemberList read FMembers;
    property AllowMembers: TNsmMemberList read FAllowMembers;
    property BlockMembers: TNsmMemberList read FBlockMembers;
    property ReverseMembers: TNsmMemberList read FReverseMembers;
    property Groups: TNsmGroupList read FGroups;
  end;

  // RlNVXg
  TNsmConnectionList = class(TObject)
  private
    FConnections: TList;
    function GetCount: Integer;
    function GetConnection(Index: Integer): TNsmConnection;
  public
    constructor Create;
    destructor Destroy; override;
    property Count: Integer read GetCount;
    property Connection[Index: Integer]: TNsmConnection read GetConnection; default;
    function Add(AProtocol, ACaption: String): TNsmConnection;
    procedure Delete(Index: Integer);
    procedure Remove(Item: TNsmConnection);
    procedure Clear;
    function IndexOf(AConnection: TNsmConnection): Integer;
  end;

  // XbhZ[tȃRlNVXg
  TNsmThreadConnectionList = class(TObject)
  private
    FConnections: TNsmConnectionList;
  public
    constructor Create;
    destructor Destroy; override;
    function LockList: TNsmConnectionList;
    procedure UnlockList;
  end;

implementation

var
  FCriticalSection: TCriticalSection;

// TNsmConnection --------------------------------------------------------------
constructor TNsmConnection.Create(AOwner: TNsmConnectionList);
begin
  FOwner := AOwner;
  FUser := TNsmUser.Create;
  FMembers := TNsmMemberList.Create;
  FAllowMembers := TNsmMemberList.Create;
  FBlockMembers := TNsmMemberList.Create;
  FReverseMembers := TNsmMemberList.Create;
  FGroups := TNsmGroupList.Create;
end;

destructor TNsmConnection.Destroy;
begin
  FUser.Free;
  FMembers.Free;
  FAllowMembers.Free;
  FBlockMembers.Free;
  FReverseMembers.Free;
  FGroups.Free;
  inherited;
end;

// TNsmConnectionList ----------------------------------------------------------
constructor TNsmConnectionList.Create;
begin
  FConnections := TList.Create;
end;

destructor TNsmConnectionList.Destroy;
begin
  Clear;
  FConnections.Free;
  inherited;
end;

function TNsmConnectionList.GetCount: Integer;
begin
  Result := FConnections.Count;
end;

function TNsmConnectionList.GetConnection(Index: Integer): TNsmConnection;
begin
  Result := TNsmConnection(FConnections[Index]);
end;

function TNsmConnectionList.Add(AProtocol, ACaption: String): TNsmConnection;
begin
  Result := TNsmConnection.Create(Self);
  Result.Protocol := AProtocol;
  Result.Caption := ACaption;
  FConnections.Add(Result);
end;

procedure TNsmConnectionList.Delete(Index: Integer);
begin
  TNsmConnection(FConnections[Index]).Free;
  FConnections.Delete(Index);
end;

procedure TNsmConnectionList.Remove(Item: TNsmConnection);
begin
  FConnections.Remove(Item);
  Item.Free;
end;

procedure TNsmConnectionList.Clear;
begin
  while FConnections.Count > 0 do
    Delete(0);
end;

function TNsmConnectionList.IndexOf(AConnection: TNsmConnection): Integer;
var
  I: Integer;
begin
  Result := -1;
  for I := 0 to FConnections.Count - 1 do
    if FConnections[I] = AConnection then
    begin
      Result := I;
      Break;
    end;
end;

// TNsmThreadConnectionList ----------------------------------------------------

constructor TNsmThreadConnectionList.Create;
begin
  FConnections := TNsmConnectionList.Create;
end;

destructor TNsmThreadConnectionList.Destroy;
begin
  FConnections.Free;
  inherited;
end;

function TNsmThreadConnectionList.LockList: TNsmConnectionList;
begin
  FCriticalSection.Enter;
  Result := FConnections;
end;

procedure TNsmThreadConnectionList.UnlockList;
begin
  FCriticalSection.Leave;
end;

// -----------------------------------------------------------------------------

initialization
  FCriticalSection := TCriticalSection.Create;

finalization
  FCriticalSection.Free;

end.
