unit UNsmEvent;
(* NSM Cxg֘Ajbg *)

interface

uses
  Windows, Classes, SyncObjs, IniFiles;

type
  TNsmEventProc = function(wParam, lParam: Cardinal): Integer; StdCall;

  TNsmEventList = class;
  // CxgNX
  TNsmEvent = class(TObject)
  private
    FOwner: TNsmEventList;
    FHookProcs: TList;
    function GetEventName: String;
  public
    constructor Create(AOwner: TNsmEventList);
    destructor Destroy; override;
    property Name: String read GetEventName;
    property HookProcs: TList read FHookProcs;
  end;

  // CxgXg
  TNsmEventList = class(TObject)
  private
    FEvents: THashedStringList;
    function GetCount: Integer;
    function GetEvent(Index: Integer): TNsmEvent;
  public
    constructor Create;
    destructor Destroy; override;
    property Count: Integer read GetCount;
    property Event[Index: Integer]: TNsmEvent read GetEvent; default;
    function Add(EventName: String): TNsmEvent;
    procedure Delete(Index: Integer);
    procedure Remove(Item: TNsmEvent);
    procedure Clear;
    function IndexOf(EventName: String): Integer;
    function Find(EventName: String): TNsmEvent;
  end;

  // XbhZ[tȃCxgXg
  TNsmThreadEventList = class(TObject)
  private
    FEvents: TNsmEventList;
  public
    constructor Create;
    destructor Destroy; override;
    function LockList: TNsmEventList;
    procedure UnlockList;
  end;

implementation

var
  FCriticalSection: TCriticalSection;

// TNsmEvent --------------------------------------------------------------------
constructor TNsmEvent.Create(AOwner: TNsmEventList);
begin
  FOwner := AOwner;
  FHookProcs := TList.Create;
end;

destructor TNsmEvent.Destroy;
begin
  FHookProcs.Free;
  inherited;
end;

function TNsmEvent.GetEventName: String;
var
  Idx: Integer;
begin
  Idx := FOwner.FEvents.IndexOfObject(Self);
  if Idx > -1 then
    Result := FOwner.FEvents[Idx];
end;

// TNsmEventList ---------------------------------------------------------------
constructor TNsmEventList.Create;
begin
  inherited;
  FEvents := THashedStringList.Create;
  FEvents.Sorted := True;
end;

destructor TNsmEventList.Destroy;
begin
  Clear;
  FEvents.Free;
  inherited;
end;

function TNsmEventList.GetCount: Integer;
begin
  Result := FEvents.Count;
end;

function TNsmEventList.GetEvent(Index: Integer): TNsmEvent;
begin
  Result := TNsmEvent(FEvents.Objects[Index]);
end;

function TNsmEventList.Add(EventName: String): TNsmEvent;
begin
  if IndexOf(EventName) = -1 then
  begin
    Result := TNsmEvent.Create(Self);
    FEvents.AddObject(EventName, Result);
  end else
    Result := nil;
end;

procedure TNsmEventList.Delete(Index: Integer);
begin
  TNsmEventList(FEvents.Objects[Index]).Free;
  FEvents.Delete(Index);
end;

procedure TNsmEventList.Remove(Item: TNsmEvent);
var
  Idx: Integer;
begin
  Idx := FEvents.IndexOfObject(Item);
  if Idx > -1 then
    Delete(Idx);
end;

procedure TNsmEventList.Clear;
begin
  while FEvents.Count > 0 do
    Delete(0);
end;

function TNsmEventList.IndexOf(EventName: String): Integer;
begin
  Result := FEvents.IndexOf(EventName);
end;

function TNsmEventList.Find(EventName: String): TNsmEvent;
var
  Idx: Integer;
begin
  Idx := IndexOf(EventName);
  if idx > -1 then
    Result := TNsmEvent(FEvents.Objects[Idx])
  else
    Result := nil;
end;

// TNsmThreadServiceList -------------------------------------------------------

constructor TNsmThreadEventList.Create;
begin
  inherited;
  FEvents := TNsmEventList.Create;
end;

destructor TNsmThreadEventList.Destroy;
begin
  FEvents.Free;
  inherited;
end;

function TNsmThreadEventList.LockList: TNsmEventList;
begin
  FCriticalSection.Enter;
  Result := FEvents;
end;

procedure TNsmThreadEventList.UnlockList;
begin
  FCriticalSection.Leave;
end;

// -----------------------------------------------------------------------------

initialization
  FCriticalSection := TCriticalSection.Create;

finalization
  FCriticalSection.Free;

end.
