unit UNsmPlugin;
(* NSM vOC֘Ajbg *)

interface

uses
  Windows, SysUtils, Classes, UNsmTypes, UNsmConsts;

const
  NMP_NOTIMPLEMENT_ERROR = -1;    // ĂȂ
  NMP_ALLRIGHT = 0;               // I
  NMP_INTERNAL_ERROR = 100;       // G[
  NMP_UNINITIALIZED_ERROR = 101;  // vOCĂȂ

type
  TNsmPluginInfo = record
    ApiVersion: String;
    ModuleName: String;
    DisplayName: String;
    Description: String;
    Author: String;
    Copyright: String;
    PluginVersion: String;
  end;

  // vOC𓾂
  TGetPluginInfo = function(nInfoNo: Integer; lpBuffer: LPTSTR; nSize: Integer): Integer; stdcall;
  // vOC
  TInitialize = function(lpPluginInitInfo: PNsmPluginInitInfo): Integer; stdcall;
  // vOCI
  TTerminate = function: Integer; stdcall;
  
  // vOC̃bp[
  TNsmPlugin = class(TObject)
  private
    FDllHandle: THandle;
    FFileName:  TFileName;
    FPluginInfo: TNsmPluginInfo;
    FGetPluginInfo: TGetPluginInfo;
    FInitialize: TInitialize;
    FTerminate: TTerminate;

    procedure AssignAPIAddress(var P; AAPIName: String);
    function  ProcAddress(AProcName: String): Pointer;
  public
    constructor Create(AFileName: TFileName); virtual;
    destructor Destroy; override;
    function GetPluginInfo(InfoNo: Integer; lpBuffer: LPTSTR; nSize: Integer): Integer;
    function GetPluginInfoEx(InfoNo: Integer): String;
    function Initialize(lpPluginInitInfo: PNsmPluginInitInfo): Integer;
    function Terminate: Integer;

    property DllHandle: THandle read FDllHandle;
    property FileName: TFileName read FFileName;
    property PluginInfo: TNsmPluginInfo read FPluginInfo;
  end;

  TNsmPluginList = class(TObject)
  private
    FPlugins: TList;
    function GetPlugin(Idx: Integer): TNsmPlugin;
    function GetCount: Integer;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear;
    function Add(FileName: String): Boolean;
    procedure Delete(Idx: Integer);
    function IndexOf(FileName: String): Integer;
    function IndexOfModuleName(ModuleName: String): Integer;
    procedure Move(CurIndex, NewIndex: Integer);
    procedure Search(Path: AnsiString);

    property Plugins[Idx: Integer]: TNsmPlugin read GetPlugin; default;
    property Count: Integer read GetCount;
  end;

implementation

// TNsmPlugin ------------------------------------------------------------------
constructor TNsmPlugin.Create(AFileName: TFileName);
var
  buf: array[0..255] of Char;
begin
  inherited Create;

  FDllHandle := LoadLibrary(PChar(AFileName));
  if FDllHandle <> 0 then
  begin
    if GetModuleFileName(FDllHandle, buf, SizeOf(buf)-1) > 0 then
      FFileName := buf
    else
      FFileName := AFileName;

    AssignAPIAddress(FGetPluginInfo, 'GetPluginInfo');
    AssignAPIAddress(FInitialize, 'Initialize');
    AssignAPIAddress(FTerminate, 'Terminate');
  end;

  with FPluginInfo do
  begin
    ApiVersion    := GetPluginInfoEx(NMPI_APIVER);
    ModuleName    := GetPluginInfoEx(NMPI_MODULENAME);
    DisplayName   := GetPluginInfoEx(NMPI_TITLE);
    Description   := GetPluginInfoEx(NMPI_DESCRIPTION);
    Author        := GetPluginInfoEx(NMPI_AUTHOR);
    Copyright     := GetPluginInfoEx(NMPI_COPYRIGHT);
    PluginVersion := GetPluginInfoEx(NMPI_PLUGINVER);
  end;
end;


destructor TNsmPlugin.Destroy;
begin
  if FDLLHandle <> 0 then
    FreeLibrary(FDllHandle);

  inherited Destroy;
end;

function  TNsmPlugin.ProcAddress(AProcName: String): Pointer;
begin
  Result := GetProcAddress(FDllHandle, PChar(AProcName));
end;

procedure TNsmPlugin.AssignAPIAddress(var P; AAPIName: String);
begin
  Pointer(P) := ProcAddress(AAPIName);
end;

function TNsmPlugin.GetPluginInfo(InfoNo: Integer; lpBuffer: LPTSTR; nSize: Integer): Integer;
begin
  if @FGetPluginInfo <> nil then
    Result := FGetPluginInfo(InfoNo, lpBuffer, nSize)
  else
    Result := 0;
end;

function TNsmPlugin.GetPluginInfoEx(InfoNo: Integer): String;
var
  buf: array[0..255] of Char;
begin
  if GetPluginInfo(InfoNo, buf, SizeOf(buf)) > 0 then
    Result := buf
  else
    Result := '';
end;

function TNsmPlugin.Initialize(lpPluginInitInfo: PNsmPluginInitInfo): Integer;
begin
  if @FInitialize <> nil then
    Result := FInitialize(lpPluginInitInfo)
  else
    Result := NMP_NOTIMPLEMENT_ERROR;
end;

function TNsmPlugin.Terminate: Integer;
begin
  if @FTerminate <> nil then
    Result := FTerminate
  else
    Result := NMP_NOTIMPLEMENT_ERROR;
end;

// TNsmPluginList --------------------------------------------------------------
constructor TNsmPluginList.Create;
begin
  inherited;
  FPlugins := TList.Create;
end;

destructor TNsmPluginList.Destroy;
begin
  Clear;
  FPlugins.Free;
  inherited;
end;

procedure TNsmPluginList.Clear;
begin
  while FPlugins.Count > 0 do
    Delete(0);
end;

function TNsmPluginList.Add(FileName: String): Boolean;
var
  NewPlugin: TNsmPlugin;
begin
  NewPlugin := TNsmPlugin.Create(FileName);
  if (NewPlugin.DllHandle <> 0) and
     (NewPlugin.PluginInfo.ApiVersion = NSM_API_VERSION) and
     (NewPlugin.PluginInfo.ModuleName <> NMM_SYSTEM) and 
     (IndexOfModuleName(NewPlugin.PluginInfo.ModuleName) = -1) then
  begin
    FPlugins.Add(NewPlugin);
    Result := True;
  end else
  begin
    NewPlugin.Free;
    Result := False;
  end;
end;

procedure TNsmPluginList.Delete(Idx: Integer);
begin
  TNsmPlugin(FPlugins.Items[Idx]).Free;
  FPlugins.Delete(Idx);
end;

function TNsmPluginList.GetPlugin(Idx: Integer): TNsmPlugin;
begin
  Result := TNsmPlugin(FPlugins.Items[Idx]);
end;

function TNsmPluginList.GetCount: Integer;
begin
  Result := FPlugins.Count;
end;

procedure TNsmPluginList.Search(Path: String);
var
  sr: TSearchRec;
begin
  if FindFirst(Path, faAnyFile, sr) = 0 then begin
    repeat
    begin
      Add(ExtractFilePath(Path) + sr.Name);
    end until FindNext(sr) <> 0;
    FindClose(sr);
  end;
end;

function TNsmPluginList.IndexOf(FileName: String): Integer;
var
  I: Integer;
begin
  Result := -1;
  for I := 0 to FPlugins.Count - 1 do
    if AnsiSameText(ExtractFileName(TNsmPlugin(FPlugins[I]).FileName), FileName) then
    begin
      Result := I;
      Break;
    end;
end;

function TNsmPluginList.IndexOfModuleName(ModuleName: String): Integer;
var
  I: Integer;
begin
  Result := -1;
  for I := 0 to FPlugins.Count - 1 do
    if AnsiSameStr(TNsmPlugin(FPlugins[I]).PluginInfo.ModuleName, ModuleName) then
    begin
      Result := I;
      Break;
    end;
end;

procedure TNsmPluginList.Move(CurIndex, NewIndex: Integer);
begin
  FPlugins.Move(CurIndex, NewIndex);
end;

end.
