/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.map;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Collection;

import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public interface SqlDataMapper {

	/**
	 * 
	 * @param name
	 * @param as
	 * @param t
	 * @param rd
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	public SingleTableRelation read(String name, String as,
			SqlCreateTable t,
			Reader rd) throws IOException, SQLException;

	/**
	 * 
	 * @param name
	 * @param t
	 * @param wr
	 * @param l
	 * @throws IOException
	 * @throws SQLException
	 */
	public void write(String name, SqlCreateTable t, PrintWriter wr,
			Collection<RelationTuple> l) throws IOException, SQLException;

}
