/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.engine;

import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.SqlResponse;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.Relations;
import net.morilib.db.relations.TableRelation;
import net.morilib.db.relations.TableRenameRelation;
import net.morilib.db.relations.UnionAllRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sql.DbSqlLexer;
import net.morilib.db.sql.DbSqlParser;
import net.morilib.db.sqlcs.ddl.SqlAlterTableAdd;
import net.morilib.db.sqlcs.ddl.SqlAlterTableDrop;
import net.morilib.db.sqlcs.ddl.SqlAlterTableModify;
import net.morilib.db.sqlcs.ddl.SqlAlterTableRenameColumn;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.sqlcs.ddl.SqlDropTable;
import net.morilib.db.sqlcs.ddl.SqlTruncateTable;
import net.morilib.db.sqlcs.dml.SqlDelete;
import net.morilib.db.sqlcs.dml.SqlExpression;
import net.morilib.db.sqlcs.dml.SqlInsertSelect;
import net.morilib.db.sqlcs.dml.SqlInsertValues;
import net.morilib.db.sqlcs.dml.SqlJoin;
import net.morilib.db.sqlcs.dml.SqlRelation;
import net.morilib.db.sqlcs.dml.SqlSelect;
import net.morilib.db.sqlcs.dml.SqlSetBinaryOperation;
import net.morilib.db.sqlcs.dml.SqlSetExpression;
import net.morilib.db.sqlcs.dml.SqlSubqueryRelation;
import net.morilib.db.sqlcs.dml.SqlTable;
import net.morilib.db.sqlcs.dml.SqlUpdate;
import net.morilib.db.sqlcs.dml.SqlWith;

public abstract class SqlEngine {
    protected SqlSchema schema;

    public SqlEngine(SqlSchema schema) {
        this.schema = schema;
    }

    public SqlSchema getSchema() {
        return this.schema;
    }

    public abstract Relation visit(SqlSelect var1, RelationTuple var2, List<Object> var3) throws IOException, SQLException;

    public abstract RelationExpression visit(SqlExpression var1, List<Object> var2) throws SQLException;

    public abstract int visit(SqlInsertValues var1, List<Object> var2) throws IOException, SQLException;

    public abstract int visit(SqlInsertSelect var1, List<Object> var2) throws IOException, SQLException;

    public abstract int visit(SqlUpdate var1, List<Object> var2) throws IOException, SQLException;

    public abstract int visit(SqlDelete var1, List<Object> var2) throws IOException, SQLException;

    public abstract Object visit(SqlCreateTable var1) throws IOException, SQLException;

    public abstract Object visit(SqlDropTable var1) throws IOException, SQLException;

    public abstract Object visit(SqlTruncateTable var1) throws IOException, SQLException;

    public abstract Object visit(SqlAlterTableAdd var1) throws IOException, SQLException;

    public abstract Object visit(SqlAlterTableModify var1) throws IOException, SQLException;

    public abstract Object visit(SqlAlterTableDrop var1) throws IOException, SQLException;

    public abstract Object visit(SqlAlterTableRenameColumn var1) throws IOException, SQLException;

    public abstract void commit() throws IOException, SQLException;

    public abstract void rollback() throws IOException, SQLException;

    public Relation visit(SqlRelation t, List<Object> h) throws IOException, SQLException {
        if (t instanceof SqlTable) {
            SqlTable tt = (SqlTable)t;
            return this.schema.readRelation(tt.getName(), tt.getAs());
        }
        if (t instanceof SqlJoin) {
            SqlJoin tj = (SqlJoin)t;
            Relation a = this.visit(tj.getJoinee(), h);
            Relation b = this.visit(tj.getJoiner(), h);
            return Relations.join(this, this.schema, this.visit(tj.getOn(), h), a, b, null, null, tj.getType(), h);
        }
        if (t instanceof SqlSubqueryRelation) {
            SqlSubqueryRelation ts = (SqlSubqueryRelation)t;
            return new TableRenameRelation(this.visit(ts.getSubquery(), Relations.NULLTUPLE, h), ts.getAs());
        }
        throw new RuntimeException();
    }

    Relation _union(Relation a, Relation b) throws IOException, SQLException {
        List<SqlColumnDefinition> p = a.getColumnNames();
        if (p.size() != b.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10002, new Object[0]);
        }
        LinkedHashSet<RelationTuple> l = new LinkedHashSet<RelationTuple>();
        RelationCursor c = a.iterator();
        while (c.hasNext()) {
            l.add(new DefaultRelationTuple(c.next().toMap()));
        }
        c = b.iterator();
        LinkedHashMap<String, Object> n = new LinkedHashMap<String, Object>();
        while (c.hasNext()) {
            int i = 0;
            Map<String, Object> m = c.next().toMap();
            for (String s : m.keySet()) {
                n.put(p.get(i++).getName(), m.get(s));
            }
            l.add(new DefaultRelationTuple(n));
        }
        return new TableRelation(p, l);
    }

    Relation _intersect(Relation a, Relation b) throws IOException, SQLException {
        List<SqlColumnDefinition> p = a.getColumnNames();
        if (p.size() != b.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10002, new Object[0]);
        }
        LinkedHashSet<RelationTuple> l = new LinkedHashSet<RelationTuple>();
        RelationCursor c = a.iterator();
        while (c.hasNext()) {
            l.add(new DefaultRelationTuple(c.next().toMap()));
        }
        LinkedHashSet<DefaultRelationTuple> q = new LinkedHashSet<DefaultRelationTuple>();
        c = b.iterator();
        LinkedHashMap<String, Object> n = new LinkedHashMap<String, Object>();
        while (c.hasNext()) {
            int i = 0;
            Map<String, Object> m = c.next().toMap();
            for (String s : m.keySet()) {
                n.put(p.get(i++).getName(), m.get(s));
            }
            q.add(new DefaultRelationTuple(n));
        }
        l.retainAll(q);
        return new TableRelation(p, l);
    }

    Relation _except(Relation a, Relation b) throws IOException, SQLException {
        List<SqlColumnDefinition> p = a.getColumnNames();
        if (p.size() != b.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10002, new Object[0]);
        }
        LinkedHashSet<RelationTuple> l = new LinkedHashSet<RelationTuple>();
        RelationCursor c = a.iterator();
        while (c.hasNext()) {
            l.add(new DefaultRelationTuple(c.next().toMap()));
        }
        c = b.iterator();
        LinkedHashMap<String, Object> n = new LinkedHashMap<String, Object>();
        while (c.hasNext()) {
            int i = 0;
            Map<String, Object> m = c.next().toMap();
            for (String s : m.keySet()) {
                n.put(p.get(i++).getName(), m.get(s));
            }
            DefaultRelationTuple t = new DefaultRelationTuple(n);
            if (!l.contains(t)) continue;
            l.remove(t);
        }
        return new TableRelation(p, l);
    }

    private boolean _in(RelationTuple t, RelationTuple v, Relation b) throws SQLException {
        for (SqlColumnDefinition s : b.getColumnNames()) {
            if (t.get(s.getName()).equals(v.get(s.getName()))) continue;
            return false;
        }
        return true;
    }

    Relation _divide(Relation a, Relation b) throws IOException, SQLException {
        LinkedHashMap<String, Object> n = new LinkedHashMap<String, Object>();
        LinkedHashSet<DefaultRelationTuple> l = null;
        ArrayList<SqlColumnDefinition> p = new ArrayList<SqlColumnDefinition>(a.getColumnNames());
        Iterator i = p.iterator();
        while (i.hasNext()) {
            SqlColumnDefinition d = (SqlColumnDefinition)i.next();
            for (SqlColumnDefinition g : b.getColumnNames()) {
                if (!d.getName().equals(g.getName())) continue;
                i.remove();
            }
        }
        RelationCursor c = b.iterator();
        while (c.hasNext()) {
            RelationTuple t = c.next();
            RelationCursor j = a.iterator();
            LinkedHashSet<DefaultRelationTuple> m = new LinkedHashSet<DefaultRelationTuple>();
            while (j.hasNext()) {
                RelationTuple v = j.next();
                if (!this._in(v, t, b)) continue;
                for (SqlColumnDefinition s : p) {
                    n.put(s.getName(), v.get(s.getName()));
                }
                m.add(new DefaultRelationTuple(n));
            }
            if (l == null) {
                l = m;
                continue;
            }
            l.retainAll(m);
        }
        if (l == null) {
            throw ErrorBundle.getDefault(10003, new Object[0]);
        }
        return new TableRelation(p, l);
    }

    public Relation visit(SqlSetExpression s, List<Object> h) throws IOException, SQLException {
        if (s instanceof SqlSetBinaryOperation) {
            SqlSetBinaryOperation b = (SqlSetBinaryOperation)s;
            Relation x = this.visit(b.getExpression1(), h);
            Relation y = this.visit(b.getExpression2(), h);
            switch (b.getOpeator()) {
                case UNION: {
                    return this._union(x, y);
                }
                case UNION_ALL: {
                    return new UnionAllRelation(x, y);
                }
                case INTERSECT: {
                    return this._intersect(x, y);
                }
                case MINUS: {
                    return this._except(x, y);
                }
                case DIVIDE: {
                    return this._divide(x, y);
                }
            }
        } else {
            if (s instanceof SqlSelect) {
                return this.visit((SqlSelect)s, Relations.NULLTUPLE, h);
            }
            throw new NullPointerException();
        }
        return null;
    }

    public Object visit(Object o, List<Object> h) throws IOException, SQLException {
        if (o instanceof SqlSetExpression) {
            return this.visit((SqlSetExpression)o, h);
        }
        if (o instanceof SqlInsertValues) {
            return this.visit((SqlInsertValues)o, h);
        }
        if (o instanceof SqlInsertSelect) {
            return this.visit((SqlInsertSelect)o, h);
        }
        if (o instanceof SqlUpdate) {
            return this.visit((SqlUpdate)o, h);
        }
        if (o instanceof SqlDelete) {
            return this.visit((SqlDelete)o, h);
        }
        if (o instanceof SqlCreateTable) {
            return this.visit((SqlCreateTable)o);
        }
        if (o instanceof SqlDropTable) {
            return this.visit((SqlDropTable)o);
        }
        if (o instanceof SqlTruncateTable) {
            return this.visit((SqlTruncateTable)o);
        }
        if (o instanceof SqlAlterTableAdd) {
            return this.visit((SqlAlterTableAdd)o);
        }
        if (o instanceof SqlAlterTableModify) {
            return this.visit((SqlAlterTableModify)o);
        }
        if (o instanceof SqlAlterTableDrop) {
            return this.visit((SqlAlterTableDrop)o);
        }
        if (o instanceof SqlAlterTableRenameColumn) {
            return this.visit((SqlAlterTableRenameColumn)o);
        }
        if (o instanceof SqlWith) {
            return this.visit((SqlWith)o);
        }
        throw ErrorBundle.getDefault(10039, new Object[0]);
    }

    public Object execute(String t, List<Object> h) throws IOException, SQLException {
        DbSqlLexer l = new DbSqlLexer(new StringReader(t));
        return this.visit(new DbSqlParser().parse(l), Collections.<Object>emptyList());
    }

    public Object execute(String t) throws IOException, SQLException {
        return this.execute(t, Collections.<Object>emptyList());
    }

    public Object visit(SqlWith c) throws IOException, SQLException {
        Map<String, SqlSetExpression> m = c.getWith();
        for (String x : m.keySet()) {
            this.schema.bindSchema(x, this.visit(m.get(x), Collections.<Object>emptyList()));
        }
        return new SqlResponse(true, "With statement processed");
    }
}

