/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.morilib.db.delay.Delay;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;

public class RelationFunctionApply
extends RelationExpression {
    private RelationFunction op;
    private List<RelationExpression> exs;

    public RelationFunctionApply(RelationFunction o, List<RelationExpression> ex) {
        this.op = o;
        this.exs = new ArrayList<RelationExpression>(ex);
    }

    @Override
    public Object eval(SqlEngine v, SqlSchema f, RelationTuple tuple, RelationAggregate m, List<String> group, List<Object> h) throws IOException, SQLException {
        Object[] a = new Object[this.exs.size()];
        ArrayList<Object> l = new ArrayList<Object>();
        int i = 0;
        while (i < this.exs.size()) {
            if (group != null) {
                for (String s : group) {
                    l.add(tuple.get(s));
                }
            }
            a[i] = this.op.isAggregate() ? this.exs.get(i).eval(v, f, tuple, null, null, h) : this.exs.get(i).eval(v, f, tuple, m, group, h);
            ++i;
        }
        return this.op.operate(m, l, a);
    }

    @Override
    public boolean isAggregate() throws SQLException {
        boolean b = this.op.isAggregate();
        if (b) {
            for (RelationExpression f : this.exs) {
                if (!f.isAggregate()) continue;
                throw ErrorBundle.getDefault(10048, new Object[0]);
            }
            return true;
        }
        for (RelationExpression f : this.exs) {
            if (!f.isAggregate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object init(SqlEngine v, SqlSchema s) throws SQLException {
        for (RelationExpression f : this.exs) {
            Object o = f.init(v, s);
            if (!(o instanceof Delay)) continue;
            return o;
        }
        return this.op.init();
    }
}

