/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.expr;

import java.math.MathContext;
import java.sql.SQLException;
import java.util.EnumMap;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.sqlcs.dml.SqlUnaryOperator;

public abstract class RelationUnaryOperator {
    static final MathContext MC = new MathContext(6);
    public static final RelationUnaryOperator MINUS = new RelationUnaryOperator(){

        @Override
        public Object op(Object a) throws SQLException {
            if (a instanceof Rational) {
                return ((Rational)a).negate();
            }
            if (a.equals("")) {
                return a;
            }
            throw ErrorBundle.getDefault(10040, "unary -");
        }
    };
    public static final RelationUnaryOperator PLUS = new RelationUnaryOperator(){

        @Override
        public Object op(Object a) throws SQLException {
            if (a instanceof Rational) {
                return a;
            }
            if (a.equals("")) {
                return a;
            }
            throw ErrorBundle.getDefault(10040, "unary +");
        }
    };
    public static final RelationUnaryOperator NOT = new RelationUnaryOperator(){

        @Override
        public Object op(Object a) throws SQLException {
            return RelationExpression.value(RelationExpression.bool(a).not());
        }
    };
    public static final RelationUnaryOperator IS_NULL = new RelationUnaryOperator(){

        @Override
        public Object op(Object a) throws SQLException {
            return RelationExpression.value(a.equals(""));
        }
    };
    public static final RelationUnaryOperator IS_NOT_NULL = new RelationUnaryOperator(){

        @Override
        public Object op(Object a) throws SQLException {
            return RelationExpression.value(!a.equals(""));
        }
    };
    private static EnumMap<SqlUnaryOperator, RelationUnaryOperator> map = new EnumMap(SqlUnaryOperator.class);

    static {
        map.put(SqlUnaryOperator.MINUS, MINUS);
        map.put(SqlUnaryOperator.PLUS, PLUS);
        map.put(SqlUnaryOperator.NOT, NOT);
        map.put(SqlUnaryOperator.IS_NULL, IS_NULL);
        map.put(SqlUnaryOperator.IS_NOT_NULL, IS_NOT_NULL);
    }

    public static RelationUnaryOperator get(SqlUnaryOperator s) {
        return map.get((Object)s);
    }

    public abstract Object op(Object var1) throws SQLException;
}

