/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.gui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class RelationQueryTableModel
extends AbstractTableModel {
    private List<SqlColumnDefinition> head;
    private List<RelationTuple> list;

    public RelationQueryTableModel(Relation r) throws IOException, SQLException {
        this.head = r.getColumnNames();
        this.list = new ArrayList<RelationTuple>();
        RelationCursor c = r.iterator();
        while (c.hasNext()) {
            this.list.add(c.next());
        }
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.head.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.head.get(columnIndex).getName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.head.get(columnIndex).getName().getClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            Map<String, Object> m = this.list.get(rowIndex).toMap();
            Iterator<Map.Entry<String, Object>> itr = m.entrySet().iterator();
            int i = 0;
            while (i < columnIndex) {
                ++i;
                itr.next();
            }
            Object o = itr.next().getValue();
            if (o instanceof Rational) {
                return ((Rational)o).toBigDecimal(4).stripTrailingZeros();
            }
            return o;
        }
        catch (SQLException e) {
            return "(fail to get)";
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }
}

