/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.map;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.map.SqlDataMapper;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.parser.csv.CSVConfig;
import net.morilib.parser.csv.CSVException;
import net.morilib.parser.csv.StringCSVPullParser;

public class CSVDataMapper
implements SqlDataMapper {
    private static final CSVConfig DEFT = new CSVConfig(",", 34, false);

    public static SingleTableRelation read(String name, String as, SqlCreateTable t, CSVConfig cfg, Reader rd) throws IOException, SQLException {
        ArrayList<RelationTuple> l = new ArrayList<RelationTuple>();
        StringCSVPullParser p = new StringCSVPullParser(rd, cfg);
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        ArrayList<String> n = new ArrayList<String>();
        int i = 0;
        while (i < t.getColumnDefinitions().size()) {
            n.add(t.getColumnDefinitions().get(i).getName());
            ++i;
        }
        try {
            while (p.next()) {
                String[] a = p.get();
                i = 0;
                while (i < t.getColumnDefinitions().size()) {
                    SqlColumnDefinition d = t.getColumnDefinitions().get(i);
                    Object o = i >= a.length ? RelationExpression.NULL : (a[i].equals(RelationExpression.NULL) ? a[i] : d.getType().cast(a[i]));
                    m.put(d.getName(), o);
                    ++i;
                }
                l.add(new DefaultRelationTuple(m));
            }
            SingleTableRelation singleTableRelation = new SingleTableRelation(t, as, l);
            return singleTableRelation;
        }
        catch (CSVException e) {
            throw new IOException(e);
        }
        finally {
            p.close();
        }
    }

    @Override
    public SingleTableRelation read(String name, String as, SqlCreateTable t, Reader rd) throws IOException, SQLException {
        return CSVDataMapper.read(name, as, t, DEFT, rd);
    }

    @Override
    public void write(String name, SqlCreateTable t, PrintWriter w, Collection<RelationTuple> l) throws IOException, SQLException {
        ArrayList<String> n = new ArrayList<String>();
        int i = 0;
        while (i < t.getColumnDefinitions().size()) {
            n.add(t.getColumnDefinitions().get(i).getName());
            ++i;
        }
        List<SqlColumnDefinition> f = t.getColumnDefinitions();
        try {
            for (RelationTuple p : l) {
                String d = "";
                int i2 = 0;
                while (i2 < f.size()) {
                    String v = p.get(f.get(i2).getName()).toString();
                    Object o = f.get(i2).getType().cast(v);
                    v = f.get(i2).getType().string(o);
                    w.print(d);
                    w.print('\"');
                    w.print(v.replaceAll("\"", "\"\""));
                    w.print('\"');
                    d = ",";
                    ++i2;
                }
                w.println();
            }
        }
        finally {
            w.flush();
            w.close();
        }
    }
}

