/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.AbstractRelation;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class IsolatedRelation
extends AbstractRelation {
    private Relation rel;
    private String name;

    public IsolatedRelation(Relation r, String n) {
        this.rel = r;
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<SqlColumnDefinition> getColumnNames() {
        ArrayList<SqlColumnDefinition> l = new ArrayList<SqlColumnDefinition>(this.rel.getColumnNames());
        for (SqlColumnDefinition s : this.rel.getColumnNames()) {
            l.add(new SqlColumnDefinition(String.valueOf(this.name) + "." + s.getName(), s.getType(), s.getAttributes()));
        }
        return l;
    }

    @Override
    public RelationCursor iterator() {
        final RelationCursor c = this.rel.iterator();
        return new RelationCursor(){

            @Override
            public boolean hasNext() {
                return c.hasNext();
            }

            @Override
            public RelationTuple next() throws IOException, SQLException {
                final RelationTuple t = c.next();
                return new RelationTuple(){

                    @Override
                    public Object get(String name) throws SQLException {
                        int i = name.indexOf(46);
                        if (i < 0) {
                            return t.get(name);
                        }
                        if (name.substring(0, i).equals(name)) {
                            return t.get(name.substring(i + 1));
                        }
                        throw ErrorBundle.getDefault(10009, name);
                    }

                    @Override
                    public RelationTuple copy() throws SQLException {
                        return new DefaultRelationTuple(this.toMap());
                    }

                    @Override
                    public Map<String, Object> toMap() throws SQLException {
                        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                        Map<String, Object> s = t.toMap();
                        m.putAll(s);
                        for (String v : s.keySet()) {
                            m.put(String.valueOf(IsolatedRelation.this.name) + "." + v, s.get(v));
                        }
                        return m;
                    }
                };
            }
        };
    }

    @Override
    public SqlColumnDefinition getDefinition(String name) {
        return this.rel.getDefinition(name);
    }
}

