/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.morilib.db.relations.RelationScanEvent;
import net.morilib.db.relations.RelationScanListener;
import net.morilib.db.relations.RelationTuple;

public abstract class RelationCursor {
    private List<RelationScanListener> listeners = new ArrayList<RelationScanListener>();

    public abstract boolean hasNext();

    public abstract RelationTuple next() throws IOException, SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelationScanListener(RelationScanListener l) {
        List<RelationScanListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelationScanListener(RelationScanListener l) {
        List<RelationScanListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    protected void fireScaned(RelationTuple t) throws SQLException {
        RelationScanEvent e = new RelationScanEvent(this, t);
        for (RelationScanListener l : this.listeners) {
            l.scaned(e);
        }
    }
}

