/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.ParseDate;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlColumnType;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.sqlcs.ddl.SqlTypeDate;
import net.morilib.db.sqlcs.ddl.SqlTypeNumeric;
import net.morilib.db.sqlcs.ddl.SqlTypeVarchar;
import net.morilib.parser.csv.CSVConfig;
import net.morilib.parser.csv.CSVException;
import net.morilib.parser.csv.StringCSVPullParser;

public final class SqlSchemata {
    private static final CSVConfig DEFT = new CSVConfig(",", 34, false);
    private static final Pattern PT1 = Pattern.compile("([0-9]+)|([0-9]*)\\.([0-9]+)");
    private static final Pattern PT2 = Pattern.compile("(.*/)?([^.]+)");
    private static final SqlTypeNumeric UNLIMITED_INTEGER = new SqlTypeNumeric(0, 0);
    private static int seq = 1;

    private SqlSchemata() {
    }

    private static SqlTypeNumeric getlen(SqlTypeNumeric n, Matcher m) {
        if (m.group(1) != null) {
            return n == null || n.getScale() <= 0 ? UNLIMITED_INTEGER : n;
        }
        int j = m.group(3).length();
        return n == null || n.getScale() <= j ? new SqlTypeNumeric(0, j) : n;
    }

    public static SqlCreateTable guessTableWithoutKeys(String s, InputStream ins) throws IOException, SQLException {
        StringCSVPullParser p = null;
        BufferedReader r = null;
        try {
            Matcher w;
            r = new BufferedReader(new InputStreamReader(ins));
            p = new StringCSVPullParser(r, DEFT);
            if (!p.next()) {
                throw ErrorBundle.getDefault(10018, new Object[0]);
            }
            ArrayList<String> n = new ArrayList<String>(Arrays.asList(p.get()));
            HashSet z = new HashSet();
            int i = 0;
            while (i < n.size()) {
                if (((String)n.get(i)).equals("") || z.contains(n.get(i))) {
                    n.set(i, String.valueOf(((String)n.get(i)).toUpperCase()) + i);
                } else {
                    n.set(i, ((String)n.get(i)).toUpperCase());
                }
                ++i;
            }
            SqlColumnType[] t = new SqlColumnType[n.size()];
            i = 0;
            while (i < n.size()) {
                t[i] = null;
                ++i;
            }
            while (p.next()) {
                String[] y = p.get();
                i = 0;
                while (i < n.size()) {
                    if (i < y.length && !y[i].equals(RelationExpression.NULL)) {
                        if ((t[i] == null || t[i] instanceof SqlTypeNumeric) && (w = PT1.matcher(y[i])).matches()) {
                            t[i] = SqlSchemata.getlen((SqlTypeNumeric)t[i], w);
                        } else if ((t[i] == null || t[i] instanceof SqlTypeDate) && ParseDate.getDate(y[i]) != null) {
                            t[i] = t[i] == null ? new SqlTypeDate() : t[i];
                        } else if (!(t[i] instanceof SqlTypeVarchar)) {
                            t[i] = new SqlTypeVarchar(0);
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < n.size()) {
                if (t[i] == null) {
                    t[i] = new SqlTypeVarchar(0);
                }
                ++i;
            }
            ArrayList<SqlColumnDefinition> l = new ArrayList<SqlColumnDefinition>();
            i = 0;
            while (i < n.size()) {
                l.add(new SqlColumnDefinition((String)n.get(i), t[i], EnumSet.noneOf(SqlColumnAttribute.class)));
                ++i;
            }
            w = PT2.matcher(s);
            String v = w.lookingAt() ? w.group(2) : "table" + seq++;
            SqlCreateTable sqlCreateTable = new SqlCreateTable(v.toUpperCase(), l);
            return sqlCreateTable;
        }
        catch (CSVException e) {
            throw ErrorBundle.getDefault(10042, new Object[0]);
        }
        finally {
            if (p != null) {
                p.close();
            }
        }
    }

    public static SqlCreateTable guessTable(String s, InputStream ins) throws IOException, SQLException {
        StringCSVPullParser p = null;
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(ins));
            p = new StringCSVPullParser(r, DEFT);
            ArrayList<List<String>> t = new ArrayList<List<String>>();
            while (p.next()) {
                String[] y = p.get();
                t.add(Arrays.asList(y));
            }
            SqlCreateTable sqlCreateTable = SqlSchemata.guessTable(s, t);
            return sqlCreateTable;
        }
        catch (CSVException e) {
            throw ErrorBundle.getDefault(10042, new Object[0]);
        }
        finally {
            if (p != null) {
                p.close();
            }
        }
    }

    public static SqlCreateTable guessTable(String s, List<List<String>> tbl) throws IOException, SQLException {
        Matcher w;
        int i;
        String[] y;
        boolean a = false;
        int m = 0;
        if (tbl.size() == 0) {
            throw ErrorBundle.getDefault(10018, new Object[0]);
        }
        ArrayList<String> n = new ArrayList<String>((Collection)tbl.get(0));
        HashSet z = new HashSet();
        int i2 = 0;
        while (i2 < n.size()) {
            if (((String)n.get(i2)).equals("") || z.contains(n.get(i2))) {
                n.set(i2, String.valueOf(((String)n.get(i2)).toUpperCase()) + i2);
            } else {
                n.set(i2, ((String)n.get(i2)).toUpperCase());
            }
            ++i2;
        }
        SqlColumnType[] t = new SqlColumnType[n.size()];
        i2 = 0;
        while (i2 < n.size()) {
            t[i2] = null;
            ++i2;
        }
        int j = 1;
        while (j < tbl.size()) {
            y = tbl.get(j).toArray(new String[0]);
            i = 0;
            while (i < n.size()) {
                if (i < y.length && y[i] != null && !y[i].equals("")) {
                    if ((t[i] == null || t[i] instanceof SqlTypeNumeric) && (w = PT1.matcher(y[i])).matches()) {
                        t[i] = SqlSchemata.getlen((SqlTypeNumeric)t[i], w);
                    } else if ((t[i] == null || t[i] instanceof SqlTypeDate) && ParseDate.getDate(y[i]) != null) {
                        t[i] = t[i] == null ? new SqlTypeDate() : t[i];
                    } else if (!(t[i] instanceof SqlTypeVarchar)) {
                        t[i] = new SqlTypeVarchar(0);
                    }
                }
                ++i;
            }
            ++j;
        }
        i2 = 0;
        while (i2 < n.size()) {
            if (t[i2] == null) {
                t[i2] = new SqlTypeVarchar(0);
            }
            ++i2;
        }
        ArrayList<EnumSet<SqlColumnAttribute>> f = new ArrayList<EnumSet<SqlColumnAttribute>>();
        ArrayList k = new ArrayList();
        i2 = 0;
        while (i2 < n.size()) {
            f.add(EnumSet.noneOf(SqlColumnAttribute.class));
            k.add(new HashSet());
            if (t[i2] == null) {
                t[i2] = new SqlTypeVarchar(0);
            }
            ++i2;
        }
        j = 1;
        while (j < tbl.size()) {
            y = tbl.get(j).toArray(new String[0]);
            i = 0;
            while (i < n.size()) {
                ((Set)k.get(i)).add(i < y.length ? t[i].cast(y[i]) : "");
                ++i;
            }
            ++j;
            ++m;
        }
        i2 = 0;
        while (i2 < n.size()) {
            f.set(i2, EnumSet.of(SqlColumnAttribute.PRIMARY_KEY, SqlColumnAttribute.NOT_NULL));
            a = ((Set)k.get(i2)).size() == m;
            if (a) break;
            ++i2;
        }
        if (!a) {
            i2 = 0;
            while (i2 < n.size()) {
                f.set(i2, EnumSet.noneOf(SqlColumnAttribute.class));
                ++i2;
            }
        }
        ArrayList<SqlColumnDefinition> l = new ArrayList<SqlColumnDefinition>();
        i2 = 0;
        while (i2 < n.size()) {
            l.add(new SqlColumnDefinition((String)n.get(i2), t[i2], (EnumSet)f.get(i2)));
            ++i2;
        }
        w = PT2.matcher(s);
        String v = w.lookingAt() ? w.group(2) : "table" + seq++;
        return new SqlCreateTable(v.toUpperCase(), l);
    }

    public static NamedRelation readRelation(String name, String as, List<List<String>> l) throws IOException, SQLException {
        BufferedReader b = null;
        try {
            SqlCreateTable t = SqlSchemata.guessTable(name, l);
            ArrayList<RelationTuple> r = new ArrayList<RelationTuple>();
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            List<SqlColumnDefinition> d = t.getColumnDefinitions();
            int i = 1;
            while (i < l.size()) {
                int j = 0;
                while (j < d.size()) {
                    m.put(d.get(j).getName(), d.get(j).getType().cast(l.get(i).get(j)));
                    ++j;
                }
                r.add(new DefaultRelationTuple(m));
                ++i;
            }
            SingleTableRelation singleTableRelation = new SingleTableRelation(t, as != null ? as : name, r);
            return singleTableRelation;
        }
        finally {
            if (b != null) {
                b.close();
            }
        }
    }

    public static SqlCreateTable guessTable(String s) throws IOException, SQLException {
        return SqlSchemata.guessTable(s, new FileInputStream(s));
    }
}

