/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sqlcs.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morilib.db.sqlcs.ddl.SqlColumnAttribute;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class SqlAlterTableAdd {
    private String name;
    private List<SqlColumnDefinition> defs;

    public SqlAlterTableAdd(String n, List<SqlColumnDefinition> d) {
        this.name = n;
        this.defs = new ArrayList<SqlColumnDefinition>(d);
    }

    public String getName() {
        return this.name;
    }

    public List<SqlColumnDefinition> getColumnDefinitions() {
        return Collections.unmodifiableList(this.defs);
    }

    public List<String> getKeys() {
        ArrayList<String> l = new ArrayList<String>();
        for (SqlColumnDefinition d : this.defs) {
            if (!d.getAttributes().contains((Object)SqlColumnAttribute.PRIMARY_KEY)) continue;
            l.add(d.getName());
        }
        return l;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("ALTER TABLE ");
        String d = "\n  ";
        b.append(this.name).append(" ADD (");
        for (SqlColumnDefinition x : this.defs) {
            b.append(d).append(x);
            d = ",\n  ";
        }
        return b.append('\n').append(')').toString();
    }
}

