package net.morilib.db.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;

import net.morilib.db.RePlus;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.functions.FunctionType;
import net.morilib.db.info.ColumnsInfo;
import net.morilib.db.info.PrimaryKeysInfo;
import net.morilib.db.info.TableTypesInfo;
import net.morilib.db.info.TablesInfo;
import net.morilib.db.info.TypeInfoInfo;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.RelationsLogger;

public class RelationsDatabaseMetadata implements DatabaseMetaData {

	private static RelationsLogger logger = RelationsJDBCUtils.logger;

	RelationsConnection conn;

	RelationsDatabaseMetadata(RelationsConnection c) {
		conn = c;
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException {
		logger.finer("unwrap");
		throw new SQLFeatureNotSupportedException();
	}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		logger.finer("isWrapperFor");
		return false;
	}

	@Override
	public boolean allProceduresAreCallable() throws SQLException {
		logger.finer("allProceduresAreCallable");
		return false;
	}

	@Override
	public boolean allTablesAreSelectable() throws SQLException {
		logger.finer("allTablesAreSelectable");
		return true;
	}

	@Override
	public String getURL() throws SQLException {
		logger.finer("getURL");
		return null;
	}

	@Override
	public String getUserName() throws SQLException {
		logger.finer("getUserName");
		return "user";
	}

	@Override
	public boolean isReadOnly() throws SQLException {
		logger.finer("isReadOnly");
		return conn.isReadOnly();
	}

	@Override
	public boolean nullsAreSortedHigh() throws SQLException {
		logger.finer("nullsAreSortedHigh");
		return true;
	}

	@Override
	public boolean nullsAreSortedLow() throws SQLException {
		logger.finer("nullsAreSortedLow");
		return false;
	}

	@Override
	public boolean nullsAreSortedAtStart() throws SQLException {
		logger.finer("nullsAreSortedAtStart");
		return false;
	}

	@Override
	public boolean nullsAreSortedAtEnd() throws SQLException {
		logger.finer("nullsAreSortedAtEnd");
		return false;
	}

	@Override
	public String getDatabaseProductName() throws SQLException {
		logger.finer("getDatabaseProductName");
		return "morilib relations";
	}

	@Override
	public String getDatabaseProductVersion() throws SQLException {
		logger.finer("getDatabaseProductVersion");
		return RePlus.VERSION;
	}

	@Override
	public String getDriverName() throws SQLException {
		logger.finer("getDriverName");
		return "morilib relations JDBC driver";
	}

	@Override
	public String getDriverVersion() throws SQLException {
		logger.finer("getDriverVersion");
		return "0.0";
	}

	@Override
	public int getDriverMajorVersion() {
		logger.finer("getDriverMajorVersion");
		return 0;
	}

	@Override
	public int getDriverMinorVersion() {
		logger.finer("getDriverMinorVersion");
		return 0;
	}

	@Override
	public boolean usesLocalFiles() throws SQLException {
		logger.finer("usesLocalFiles");
		return conn.engine.getSchema().usesLocalFiles().isTrue();
	}

	@Override
	public boolean usesLocalFilePerTable() throws SQLException {
		logger.finer("usesLocalFilePerTable");
		return conn.engine.getSchema().usesLocalFilePerTable().isTrue();
	}

	@Override
	public boolean supportsMixedCaseIdentifiers() throws SQLException {
		logger.finer("supportsMixedCaseIdentifiers");
		return false;
	}

	@Override
	public boolean storesUpperCaseIdentifiers() throws SQLException {
		logger.finer("storesUpperCaseIdentifiers");
		return true;
	}

	@Override
	public boolean storesLowerCaseIdentifiers() throws SQLException {
		logger.finer("storesLowerCaseIdentifiers");
		return false;
	}

	@Override
	public boolean storesMixedCaseIdentifiers() throws SQLException {
		logger.finer("storesMixedCaseIdentifiers");
		return false;
	}

	@Override
	public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
		logger.finer("supportsMixedCaseQuotedIdentifiers");
		return false;
	}

	@Override
	public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
		logger.finer("storesUpperCaseQuotedIdentifiers");
		return true;
	}

	@Override
	public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
		logger.finer("storesLowerCaseQuotedIdentifiers");
		return false;
	}

	@Override
	public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
		logger.finer("storesMixedCaseQuotedIdentifiers");
		return false;
	}

	@Override
	public String getIdentifierQuoteString() throws SQLException {
		logger.finer("getIdentifierQuoteString");
		return "\"";
	}

	@Override
	public String getSQLKeywords() throws SQLException {
		logger.finer("getSQLKeywords");
		return "";
	}

	@Override
	public String getNumericFunctions() throws SQLException {
		logger.finer("getNumericFunctions");
		return RelationFunction.getListString(FunctionType.NUMERIC);
	}

	@Override
	public String getStringFunctions() throws SQLException {
		logger.finer("getStringFunctions");
		return RelationFunction.getListString(FunctionType.STRING);
	}

	@Override
	public String getSystemFunctions() throws SQLException {
		logger.finer("getSystemFunctions");
		return RelationFunction.getListString(FunctionType.SYSTEM);
	}

	@Override
	public String getTimeDateFunctions() throws SQLException {
		logger.finer("getTimeDateFunctions");
		return RelationFunction.getListString(FunctionType.TIME_DATE);
	}

	@Override
	public String getSearchStringEscape() throws SQLException {
		logger.finer("getSearchStringEscape");
		return "\\";
	}

	@Override
	public String getExtraNameCharacters() throws SQLException {
		logger.finer("getExtraNameCharacters");
		return "$";
	}

	@Override
	public boolean supportsAlterTableWithAddColumn() throws SQLException {
		logger.finer("supportsAlterTableWithAddColumn");
		return !conn.isReadOnly();
	}

	@Override
	public boolean supportsAlterTableWithDropColumn() throws SQLException {
		logger.finer("supportsAlterTableWithDropColumn");
		return !conn.isReadOnly();
	}

	@Override
	public boolean supportsColumnAliasing() throws SQLException {
		logger.finer("supportsColumnAliasing");
		return false;
	}

	@Override
	public boolean nullPlusNonNullIsNull() throws SQLException {
		logger.finer("nullPlusNonNullIsNull");
		return false;
	}

	@Override
	public boolean supportsConvert() throws SQLException {
		logger.finer("supportsConvert");
		return false;
	}

	@Override
	public boolean supportsConvert(int fromType,
			int toType) throws SQLException {
		logger.finer("supportsConvert");
		return false;
	}

	@Override
	public boolean supportsTableCorrelationNames() throws SQLException {
		logger.finer("supportsTableCorrelationNames");
		return false;
	}

	@Override
	public boolean supportsDifferentTableCorrelationNames() throws SQLException {
		logger.finer("supportsDifferentTableCorrelationNames");
		return false;
	}

	@Override
	public boolean supportsExpressionsInOrderBy() throws SQLException {
		logger.finer("supportsExpressionsInOrderBy");
		return false;
	}

	@Override
	public boolean supportsOrderByUnrelated() throws SQLException {
		logger.finer("supportsOrderByUnrelated");
		return false;
	}

	@Override
	public boolean supportsGroupBy() throws SQLException {
		logger.finer("supportsGroupBy");
		return true;
	}

	@Override
	public boolean supportsGroupByUnrelated() throws SQLException {
		logger.finer("supportsGroupByUnrelated");
		return false;
	}

	@Override
	public boolean supportsGroupByBeyondSelect() throws SQLException {
		logger.finer("supportsGroupByBeyondSelect");
		return false;
	}

	@Override
	public boolean supportsLikeEscapeClause() throws SQLException {
		logger.finer("supportsLikeEscapeClause");
		return true;
	}

	@Override
	public boolean supportsMultipleResultSets() throws SQLException {
		logger.finer("supportsMultipleResultSets");
		return false;
	}

	@Override
	public boolean supportsMultipleTransactions() throws SQLException {
		logger.finer("supportsMultipleTransactions");
		return false;
	}

	@Override
	public boolean supportsNonNullableColumns() throws SQLException {
		logger.finer("supportsNonNullableColumns");
		return false;
	}

	@Override
	public boolean supportsMinimumSQLGrammar() throws SQLException {
		logger.finer("supportsMinimumSQLGrammar");
		return false;
	}

	@Override
	public boolean supportsCoreSQLGrammar() throws SQLException {
		logger.finer("supportsCoreSQLGrammar");
		return false;
	}

	@Override
	public boolean supportsExtendedSQLGrammar() throws SQLException {
		logger.finer("supportsExtendedSQLGrammar");
		return false;
	}

	@Override
	public boolean supportsANSI92EntryLevelSQL() throws SQLException {
		logger.finer("supportsANSI92EntryLevelSQL");
		return false;
	}

	@Override
	public boolean supportsANSI92IntermediateSQL() throws SQLException {
		logger.finer("supportsANSI92IntermediateSQL");
		return false;
	}

	@Override
	public boolean supportsANSI92FullSQL() throws SQLException {
		logger.finer("supportsANSI92FullSQL");
		return false;
	}

	@Override
	public boolean supportsIntegrityEnhancementFacility() throws SQLException {
		logger.finer("supportsIntegrityEnhancementFacility");
		return false;
	}

	@Override
	public boolean supportsOuterJoins() throws SQLException {
		logger.finer("supportsOuterJoins");
		return true;
	}

	@Override
	public boolean supportsFullOuterJoins() throws SQLException {
		logger.finer("supportsFullOuterJoins");
		return false;
	}

	@Override
	public boolean supportsLimitedOuterJoins() throws SQLException {
		logger.finer("supportsLimitedOuterJoins");
		return false;
	}

	@Override
	public String getSchemaTerm() throws SQLException {
		logger.finer("getSchemaTerm");
		return "schema";
	}

	@Override
	public String getProcedureTerm() throws SQLException {
		logger.finer("getProcedureTerm");
		return "procedure";
	}

	@Override
	public String getCatalogTerm() throws SQLException {
		logger.finer("getCatalogTerm");
		return "catalog";
	}

	@Override
	public boolean isCatalogAtStart() throws SQLException {
		logger.finer("isCatalogAtStart");
		return false;
	}

	@Override
	public String getCatalogSeparator() throws SQLException {
		logger.finer("getCatalogSeparator");
		return null;
	}

	@Override
	public boolean supportsSchemasInDataManipulation() throws SQLException {
		logger.finer("supportsSchemasInDataManipulation");
		return false;
	}

	@Override
	public boolean supportsSchemasInProcedureCalls() throws SQLException {
		logger.finer("supportsSchemasInProcedureCalls");
		return false;
	}

	@Override
	public boolean supportsSchemasInTableDefinitions() throws SQLException {
		logger.finer("supportsSchemasInTableDefinitions");
		return false;
	}

	@Override
	public boolean supportsSchemasInIndexDefinitions() throws SQLException {
		logger.finer("supportsSchemasInIndexDefinitions");
		return false;
	}

	@Override
	public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
		logger.finer("supportsSchemasInPrivilegeDefinitions");
		return false;
	}

	@Override
	public boolean supportsCatalogsInDataManipulation() throws SQLException {
		logger.finer("supportsCatalogsInDataManipulation");
		return false;
	}

	@Override
	public boolean supportsCatalogsInProcedureCalls() throws SQLException {
		logger.finer("supportsCatalogsInProcedureCalls");
		return false;
	}

	@Override
	public boolean supportsCatalogsInTableDefinitions() throws SQLException {
		logger.finer("supportsCatalogsInTableDefinitions");
		return false;
	}

	@Override
	public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
		logger.finer("supportsCatalogsInIndexDefinitions");
		return false;
	}

	@Override
	public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
		logger.finer("supportsCatalogsInPrivilegeDefinitions");
		return false;
	}

	@Override
	public boolean supportsPositionedDelete() throws SQLException {
		logger.finer("supportsPositionedDelete");
		return false;
	}

	@Override
	public boolean supportsPositionedUpdate() throws SQLException {
		logger.finer("supportsPositionedUpdate");
		return false;
	}

	@Override
	public boolean supportsSelectForUpdate() throws SQLException {
		logger.finer("supportsSelectForUpdate");
		return false;
	}

	@Override
	public boolean supportsStoredProcedures() throws SQLException {
		// TODO
		logger.finer("supportsStoredProcedures");
		return false;
	}

	@Override
	public boolean supportsSubqueriesInComparisons() throws SQLException {
		logger.finer("supportsSubqueriesInComparisons");
		return true;
	}

	@Override
	public boolean supportsSubqueriesInExists() throws SQLException {
		logger.finer("supportsSubqueriesInExists");
		return true;
	}

	@Override
	public boolean supportsSubqueriesInIns() throws SQLException {
		logger.finer("supportsSubqueriesInIns");
		return true;
	}

	@Override
	public boolean supportsSubqueriesInQuantifieds() throws SQLException {
		logger.finer("supportsSubqueriesInQuantifieds");
		return true;
	}

	@Override
	public boolean supportsCorrelatedSubqueries() throws SQLException {
		logger.finer("supportsCorrelatedSubqueries");
		return true;
	}

	@Override
	public boolean supportsUnion() throws SQLException {
		logger.finer("supportsUnion");
		return true;
	}

	@Override
	public boolean supportsUnionAll() throws SQLException {
		logger.finer("supportsUnionAll");
		return true;
	}

	@Override
	public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
		logger.finer("supportsOpenCursorsAcrossCommit");
		return false;
	}

	@Override
	public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
		logger.finer("supportsOpenCursorsAcrossRollback");
		return false;
	}

	@Override
	public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
		logger.finer("supportsOpenStatementsAcrossCommit");
		return false;
	}

	@Override
	public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
		logger.finer("supportsOpenStatementsAcrossRollback");
		return false;
	}

	@Override
	public int getMaxBinaryLiteralLength() throws SQLException {
		logger.finer("getMaxBinaryLiteralLength");
		return 0;
	}

	@Override
	public int getMaxCharLiteralLength() throws SQLException {
		logger.finer("getMaxCharLiteralLength");
		return 0;
	}

	@Override
	public int getMaxColumnNameLength() throws SQLException {
		logger.finer("getMaxColumnNameLength");
		return 0;
	}

	@Override
	public int getMaxColumnsInGroupBy() throws SQLException {
		logger.finer("getMaxColumnsInGroupBy");
		return 0;
	}

	@Override
	public int getMaxColumnsInIndex() throws SQLException {
		logger.finer("getMaxColumnsInIndex");
		return 0;
	}

	@Override
	public int getMaxColumnsInOrderBy() throws SQLException {
		logger.finer("getMaxColumnsInOrderBy");
		return 0;
	}

	@Override
	public int getMaxColumnsInSelect() throws SQLException {
		logger.finer("getMaxColumnsInSelect");
		return 0;
	}

	@Override
	public int getMaxColumnsInTable() throws SQLException {
		logger.finer("getMaxColumnsInTable");
		return 0;
	}

	@Override
	public int getMaxConnections() throws SQLException {
		logger.finer("getMaxConnections");
		return 0;
	}

	@Override
	public int getMaxCursorNameLength() throws SQLException {
		logger.finer("getMaxCursorNameLength");
		return 0;
	}

	@Override
	public int getMaxIndexLength() throws SQLException {
		logger.finer("getMaxIndexLength");
		return 0;
	}

	@Override
	public int getMaxSchemaNameLength() throws SQLException {
		logger.finer("getMaxSchemaNameLength");
		return 0;
	}

	@Override
	public int getMaxProcedureNameLength() throws SQLException {
		logger.finer("getMaxProcedureNameLength");
		return 0;
	}

	@Override
	public int getMaxCatalogNameLength() throws SQLException {
		logger.finer("getMaxCatalogNameLength");
		return 0;
	}

	@Override
	public int getMaxRowSize() throws SQLException {
		logger.finer("getMaxRowSize");
		return 0;
	}

	@Override
	public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
		logger.finer("doesMaxRowSizeIncludeBlobs");
		return false;
	}

	@Override
	public int getMaxStatementLength() throws SQLException {
		logger.finer("getMaxStatementLength");
		return 0;
	}

	@Override
	public int getMaxStatements() throws SQLException {
		logger.finer("getMaxStatements");
		return 0;
	}

	@Override
	public int getMaxTableNameLength() throws SQLException {
		logger.finer("getMaxTableNameLength");
		return 0;
	}

	@Override
	public int getMaxTablesInSelect() throws SQLException {
		logger.finer("getMaxTablesInSelect");
		return 0;
	}

	@Override
	public int getMaxUserNameLength() throws SQLException {
		logger.finer("getMaxUserNameLength");
		return 0;
	}

	@Override
	public int getDefaultTransactionIsolation() throws SQLException {
		logger.finer("getDefaultTransactionIsolation");
		return Connection.TRANSACTION_NONE;
	}

	@Override
	public boolean supportsTransactions() throws SQLException {
		logger.finer("supportsTransactions");
		return false;
	}

	@Override
	public boolean supportsTransactionIsolationLevel(
			int level) throws SQLException {
		logger.finer("supportsTransactionIsolationLevel");
		return false;
	}

	@Override
	public boolean supportsDataDefinitionAndDataManipulationTransactions(
			) throws SQLException {
		logger.finer("supportsDataDefinitionAndDataManipulationTransactions");
		return false;
	}

	@Override
	public boolean supportsDataManipulationTransactionsOnly(
			) throws SQLException {
		logger.finer("supportsDataManipulationTransactionsOnly");
		return false;
	}

	@Override
	public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
		logger.finer("dataDefinitionCausesTransactionCommit");
		return false;
	}

	@Override
	public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
		logger.finer("dataDefinitionIgnoredInTransactions");
		return false;
	}

	@Override
	public ResultSet getProcedures(String catalog,
			String schemaPattern,
			String procedureNamePattern) throws SQLException {
		// TODO
		logger.finer("getProcedures");
		return new NullResultSet(
				"PROCEDURE_CAT",
				"PROCEDURE_SCHEM",
				"PROCEDURE_NAME",
				"",
				"",
				"",
				"REMARKS",
				"PROCEDURE_TYPE",
				"SPECIFIC_NAME");
	}

	@Override
	public ResultSet getProcedureColumns(String catalog,
			String schemaPattern, String procedureNamePattern,
			String columnNamePattern) throws SQLException {
		// TODO
		logger.finer("getProcedureColumns");
		return new NullResultSet(
				"PROCEDURE_CAT",
				"PROCEDURE_SCHEM",
				"PROCEDURE_NAME",
				"COLUMN_NAME",
				"COLUMN_TYPE",
				"DATA_TYPE",
				"TYPE_NAME",
				"PRECISION",
				"LENGTH",
				"SCALE",
				"RADIX",
				"NULLABLE",
				"REMARKS",
				"COLUMN_DEF",
				"SQL_DATA_TYPE",
				"SQL_DATETIME_SUB",
				"CHAR_OCTET_LENGTH",
				"ORDINAL_POSITION",
				"IS_NULLABLE",
				"SPECIFIC_NAME");
	}

	@Override
	public ResultSet getTables(String catalog, String schemaPattern,
			String tableNamePattern,
			String[] types) throws SQLException {
		logger.finer("getTables");
		logger.finer("catalog:" + catalog);
		logger.finer("schemaPattern:" + schemaPattern);
		logger.finer("tableNamePattern:" + tableNamePattern);
		logger.finer("types:" + Arrays.toString(types));
		try {
			return TablesInfo.get(conn.engine.getSchema(),
					tableNamePattern, types);
		} catch (IOException e) {
			throw ErrorBundle.getIODefault(e);
		}
	}

	@Override
	public ResultSet getSchemas() throws SQLException {
		logger.finer("getSchemas");
		return new NullResultSet(
				"TABLE_SCHEM",
				"TABLE_CATALOG");
	}

	@Override
	public ResultSet getCatalogs() throws SQLException {
		logger.finer("getCatalogs");
		return new NullResultSet("TABLE_CAT");
	}

	@Override
	public ResultSet getTableTypes() throws SQLException {
		logger.finer("getTableTypes");
		try {
			return TableTypesInfo.get();
		} catch (IOException e) {
			throw ErrorBundle.getIODefault(e);
		}
	}

	@Override
	public ResultSet getColumns(String catalog, String schemaPattern,
			String tableNamePattern,
			String columnNamePattern) throws SQLException {
		logger.finer("getColumns");
		try {
			return ColumnsInfo.get(conn.engine.getSchema(),
					tableNamePattern, columnNamePattern);
		} catch (IOException e) {
			throw ErrorBundle.getIODefault(e);
		}
	}

	@Override
	public ResultSet getColumnPrivileges(String catalog, String schema,
			String table,
			String columnNamePattern) throws SQLException {
		logger.finer("getColumnPrivileges");
		return new NullResultSet(
				"TABLE_CAT",
				"TABLE_SCHEM",
				"TABLE_NAME",
				"COLUMN_NAME",
				"GRANTOR",
				"GRANTEE",
				"PRIVILEGE",
				"IS_GRANTABLE");
	}

	@Override
	public ResultSet getTablePrivileges(String catalog,
			String schemaPattern,
			String getTablePrivileges) throws SQLException {
		logger.finer("getColumnPrivileges");
		return new NullResultSet(
				"TABLE_CAT",
				"TABLE_SCHEM",
				"TABLE_NAME",
				"GRANTOR",
				"GRANTEE",
				"PRIVILEGE",
				"IS_GRANTABLE");
	}

	@Override
	public ResultSet getBestRowIdentifier(String catalog,
			String schema, String table, int scope,
			boolean nullable) throws SQLException {
		logger.finer("getBestRowIdentifier");
		return new NullResultSet(
				"SCOPE",
				"COLUMN_NAME",
				"DATA_TYPE",
				"TYPE_NAME",
				"COLUMN_SIZE",
				"BUFFER_LENGTH",
				"DECIMAL_DIGITS",
				"PSEUDO_COLUMN");
	}

	@Override
	public ResultSet getVersionColumns(String catalog, String schema,
			String table) throws SQLException {
		logger.finer("getVersionColumns");
		return new NullResultSet(
				"SCOPE",
				"COLUMN_NAME",
				"DATA_TYPE",
				"TYPE_NAME",
				"COLUMN_SIZE",
				"BUFFER_LENGTH",
				"DECIMAL_DIGITS",
				"PSEUDO_COLUMN");
	}

	@Override
	public ResultSet getPrimaryKeys(String catalog, String schema,
			String table) throws SQLException {
		logger.finer("getPrimaryKeys");
		try {
			return PrimaryKeysInfo.get(conn.engine.getSchema(), table);
		} catch (IOException e) {
			throw ErrorBundle.getIODefault(e);
		}
	}

	@Override
	public ResultSet getImportedKeys(String catalog, String schema,
			String table) throws SQLException {
		logger.finer("getImportedKeys");
		return new NullResultSet(
				"PKTABLE_CAT",
				"PKTABLE_SCHEM",
				"PKTABLE_NAME",
				"PKCOLUMN_NAME",
				"FKTABLE_CAT",
				"FKTABLE_SCHEM",
				"FKTABLE_NAME",
				"FKCOLUMN_NAME",
				"KEY_SEQ",
				"UPDATE_RULE",
				"DELETE_RULE",
				"FK_NAME",
				"PK_NAME",
				"DEFERRABILITY");
	}

	@Override
	public ResultSet getExportedKeys(String catalog, String schema,
			String table) throws SQLException {
		logger.finer("getExportedKeys");
		return new NullResultSet(
				"PKTABLE_CAT",
				"PKTABLE_SCHEM",
				"PKTABLE_NAME",
				"PKCOLUMN_NAME",
				"FKTABLE_CAT",
				"FKTABLE_SCHEM",
				"FKTABLE_NAME",
				"FKCOLUMN_NAME",
				"KEY_SEQ",
				"UPDATE_RULE",
				"DELETE_RULE",
				"FK_NAME",
				"PK_NAME",
				"DEFERRABILITY");
	}

	@Override
	public ResultSet getCrossReference(String parentCatalog,
			String parentSchema, String parentTable,
			String foreignCatalog, String foreignSchema,
			String foreignTable) throws SQLException {
		logger.finer("getCrossReference");
		return new NullResultSet(
				"PKTABLE_CAT",
				"PKTABLE_SCHEM",
				"PKTABLE_NAME",
				"PKCOLUMN_NAME",
				"FKTABLE_CAT",
				"FKTABLE_SCHEM",
				"FKTABLE_NAME",
				"FKCOLUMN_NAME",
				"KEY_SEQ",
				"UPDATE_RULE",
				"DELETE_RULE",
				"FK_NAME",
				"PK_NAME",
				"DEFERRABILITY");
	}

	@Override
	public ResultSet getTypeInfo() throws SQLException {
		logger.finer("getTypeInfo");
		try {
			return TypeInfoInfo.get();
		} catch (IOException e) {
			throw ErrorBundle.getIODefault(e);
		}
	}

	@Override
	public ResultSet getIndexInfo(String catalog, String schema,
			String table, boolean unique,
			boolean approximate) throws SQLException {
		logger.finer("getIndexInfo");
		return new NullResultSet(
				"TABLE_CAT",
				"TABLE_SCHEM",
				"TABLE_NAME",
				"NON_UNIQUE",
				"INDEX_QUALIFIER",
				"INDEX_NAME",
				"TYPE",
				"ORDINAL_POSITION",
				"COLUMN_NAME",
				"ASC_OR_DESC",
				"CARDINALITY",
				"PAGES",
				"FILTER_CONDITION");
	}

	@Override
	public boolean supportsResultSetType(int type) throws SQLException {
		logger.finer("supportsResultSetType");
		return (type == java.sql.Types.VARCHAR ||
				type == java.sql.Types.NUMERIC ||
				type == java.sql.Types.TIMESTAMP);
	}

	@Override
	public boolean supportsResultSetConcurrency(int type,
			int concurrency) throws SQLException {
		logger.finer("supportsResultSetConcurrency");
		return false;
	}

	@Override
	public boolean ownUpdatesAreVisible(int type) throws SQLException {
		logger.finer("ownUpdatesAreVisible");
		return false;
	}

	@Override
	public boolean ownDeletesAreVisible(int type) throws SQLException {
		logger.finer("ownDeletesAreVisible");
		return false;
	}

	@Override
	public boolean ownInsertsAreVisible(int type) throws SQLException {
		logger.finer("ownInsertsAreVisible");
		return false;
	}

	@Override
	public boolean othersUpdatesAreVisible(int type) throws SQLException {
		logger.finer("othersUpdatesAreVisible");
		return false;
	}

	@Override
	public boolean othersDeletesAreVisible(int type) throws SQLException {
		logger.finer("othersDeletesAreVisible");
		return false;
	}

	@Override
	public boolean othersInsertsAreVisible(int type) throws SQLException {
		logger.finer("othersInsertsAreVisible");
		return false;
	}

	@Override
	public boolean updatesAreDetected(int type) throws SQLException {
		logger.finer("updatesAreDetected");
		return false;
	}

	@Override
	public boolean deletesAreDetected(int type) throws SQLException {
		logger.finer("deletesAreDetected");
		return false;
	}

	@Override
	public boolean insertsAreDetected(int type) throws SQLException {
		logger.finer("insertsAreDetected");
		return false;
	}

	@Override
	public boolean supportsBatchUpdates() throws SQLException {
		logger.finer("supportsBatchUpdates");
		return false;
	}

	@Override
	public ResultSet getUDTs(String catalog, String schemaPattern,
			String typeNamePattern, int[] types) throws SQLException {
		logger.finer("getUDTs");
		return new NullResultSet(
				"TYPE_CAT",
				"TYPE_SCHEM",
				"TYPE_NAME",
				"CLASS_NAME",
				"DATA_TYPE",
				"REMARKS",
				"BASE_TYPE");
	}

	@Override
	public Connection getConnection() throws SQLException {
		logger.finer("getConnection");
		return conn;
	}

	@Override
	public boolean supportsSavepoints() throws SQLException {
		logger.finer("supportsSavepoints");
		return false;
	}

	@Override
	public boolean supportsNamedParameters() throws SQLException {
		logger.finer("supportsNamedParameters");
		return false;
	}

	@Override
	public boolean supportsMultipleOpenResults() throws SQLException {
		logger.finer("supportsMultipleOpenResults");
		return false;
	}

	@Override
	public boolean supportsGetGeneratedKeys() throws SQLException {
		logger.finer("supportsGetGeneratedKeys");
		return false;
	}

	@Override
	public ResultSet getSuperTypes(String catalog,
			String schemaPattern,
			String typeNamePattern) throws SQLException {
		logger.finer("getSuperTypes");
		return new NullResultSet(
				"TYPE_CAT",
				"TYPE_SCHEM",
				"TYPE_NAME",
				"SUPERTYPE_CAT",
				"SUPERTYPE_SCHEM",
				"SUPERTYPE_NAME");
	}

	@Override
	public ResultSet getSuperTables(String catalog,
			String schemaPattern,
			String tableNamePattern) throws SQLException {
		logger.finer("getSuperTables");
		return new NullResultSet(
				"TYPE_CAT",
				"TYPE_SCHEM",
				"TYPE_NAME",
				"SUPERTABLE_NAME");
	}

	@Override
	public ResultSet getAttributes(String catalog,
			String schemaPattern,
			String typeNamePattern, String attributeNamePattern)
			throws SQLException {
		logger.finer("getAttributes");
		return new NullResultSet(
				"TYPE_CAT",
				"TYPE_SCHEM",
				"TYPE_NAME",
				"ATTR_NAME",
				"DATA_TYPE",
				"ATTR_TYPE_NAME",
				"ATTR_SIZE",
				"DECIMAL_DIGITS",
				"NUM_PREC_RADIX",
				"NULLABLE",
				"REMARKS",
				"ATTR_DEF",
				"SQL_DATA_TYPE",
				"SQL_DATETIME_SUB",
				"CHAR_OCTET_LENGTH",
				"ORDINAL_POSITION",
				"IS_NULLABLE",
				"SCOPE_CATALOG",
				"SCOPE_SCHEMA",
				"SCOPE_TABLE",
				"SOURCE_DATA_TYPE");
	}

	@Override
	public boolean supportsResultSetHoldability(
			int holdability) throws SQLException {
		logger.finer("supportsResultSetHoldability");
		return false;
	}

	@Override
	public int getResultSetHoldability() throws SQLException {
		logger.finer("getResultSetHoldability");
		return ResultSet.HOLD_CURSORS_OVER_COMMIT;
	}

	@Override
	public int getDatabaseMajorVersion() throws SQLException {
		logger.finer("getDatabaseMajorVersion");
		return RePlus.MAJOR_VERSION;
	}

	@Override
	public int getDatabaseMinorVersion() throws SQLException {
		logger.finer("getDatabaseMinorVersion");
		return RePlus.MINOR_VERSION;
	}

	@Override
	public int getJDBCMajorVersion() throws SQLException {
		logger.finer("getJDBCMajorVersion");
		return 4;
	}

	@Override
	public int getJDBCMinorVersion() throws SQLException {
		logger.finer("getJDBCMinorVersion");
		return 0;
	}

	@Override
	public int getSQLStateType() throws SQLException {
		logger.finer("getSQLStateType");
		return sqlStateSQL;
	}

	@Override
	public boolean locatorsUpdateCopy() throws SQLException {
		logger.finer("locatorsUpdateCopy");
		return false;
	}

	@Override
	public boolean supportsStatementPooling() throws SQLException {
		logger.finer("supportsStatementPooling");
		return false;
	}

	@Override
	public RowIdLifetime getRowIdLifetime() throws SQLException {
		logger.finer("getRowIdLifetime");
		return RowIdLifetime.ROWID_UNSUPPORTED;
	}

	@Override
	public ResultSet getSchemas(String catalog,
			String schemaPattern) throws SQLException {
		logger.finer("getSchemas");
		return new NullResultSet(
				"TABLE_SCHEM",
				"TABLE_CATALOG");
	}

	@Override
	public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
		logger.finer("supportsStoredFunctionsUsingCallSyntax");
		return false;
	}

	@Override
	public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
		logger.finer("autoCommitFailureClosesAllResultSets");
		return false;
	}

	@Override
	public ResultSet getClientInfoProperties() throws SQLException {
		logger.finer("getClientInfoProperties");
		return new NullResultSet(
				"NAME",
				"MAX_LEN",
				"DEFAULT_VALUE",
				"DESCRIPTION");
	}

	@Override
	public ResultSet getFunctions(String catalog, String schemaPattern,
			String functionNamePattern) throws SQLException {
		// TODO
		logger.finer("getFunctions");
		return new NullResultSet(
				"FUNCTION_CAT",
				"FUNCTION_SCHEM",
				"FUNCTION_NAME",
				"REMARKS",
				"FUNCTION_TYPE",
				"SPECIFIC_NAME");
	}

	@Override
	public ResultSet getFunctionColumns(String catalog,
			String schemaPattern, String functionNamePattern,
			String columnNamePattern) throws SQLException {
		// TODO
		logger.finer("getFunctionColumns");
		return new NullResultSet(
				"FUNCTION_CAT",
				"FUNCTION_SCHEM",
				"FUNCTION_NAME",
				"COLUMN_NAME",
				"COLUMN_TYPE",
				"DATA_TYPE",
				"TYPE_NAME",
				"PRECISION",
				"LENGTH",
				"SCALE",
				"RADIX",
				"NULLABLE",
				"REMARKS",
				"CHAR_OCTET_LENGTH",
				"ORDINAL_POSITION",
				"IS_NULLABLE",
				"SPECIFIC_NAME");
	}

}
