/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.jdbc;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

import net.morilib.db.misc.LoggerRelationsLogger;
import net.morilib.db.misc.RelationsLogger;
import net.morilib.db.misc.RelationsLoggers;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/03
 */
public class RelationsJDBCUtils {

	/**
	 * 
	 */
	public static final RelationsLogger DEFAULT;

	/**
	 * 
	 */
	public static final RelationsLogger DEBUG;

	/**
	 * 
	 */
	public static RelationsLogger logger;

	//
	static {
		RelationsLogger r;
		Logger l;
		Handler h1;

		r = RelationsLoggers.NULL;
		try {
			l = Logger.getLogger("net.morilib.db.jdbc");
			l.setLevel(Level.OFF);
			r = new LoggerRelationsLogger(l);
		} catch(SecurityException e) {
			// ignored
		} finally {
			DEFAULT = r;
		}

		r = RelationsLoggers.NULL;
		try {
			l = Logger.getLogger("net.morilib.db.jdbc");
			h1 = new FileHandler("%h/relations-jdbc%g.log", 1000000, 3);
			h1.setFormatter(new SimpleFormatter());
			l.addHandler(h1);
			l.setLevel(Level.ALL);
			r = new LoggerRelationsLogger(l);
		} catch(SecurityException e) {
			// ignored
		} catch(IOException e) {
			throw new RuntimeException(e);
		} finally {
			DEBUG = r;
			logger = DEFAULT;
		}
	}

}
