/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.misc;

import java.io.PrintWriter;

import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParseException;
import net.morilib.parser.html.HTMLParser;

public abstract class XmlReplaceTag implements HTMLHandler {

	String tag;

	private PrintWriter wr;
	private boolean tagw, tagp;
	private int nest = 0;

	/**
	 * 
	 * @param w
	 */
	public XmlReplaceTag(String tag, PrintWriter w) {
		this.tag = tag;
		wr = w;
	}

	/**
	 * 
	 * @param w
	 */
	public abstract void insertFragment(PrintWriter w);

	private void puttagw() {
		if(tagw) {
			wr.print('>');
			tagw = false;
		}
	}

	@Override
	public void string(String s) throws HTMLParseException {
		puttagw();
		if(nest == 0) {
			wr.print(HTMLParser.escape(s));
		}
	}

	@Override
	public void startTag(String s) throws HTMLParseException {
		puttagw();
		if(nest == 0) {
			wr.format("<%s", HTMLParser.escape(s));
			tagw = true;
		}
		tagp = s.equals(tag) && nest++ == 0;
	}

	@Override
	public void endTag(String s) throws HTMLParseException {
		puttagw();
		if(s.equals(tag) && --nest == 0) {
			insertFragment(wr);
		}

		if(nest == 0) {
			wr.format("</%s>", HTMLParser.escape(s));
		}
	}

	@Override
	public void tagAttribute(String k,
			String v) throws HTMLParseException {
		if(nest == 0 || tagp) {
			wr.format(" %s=\"%s\"",
					HTMLParser.escape(k),
					HTMLParser.escape(v));
		}
	}

	@Override
	public void meta(String s) throws HTMLParseException {
		wr.println(s);
	}

	@Override
	public void comment(String s) throws HTMLParseException {
		wr.format("<!--%s-->", s);
	}

}
