/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java;

import io.remme.java.ClientInit;
import io.remme.java.account.RemmeAccount;
import io.remme.java.api.IRemmeApi;
import io.remme.java.api.RemmeApi;
import io.remme.java.atomicswap.IRemmeSwap;
import io.remme.java.atomicswap.RemmeSwap;
import io.remme.java.blockchaininfo.IRemmeBlockchainInfo;
import io.remme.java.blockchaininfo.RemmeBlockchainInfo;
import io.remme.java.certificate.IRemmeCertificate;
import io.remme.java.certificate.RemmeCertificate;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.publickeystorage.IRemmePublicKeyStorage;
import io.remme.java.publickeystorage.RemmePublicKeyStorage;
import io.remme.java.token.IRemmeToken;
import io.remme.java.token.RemmeToken;
import io.remme.java.transactionservice.IRemmeTransactionService;
import io.remme.java.transactionservice.RemmeTransactionService;
import io.remme.java.websocketevents.IRemmeWebSocketEvents;
import io.remme.java.websocketevents.RemmeWebSocketEvents;
import org.apache.commons.lang3.StringUtils;

public class RemmeClient {
    private IRemmeApi remmeApi;
    private RemmeAccount account;
    private IRemmeTransactionService transaction;
    private IRemmePublicKeyStorage publicKeyStorage;
    private IRemmeCertificate certificate;
    private IRemmeToken token;
    private IRemmeSwap swap;
    private IRemmeBlockchainInfo blockchainInfo;

    public IRemmeWebSocketEvents getEvents() {
        return new RemmeWebSocketEvents(this.remmeApi.getNetworkConfig());
    }

    public RemmeClient(ClientInit clientInit) {
        this.remmeApi = clientInit.getNetworkConfig() != null ? new RemmeApi(clientInit.getNetworkConfig()) : new RemmeApi();
        this.account = StringUtils.isNotEmpty((CharSequence)clientInit.getPrivateKeyHex()) ? new RemmeAccount(clientInit.getPrivateKeyHex()) : new RemmeAccount();
        this.transaction = new RemmeTransactionService(this.remmeApi, this.account);
        this.publicKeyStorage = new RemmePublicKeyStorage(this.remmeApi, this.account, this.transaction);
        this.certificate = new RemmeCertificate(this.publicKeyStorage);
        this.token = new RemmeToken(this.remmeApi, this.transaction);
        this.swap = new RemmeSwap(this.remmeApi, this.transaction);
        this.blockchainInfo = new RemmeBlockchainInfo(this.remmeApi);
    }

    public RemmeClient() {
        this(new ClientInit());
    }

    public void setAccount(RemmeAccount remmeAccount) {
        if (remmeAccount == null) {
            throw new RemmeValidationException("Account is missing in attributes. Please give the account.");
        }
        if (StringUtils.isEmpty((CharSequence)remmeAccount.getPrivateKeyHex()) || StringUtils.isEmpty((CharSequence)remmeAccount.getPublicKeyHex())) {
            throw new RemmeValidationException("Given remmeAccount is not valid");
        }
        this.account = remmeAccount;
    }

    public RemmeAccount getAccount() {
        return this.account;
    }

    public static RemmeAccount generateAccount() {
        return new RemmeAccount();
    }

    public IRemmeApi getRemmeApi() {
        return this.remmeApi;
    }

    public IRemmeTransactionService getTransaction() {
        return this.transaction;
    }

    public IRemmePublicKeyStorage getPublicKeyStorage() {
        return this.publicKeyStorage;
    }

    public IRemmeCertificate getCertificate() {
        return this.certificate;
    }

    public IRemmeToken getToken() {
        return this.token;
    }

    public IRemmeSwap getSwap() {
        return this.swap;
    }

    public IRemmeBlockchainInfo getBlockchainInfo() {
        return this.blockchainInfo;
    }
}

