/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.certificate;

import io.remme.java.certificate.IRemmeCertificate;
import io.remme.java.certificate.dto.CertificateTransactionResponse;
import io.remme.java.certificate.dto.CreateCertificateDTO;
import io.remme.java.certificate.dto.ICertificateTransactionResponse;
import io.remme.java.enums.KeyType;
import io.remme.java.enums.RSASignaturePadding;
import io.remme.java.enums.SubjectField;
import io.remme.java.error.RemmeKeyException;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.keys.RSA;
import io.remme.java.keys.RemmeKeys;
import io.remme.java.keys.dto.GenerateOptions;
import io.remme.java.publickeystorage.IRemmePublicKeyStorage;
import io.remme.java.publickeystorage.dto.PublicKeyCreate;
import io.remme.java.publickeystorage.dto.PublicKeyInfo;
import io.remme.java.transactionservice.BaseTransactionResponse;
import io.remme.java.utils.Certificate;
import io.remme.java.utils.Functions;
import io.remme.java.utils.RemmeExecutorService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.concurrent.Future;
import org.apache.commons.beanutils.PropertyUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class RemmeCertificate
implements IRemmeCertificate {
    private IRemmePublicKeyStorage remmePublicKeyStorage;
    private static final Integer RSA_KEY_SIZE = 2048;

    private X500Name createSubject(CreateCertificateDTO dto) {
        try {
            Field[] fields;
            if (dto.getCommonName() == null || dto.getCommonName().isEmpty()) {
                throw new RemmeValidationException("Attribute commonName must have a value");
            }
            if (dto.getValidity() == null) {
                throw new RemmeValidationException("Attribute validity must have a value");
            }
            X500NameBuilder builder = new X500NameBuilder();
            for (Field field : fields = dto.getClass().getDeclaredFields()) {
                SubjectField subjectField = SubjectField.getByFieldName(field.getName());
                Object value = PropertyUtils.getProperty((Object)dto, (String)field.getName());
                if (subjectField == null || value == null) continue;
                builder.addRDN(subjectField.getRdn(), (String)value);
            }
            return builder.build();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Certificate createCertificate(KeyPair keyPair, CreateCertificateDTO certificateDataToCreate) {
        try {
            X500Name subject = this.createSubject(certificateDataToCreate);
            Calendar notBefore = Calendar.getInstance();
            Calendar notAfter = Calendar.getInstance();
            if (certificateDataToCreate.getValidAfter() != null) {
                notBefore.add(10, 24 * certificateDataToCreate.getValidAfter());
            }
            notAfter.setTime(notBefore.getTime());
            notAfter.add(10, certificateDataToCreate.getValidity());
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(subject, BigInteger.valueOf(System.currentTimeMillis()), notBefore.getTime(), notAfter.getTime(), subject, keyPair.getPublic());
            ContentSigner sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(keyPair.getPrivate());
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(builder.build(sigGen));
            return Certificate.builder().cert(cert).privateKey(keyPair.getPrivate()).build();
        }
        catch (CertificateException | OperatorCreationException e) {
            throw new RemmeKeyException(e);
        }
    }

    public RemmeCertificate(IRemmePublicKeyStorage remmePublicKeyStorage) {
        this.remmePublicKeyStorage = remmePublicKeyStorage;
    }

    @Override
    public Future<Certificate> create(CreateCertificateDTO certificateDataToCreate) {
        return RemmeExecutorService.getInstance().submit(() -> {
            KeyPair keys = RSA.generateKeyPair(GenerateOptions.builder().rsaKeySize(RSA_KEY_SIZE).build());
            return this.createCertificate(keys, certificateDataToCreate);
        });
    }

    @Override
    public Future<ICertificateTransactionResponse> createAndStore(CreateCertificateDTO certificateDataToCreate) {
        return RemmeExecutorService.getInstance().submit(() -> {
            Certificate certificate = this.create(certificateDataToCreate).get();
            return this.store(certificate).get();
        });
    }

    @Override
    public Future<ICertificateTransactionResponse> store(Certificate certificate) {
        if (certificate.getPrivateKey() == null) {
            throw new RemmeValidationException("Your certificate does not have private key");
        }
        return RemmeExecutorService.getInstance().submit(() -> {
            String certificatePEM = Functions.certificateToPEM(certificate, false);
            int validFrom = (int)Math.floor((double)certificate.getNotBefore().getTime() / 1000.0);
            int validTo = (int)Math.floor((double)certificate.getNotAfter().getTime() / 1000.0);
            BaseTransactionResponse batchResponse = this.remmePublicKeyStorage.createAndStore(PublicKeyCreate.builder().data(certificatePEM).keys(new RSA(certificate.getPublicKey(), certificate.getPrivateKey())).rsaSignaturePadding(RSASignaturePadding.PSS).validFrom(validFrom).validTo(validTo).build()).get();
            return new CertificateTransactionResponse(batchResponse.getNetworkConfig(), batchResponse.getBatchId(), certificate);
        });
    }

    @Override
    public Future<Boolean> check(Certificate certificate) {
        return RemmeExecutorService.getInstance().submit(() -> {
            try {
                String address = RemmeKeys.getAddressFromPublicKey(KeyType.RSA, certificate.getPublicKey());
                return this.remmePublicKeyStorage.check(address).get();
            }
            catch (Exception e) {
                throw new RemmeValidationException("This certificate was not found");
            }
        });
    }

    @Override
    public Future<PublicKeyInfo> getInfo(Certificate certificate) {
        return RemmeExecutorService.getInstance().submit(() -> {
            try {
                String address = RemmeKeys.getAddressFromPublicKey(KeyType.RSA, certificate.getPublicKey());
                return this.remmePublicKeyStorage.getInfo(address).get();
            }
            catch (Exception e) {
                throw new RemmeValidationException("This certificate was not found");
            }
        });
    }

    @Override
    public Future<BaseTransactionResponse> revoke(Certificate certificate) {
        String address = RemmeKeys.getAddressFromPublicKey(KeyType.RSA, certificate.getPublicKey());
        return this.remmePublicKeyStorage.revoke(address);
    }

    @Override
    public String sign(Certificate certificate, String data, RSASignaturePadding padding) {
        if (certificate.getPrivateKey() == null) {
            throw new RemmeValidationException("Your certificate does not have private key");
        }
        RSA keys = new RSA(null, certificate.getPrivateKey());
        if (padding == null) {
            return keys.sign(data);
        }
        return keys.sign(data, padding);
    }

    @Override
    public boolean verify(Certificate certificate, String data, String signature, RSASignaturePadding rsaSignaturePadding) {
        RSA keys = new RSA(certificate.getPublicKey(), null);
        if (rsaSignaturePadding != null) {
            return keys.verify(data, signature, rsaSignaturePadding);
        }
        return keys.verify(data, signature);
    }

    @Override
    public Future<ICertificateTransactionResponse> store(String certificatePem) {
        return this.store(Functions.certificateFromPEM(certificatePem));
    }

    @Override
    public Future<Boolean> check(String certificatePem) {
        return this.check(Functions.certificateFromPEM(certificatePem));
    }

    @Override
    public Future<PublicKeyInfo> getInfo(String certificatePem) {
        return this.getInfo(Functions.certificateFromPEM(certificatePem));
    }

    @Override
    public Future<BaseTransactionResponse> revoke(String certificatePem) {
        return this.revoke(Functions.certificateFromPEM(certificatePem));
    }

    @Override
    public String sign(String certificatePem, String data, RSASignaturePadding rsaSignaturePadding) {
        return this.sign(Functions.certificateFromPEM(certificatePem), data, rsaSignaturePadding);
    }

    @Override
    public boolean verify(String certificatePem, String data, String signatureData, RSASignaturePadding rsaSignaturePadding) {
        return this.verify(Functions.certificateFromPEM(certificatePem), data, signatureData, rsaSignaturePadding);
    }
}

