/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.publickeystorage;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import io.remme.java.account.RemmeAccount;
import io.remme.java.api.IRemmeApi;
import io.remme.java.enums.KeyType;
import io.remme.java.enums.RSASignaturePadding;
import io.remme.java.enums.RemmeFamilyName;
import io.remme.java.enums.RemmeMethod;
import io.remme.java.error.RemmeKeyException;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.keys.IRemmeKeys;
import io.remme.java.keys.RemmeKeys;
import io.remme.java.protobuf.PubKey;
import io.remme.java.protobuf.Transaction;
import io.remme.java.publickeystorage.IRemmePublicKeyStorage;
import io.remme.java.publickeystorage.dto.PublicKeyCreate;
import io.remme.java.publickeystorage.dto.PublicKeyInfo;
import io.remme.java.transactionservice.BaseTransactionResponse;
import io.remme.java.transactionservice.IRemmeTransactionService;
import io.remme.java.transactionservice.dto.CreateTransactionDto;
import io.remme.java.utils.Functions;
import io.remme.java.utils.RemmeExecutorService;
import io.remme.java.utils.models.PublicKeyRequest;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class RemmePublicKeyStorage
implements IRemmePublicKeyStorage {
    private IRemmeApi remmeApi;
    private RemmeAccount remmeAccount;
    private IRemmeTransactionService remmeTransaction;
    private RemmeFamilyName familyName = RemmeFamilyName.PUBLIC_KEY;
    private String familyVersion = "0.1";
    private String zeroAddress = StringUtils.repeat((String)"0", (int)70);
    private String settingAddress = Functions.generateSettingsAddress("remme.economy_enabled");

    private byte[] generateTransactionPayload(int method, ByteString data) {
        return Transaction.TransactionPayload.newBuilder().setMethod(method).setData(data).build().toByteArray();
    }

    private Future<BaseTransactionResponse> createAndSendTransaction(String[] inputs, String[] outputs, byte[] payloadBytes) {
        try {
            Future<String> transaction = this.remmeTransaction.create(CreateTransactionDto.builder().familyName(this.familyName.getName()).familyVersion(this.familyVersion).inputs(inputs).outputs(outputs).payloadBytes(payloadBytes).build());
            return this.remmeTransaction.send(transaction.get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Future<PublicKeyInfo> getInfoByPublicKey(String address) {
        ExecutorService es = RemmeExecutorService.getInstance();
        return es.submit(() -> {
            try {
                Functions.checkAddress(address);
                PublicKeyRequest payload = new PublicKeyRequest(address);
                PublicKeyInfo info = this.remmeApi.sendRequest(RemmeMethod.PUBLIC_KEY, payload, PublicKeyInfo.class).get();
                if (info != null) {
                    info.setAddress(Functions.generateAddress(this.familyName.getName(), address));
                    return info;
                }
                throw new RemmeKeyException("This public key was not found");
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Future<String> constructAddressFromPayload(PubKey.NewPubKeyPayload payload) {
        ExecutorService es = RemmeExecutorService.getInstance();
        return es.submit(() -> {
            Functions.checkSha(payload.getEntityHash().toStringUtf8());
            KeyType keyType = KeyType.getByType(payload.getConfigurationCase().name());
            PublicKey publicKey = null;
            switch (keyType) {
                case RSA: {
                    publicKey = Functions.getPublicKeyFromBytesArray(KeyType.RSA, payload.getRsa().getKey().toByteArray());
                    break;
                }
                case ECDSA: {
                    publicKey = Functions.getPublicKeyFromBytesArray(KeyType.ECDSA, payload.getEcdsa().getKey().toByteArray());
                    break;
                }
                case EdDSA: {
                    publicKey = Functions.getPublicKeyFromBytesArray(KeyType.EdDSA, payload.getEd25519().getKey().toByteArray());
                }
            }
            IRemmeKeys keys = RemmeKeys.construct(keyType, publicKey, null);
            if (!keys.verify(Hex.encodeHexString((byte[])payload.getEntityHashSignature().toByteArray()), payload.getEntityHash().toByteArray())) {
                throw new RemmeValidationException("Signature not valid");
            }
            return keys.getAddress();
        });
    }

    private void verifyPayloadOwner(byte[] ownerPublicKey, byte[] signatureByOwner, PubKey.NewPubKeyPayload pubKeyPayload) {
        IRemmeKeys accountKey = RemmeKeys.construct(KeyType.ECDSA, Functions.getECDSAPublicKeyFromBytes(ownerPublicKey), null);
        PubKey.NewPubKeyPayload payload = PubKey.NewPubKeyPayload.newBuilder(pubKeyPayload).build();
        if (!accountKey.verify(Hex.encodeHexString((byte[])signatureByOwner), payload.toByteArray())) {
            throw new RemmeValidationException("Owner signature not valid");
        }
    }

    public RemmePublicKeyStorage(IRemmeApi remmeApi, RemmeAccount remmeAccount, IRemmeTransactionService remmeTransaction) {
        this.remmeApi = remmeApi;
        this.remmeAccount = remmeAccount;
        this.remmeTransaction = remmeTransaction;
    }

    @Override
    public byte[] create(PublicKeyCreate data) {
        try {
            if (data.getSignature() != null) {
                Functions.checkSha(data.getData());
                if (!data.getKeys().verify(data.getData(), data.getSignature())) {
                    throw new RemmeValidationException("Signature not valid");
                }
            }
            RSASignaturePadding padding = data.getRsaSignaturePadding() != null ? data.getRsaSignaturePadding() : RSASignaturePadding.EMPTY;
            String message = data.getSignature() != null ? data.getData() : DigestUtils.sha512Hex((String)data.getData());
            byte[] entityHash = message.getBytes(StandardCharsets.UTF_8);
            byte[] entityHashSignature = Hex.decodeHex((String)(data.getSignature() != null ? data.getSignature() : data.getKeys().sign(message, padding)));
            PubKey.NewPubKeyPayload.Builder payload = PubKey.NewPubKeyPayload.newBuilder().setEntityHash(ByteString.copyFrom((byte[])entityHash)).setEntityHashSignature(ByteString.copyFrom((byte[])entityHashSignature)).setValidFrom(data.getValidFrom()).setHashingAlgorithm(PubKey.NewPubKeyPayload.HashingAlgorithm.SHA256).setValidTo(data.getValidTo());
            switch (KeyType.getByType(data.getKeys().getKeyType())) {
                case RSA: {
                    payload.setRsa(PubKey.NewPubKeyPayload.RSAConfiguration.newBuilder().setKey(ByteString.copyFrom((byte[])data.getKeys().getPublicKey().getEncoded())).setPadding((padding.equals((Object)RSASignaturePadding.EMPTY) ? RSASignaturePadding.PSS : padding).getProtoValue()).build());
                    break;
                }
                case ECDSA: {
                    payload.setEcdsa(PubKey.NewPubKeyPayload.ECDSAConfiguration.newBuilder().setKey(ByteString.copyFrom((byte[])Functions.hexToBytes(data.getKeys().getPublicKeyHex()))).setEc(PubKey.NewPubKeyPayload.ECDSAConfiguration.EC.SECP256k1).build());
                    break;
                }
                case EdDSA: {
                    payload.setEd25519(PubKey.NewPubKeyPayload.Ed25519Configuration.newBuilder().setKey(ByteString.copyFrom((byte[])data.getKeys().getPublicKey().getEncoded())).build());
                }
            }
            if (data.getDoOwnerPay().booleanValue()) {
                return payload.build().toByteArray();
            }
            String signatureByOwnerHex = this.remmeAccount.sign(payload.build().toByteArray());
            return PubKey.NewPubKeyStoreAndPayPayload.newBuilder().setPubKeyPayload(payload.build()).setOwnerPublicKey(ByteString.copyFrom((byte[])Functions.hexToBytes(this.remmeAccount.getPrivateKeyHex()))).setSignatureByOwner(ByteString.copyFrom((byte[])Functions.hexToBytes(signatureByOwnerHex))).build().toByteArray();
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<BaseTransactionResponse> store(byte[] data) {
        try {
            String pubKeyAddress;
            PubKey.NewPubKeyPayload message;
            String ownerAddress = null;
            PubKey.NewPubKeyStoreAndPayPayload ownerPayload = PubKey.NewPubKeyStoreAndPayPayload.parseFrom(data);
            GeneratedMessageV3 generatedMessageV3 = message = ownerPayload.getPubKeyPayload().getEntityHash() == null || ownerPayload.getPubKeyPayload().getEntityHash().isEmpty() ? PubKey.NewPubKeyPayload.parseFrom(data) : ownerPayload;
            if (message instanceof PubKey.NewPubKeyPayload) {
                pubKeyAddress = this.constructAddressFromPayload(message).get();
            } else if (message instanceof PubKey.NewPubKeyStoreAndPayPayload) {
                this.verifyPayloadOwner(((PubKey.NewPubKeyStoreAndPayPayload)((Object)message)).getOwnerPublicKey().toByteArray(), ((PubKey.NewPubKeyStoreAndPayPayload)((Object)message)).getSignatureByOwner().toByteArray(), ((PubKey.NewPubKeyStoreAndPayPayload)((Object)message)).getPubKeyPayload());
                pubKeyAddress = this.constructAddressFromPayload(((PubKey.NewPubKeyStoreAndPayPayload)((Object)message)).getPubKeyPayload()).get();
                ownerAddress = Functions.generateAddress(RemmeFamilyName.ACCOUNT.getName(), Hex.encodeHexString((byte[])((PubKey.NewPubKeyStoreAndPayPayload)((Object)message)).getOwnerPublicKey().toByteArray()));
            } else {
                throw new RemmeValidationException("Invalid payload");
            }
            String[] inputsOutputs = new String[]{pubKeyAddress, this.zeroAddress, this.settingAddress};
            if (ownerAddress != null) {
                inputsOutputs = new String[]{pubKeyAddress, this.zeroAddress, this.settingAddress, ownerAddress};
            }
            byte[] payloadBytes = this.generateTransactionPayload(ownerAddress != null ? PubKey.PubKeyMethod.Method.STORE_AND_PAY.getNumber() : PubKey.PubKeyMethod.Method.STORE.getNumber(), ByteString.copyFrom((byte[])data));
            return this.createAndSendTransaction(inputsOutputs, inputsOutputs, payloadBytes);
        }
        catch (InvalidProtocolBufferException | InterruptedException | ExecutionException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public Future<BaseTransactionResponse> createAndStore(PublicKeyCreate data) {
        byte[] payloadBytes = this.create(data);
        return this.store(payloadBytes);
    }

    @Override
    public Future<Boolean> check(String address) {
        ExecutorService es = RemmeExecutorService.getInstance();
        return es.submit(() -> this.getInfoByPublicKey(address).get().getIsValid());
    }

    @Override
    public Future<PublicKeyInfo> getInfo(String address) {
        return this.getInfoByPublicKey(address);
    }

    @Override
    public Future<BaseTransactionResponse> revoke(String address) {
        Functions.checkAddress(address);
        PubKey.RevokePubKeyPayload revokePayload = PubKey.RevokePubKeyPayload.newBuilder().setAddress(address).build();
        byte[] payloadBytes = this.generateTransactionPayload(PubKey.PubKeyMethod.Method.REVOKE.getNumber(), revokePayload.toByteString());
        return this.createAndSendTransaction(new String[]{address}, new String[]{address}, payloadBytes);
    }

    @Override
    public Future<String[]> getAccountPublicKeys(String address) {
        Functions.checkAddress(address);
        PublicKeyRequest payload = new PublicKeyRequest(address);
        return this.remmeApi.sendRequest(RemmeMethod.USER_PUBLIC_KEYS, payload, String[].class);
    }

    public void setFamilyVersion(String familyVersion) {
        this.familyVersion = familyVersion;
    }

    public String getFamilyVersion() {
        return this.familyVersion;
    }
}

