/*
 * Decompiled with CFR 0.152.
 */
package io.remme.java.websocket.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.remme.java.enums.Patterns;
import io.remme.java.error.RemmeValidationException;
import io.remme.java.websocket.enums.RemmeEvents;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RemmeRequestParams {
    @JsonProperty(value="event_type")
    private RemmeEvents events;
    private String id;
    @JsonProperty(value="from_block")
    private String lastKnownBlockId;
    private String address;

    public void setId(String id) {
        this.id = id;
        if (this.events != null) {
            this.validateId();
        }
    }

    public void setEvents(RemmeEvents events) {
        this.events = events;
        this.validateId();
        this.validateAddress();
    }

    public void setAddress(String address) {
        this.address = address;
        if (this.events != null) {
            this.validateAddress();
        }
    }

    public void setLastKnownBlockId(String lastKnownBlockId) {
        if (lastKnownBlockId != null && !lastKnownBlockId.matches(Patterns.HEADER_SIGNATURE.getPattern())) {
            throw new RemmeValidationException("'lastKnownBlockId' is not correct");
        }
        this.lastKnownBlockId = lastKnownBlockId;
    }

    private void validateId() {
        if (this.id != null && (RemmeEvents.BATCH.equals((Object)this.events) || RemmeEvents.ATOMIC_SWAP.equals((Object)this.events)) && !this.id.matches(Patterns.HEADER_SIGNATURE.getPattern())) {
            throw new RemmeValidationException("'id' is not correct");
        }
    }

    private void validateAddress() {
        if (this.address != null && !this.address.matches(Patterns.ADDRESS.getPattern())) {
            throw new RemmeValidationException("'address' is not correct");
        }
    }

    public static RemmeRequestParamsBuilder builder() {
        return new RemmeRequestParamsBuilder();
    }

    public RemmeEvents getEvents() {
        return this.events;
    }

    public String getId() {
        return this.id;
    }

    public String getLastKnownBlockId() {
        return this.lastKnownBlockId;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemmeRequestParams)) {
            return false;
        }
        RemmeRequestParams other = (RemmeRequestParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RemmeEvents this$events = this.getEvents();
        RemmeEvents other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)((Object)this$events)).equals((Object)other$events)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lastKnownBlockId = this.getLastKnownBlockId();
        String other$lastKnownBlockId = other.getLastKnownBlockId();
        if (this$lastKnownBlockId == null ? other$lastKnownBlockId != null : !this$lastKnownBlockId.equals(other$lastKnownBlockId)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemmeRequestParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RemmeEvents $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)((Object)$events)).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lastKnownBlockId = this.getLastKnownBlockId();
        result = result * 59 + ($lastKnownBlockId == null ? 43 : $lastKnownBlockId.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    public String toString() {
        return "RemmeRequestParams(events=" + (Object)((Object)this.getEvents()) + ", id=" + this.getId() + ", lastKnownBlockId=" + this.getLastKnownBlockId() + ", address=" + this.getAddress() + ")";
    }

    public RemmeRequestParams(RemmeEvents events, String id, String lastKnownBlockId, String address) {
        this.events = events;
        this.id = id;
        this.lastKnownBlockId = lastKnownBlockId;
        this.address = address;
    }

    public RemmeRequestParams() {
    }

    public static class RemmeRequestParamsBuilder {
        private RemmeEvents events;
        private String id;
        private String lastKnownBlockId;
        private String address;

        RemmeRequestParamsBuilder() {
        }

        public RemmeRequestParamsBuilder events(RemmeEvents events) {
            this.events = events;
            return this;
        }

        public RemmeRequestParamsBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RemmeRequestParamsBuilder lastKnownBlockId(String lastKnownBlockId) {
            this.lastKnownBlockId = lastKnownBlockId;
            return this;
        }

        public RemmeRequestParamsBuilder address(String address) {
            this.address = address;
            return this;
        }

        public RemmeRequestParams build() {
            return new RemmeRequestParams(this.events, this.id, this.lastKnownBlockId, this.address);
        }

        public String toString() {
            return "RemmeRequestParams.RemmeRequestParamsBuilder(events=" + (Object)((Object)this.events) + ", id=" + this.id + ", lastKnownBlockId=" + this.lastKnownBlockId + ", address=" + this.address + ")";
        }
    }
}

