/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageProducer;
import java.net.InetAddress;
import java.net.URL;
import rescue.Pool;
import sun.audio.AudioPlayer;
import viewer.DoubleFormat;
import viewer.agentListFrame;
import viewer.building;
import viewer.buildingMap;
import viewer.configFrame;
import viewer.demoFrame;
import viewer.imageCanvas;
import viewer.logPool;
import viewer.mapCanvas;
import viewer.road;
import viewer.sizedPanel;
import viewer.statFrame;
import viewer.viewerFrame;
import viewer.windowGeometry;

public class Map
extends Applet
implements Runnable {
    static String lfile;
    static String bfile;
    static String nfile;
    static String rfile;
    static String bfileDefault;
    static String nfileDefault;
    static String rfileDefault;
    static String[] soundFile;
    buildingMap bm;
    Image logo;
    logPool lp;
    Thread t;
    public static int timeLimit;
    MediaTracker tracker = new MediaTracker(this);
    private static boolean isApplet;
    private static boolean isOnline;
    static boolean verbose;
    static boolean sound;
    static boolean extendedMode;
    private static InetAddress _host;
    private static int _port;
    private static final int maxSf = 3;
    private static boolean showDemo;
    private static boolean showStat;
    public static final int langEn = 0;
    public static final int langJp = 1;
    public static int lang;
    private statFrame[] sf;
    private demoFrame df = null;
    private agentListFrame alf = null;
    private static int mousePosX;
    private static int mousePosY;
    public static int unitBuildingValue;
    public static int unitRoadValue;
    private configFrame cf = null;
    private final String version = " logViewer 1.5.2 (2002/05/03)";
    private final String copyright = " Copyright(C) 2000-2002 by Y.Kuwata; kuwatay@nttdata.co.jp";
    public static final int EXTEND_MODE_INIT = 0;
    public static final int EXTEND_MODE_SEND = 1;
    public static final int EXTEND_MODE_RECEIVE = 2;
    static int extendMode;
    int polyid;
    Button time_inc;
    Button config;
    Label label1;
    Scrollbar horizontalScrollbar1;
    mapCanvas mapCanvas1;
    Scrollbar verticalScrollbar1;
    Button zoomin;
    Button zoomout;
    TextField displayScale;
    TextField infoText;
    TextField infoText2;
    TextField infoText3;
    Label label2;
    Button statButton;
    Button demoButton;
    Button agentListButton;
    Choice choice1;
    static windowGeometry wg;
    static windowGeometry dwg;
    static windowGeometry swg;
    static windowGeometry alwg;

    public void init() {
        URL uRL = null;
        if (isApplet) {
            uRL = this.getDocumentBase();
        }
        this.sf = new statFrame[3];
        int n = 0;
        while (n < 3) {
            this.sf[n] = null;
            ++n;
        }
        try {
            this.logo = this.createImage((ImageProducer)this.getClass().getResource("icon/logo.gif").getContent());
            this.tracker.addImage(this.logo, 1);
        }
        catch (Exception exception) {
            System.err.println("Cannot load Rescur logo");
        }
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(0xFFFFFF));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 1, 1));
        this.add("North", panel);
        imageCanvas imageCanvas2 = new imageCanvas(this.logo);
        imageCanvas2.resize(50, 50);
        panel.add(imageCanvas2);
        this.label1 = new Label("RoboCup-Rescue LogViewer  ", 1);
        this.label1.setFont(new Font("Helvetica", 3, 18));
        this.label1.setForeground(new Color(0x404040));
        panel.add(this.label1);
        this.config = new Button();
        this.config.setLabel("Config");
        sizedPanel sizedPanel2 = new sizedPanel(this.config, 40, 30);
        panel.add(sizedPanel2);
        this.choice1 = new Choice();
        sizedPanel sizedPanel3 = new sizedPanel(this.choice1, 160, 30);
        panel.add(sizedPanel3);
        this.zoomin = new Button();
        this.zoomin.setLabel("<<++");
        sizedPanel sizedPanel4 = new sizedPanel(this.zoomin, 40, 30);
        panel.add(sizedPanel4);
        this.displayScale = new TextField();
        this.displayScale.setFont(new Font("Helvetica", 0, 12));
        this.displayScale.setText("X1 ");
        sizedPanel sizedPanel5 = new sizedPanel(this.displayScale, 40, 30);
        panel.add(sizedPanel5);
        this.zoomout = new Button();
        this.zoomout.setLabel("-->>");
        sizedPanel sizedPanel6 = new sizedPanel(this.zoomout, 40, 30);
        panel.add(sizedPanel6);
        this.statButton = new Button();
        this.statButton.setLabel("STAT");
        sizedPanel sizedPanel7 = new sizedPanel(this.statButton, 40, 30);
        panel.add(sizedPanel7);
        this.demoButton = new Button();
        this.demoButton.setLabel("DEMO");
        sizedPanel sizedPanel8 = new sizedPanel(this.demoButton, 40, 30);
        panel.add(sizedPanel8);
        this.agentListButton = new Button();
        this.agentListButton.setLabel("AGNT");
        sizedPanel sizedPanel9 = new sizedPanel(this.agentListButton, 40, 30);
        panel.add(sizedPanel9);
        this.time_inc = new Button();
        if (isOnline) {
            this.time_inc.setLabel("ONLINE");
            this.time_inc.setBackground(Color.green);
        } else {
            this.time_inc.setLabel("STOP");
        }
        sizedPanel sizedPanel10 = new sizedPanel(this.time_inc, 40, 30);
        panel.add(sizedPanel10);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        this.add("South", panel2);
        Panel panel3 = new Panel();
        panel2.add("West", panel3);
        this.label2 = new Label("Information");
        this.label2.setFont(new Font("Helvetica", 0, 12));
        panel3.add(this.label2);
        Panel panel4 = new Panel();
        panel2.add("Center", panel4);
        panel4.setLayout(new BorderLayout());
        this.infoText = new TextField();
        this.infoText.setText("Welcome to  logViewer 1.5.2 (2002/05/03) by the RoboCup-Rescue Project");
        this.infoText.setFont(new Font("Helvetica", 0, 12));
        this.infoText.setBackground(new Color(0xFFFFFF));
        panel4.add("North", this.infoText);
        this.infoText3 = new TextField();
        this.infoText3.setText(" Copyright(C) 2000-2002 by Y.Kuwata; kuwatay@nttdata.co.jp");
        this.infoText3.setFont(new Font("Helvetica", 0, 12));
        this.infoText3.setBackground(new Color(0xFFFFFF));
        panel4.add("South", this.infoText3);
        Panel panel5 = new Panel();
        panel2.add("East", panel5);
        this.infoText2 = new TextField();
        this.infoText2.setText("TIME =  0  ");
        this.infoText2.setFont(new Font("Helvetica", 0, 12));
        this.infoText2.setBackground(new Color(0xFFFFFF));
        sizedPanel sizedPanel11 = new sizedPanel(this.infoText2, 100, 30);
        panel5.add(sizedPanel11);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout());
        this.add("Center", panel6);
        this.horizontalScrollbar1 = new Scrollbar(0, 0, 1, 0, 1);
        panel6.add("South", this.horizontalScrollbar1);
        this.verticalScrollbar1 = new Scrollbar(1, 0, 1, 0, 1);
        panel6.add("East", this.verticalScrollbar1);
        this.mapCanvas1 = new mapCanvas();
        this.mapCanvas1.setForeground(new Color(0));
        this.mapCanvas1.setBackground(new Color(0xFFFFFF));
        panel6.add("Center", this.mapCanvas1);
        if (isApplet) {
            bfile = this.getParameter("building");
            nfile = this.getParameter("node");
            rfile = this.getParameter("road");
            lfile = this.getParameter("log");
            try {
                unitBuildingValue = Integer.parseInt(this.getParameter("ubv"));
            }
            catch (Exception exception) {
                unitBuildingValue = 1;
            }
            try {
                unitRoadValue = Integer.parseInt(this.getParameter("urv"));
            }
            catch (Exception exception) {
                unitRoadValue = 1;
            }
            verbose = this.getParameter("verbose").equals("true");
            try {
                lang = Map.parseLang(this.getParameter("lang"));
            }
            catch (Exception exception) {
                lang = 0;
            }
            showDemo = this.getParameter("demo").equals("true");
            showStat = this.getParameter("stat").equals("true");
        }
        if (verbose) {
            if (isApplet) {
                System.out.println("Applet \"logViewer\" Started");
            } else if (extendedMode) {
                System.out.println("Application \"logViewer\" Started with extended mode");
            } else {
                System.out.println("Application \"logViewer\" Started with normal mode");
            }
            if (isOnline) {
                System.err.println("** ONLINE MODE**");
                System.err.println("Host = " + _host);
                System.err.println("Port = " + _port);
            } else {
                System.err.println("** OFFLINE MODE**");
                System.err.println("Logfile = " + lfile);
            }
            System.err.println("Unit Building Value = " + unitBuildingValue);
            System.err.println("Unit Road value = " + unitRoadValue);
        }
        this.bm = new buildingMap(uRL, this, this.tracker);
        int n2 = 0;
        while (n2 < this.bm.ums.length) {
            this.choice1.addItem(this.bm.ums[n2].name);
            ++n2;
        }
        try {
            this.choice1.select(this.bm.cumn);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.bm.loadBuilding(bfile);
        this.bm.loadNode(nfile);
        this.bm.loadRoad(rfile);
        this.bm.adjustRatio(this.mapCanvas1);
        if (isOnline) {
            if (verbose) {
                System.err.println("Trying to connect .. " + _host + " at " + _port);
            }
            try {
                this.lp = new logPool(_host, _port, this.bm, extendedMode);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.lp == null) {
                System.err.println("Can't connect server");
            }
            this.lp.getPacket();
        } else {
            if (isApplet) {
                if (verbose) {
                    System.err.println("Applet mode");
                }
                this.lp = new logPool(uRL, lfile, this.bm);
            } else {
                this.lp = new logPool(lfile, this.bm);
            }
            if (this.lp == null) {
                System.err.println("Can't load logfile");
            }
            this.lp.loadHeader();
            this.lp.loadUpdate();
        }
        this.lp.attachObject(this.bm);
        this.bm.attachObject(this.lp);
        this.mapCanvas1.attach(this.bm);
        this.t = null;
        SymAdjustment symAdjustment = new SymAdjustment();
        this.verticalScrollbar1.addAdjustmentListener(symAdjustment);
        this.horizontalScrollbar1.addAdjustmentListener(symAdjustment);
        SymMouse symMouse = new SymMouse();
        this.verticalScrollbar1.addMouseListener(symMouse);
        this.mapCanvas1.addMouseListener(symMouse);
        SymMouseMotion symMouseMotion = new SymMouseMotion();
        this.mapCanvas1.addMouseMotionListener(symMouseMotion);
        this.zoomin.addMouseListener(symMouse);
        this.zoomout.addMouseListener(symMouse);
        this.time_inc.addMouseListener(symMouse);
        this.statButton.addMouseListener(symMouse);
        this.demoButton.addMouseListener(symMouse);
        this.agentListButton.addMouseListener(symMouse);
        this.config.addMouseListener(symMouse);
        SymItem symItem = new SymItem();
        this.choice1.addItemListener(symItem);
    }

    public void validate() {
        if (this.bm != null && this.bm.adjustRatio(this.mapCanvas1)) {
            this.bm.changed = true;
            this.mapCanvas1.update();
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.bm != null && this.bm.adjustRatio(this.mapCanvas1)) {
            this.bm.changed = true;
            this.mapCanvas1.update();
        }
    }

    public void start() {
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
            this.soundEffect(4);
        }
    }

    public void stop() {
        if (this.t != null) {
            this.t.stop();
            this.t = null;
            this.soundEffect(4);
        }
    }

    public void restart() {
        if (isOnline) {
            System.err.println("Restart in online mode is not supported");
        } else {
            System.err.println("System Restart");
            this.lp = isApplet ? new logPool(this.getDocumentBase(), lfile, this.bm) : new logPool(lfile, this.bm);
            if (this.lp == null) {
                System.err.println("Can't load logfile");
                return;
            }
            this.lp.loadHeader();
            this.lp.loadUpdate();
            this.lp.attachObject(this.bm);
            this.bm.attachObject(this.lp);
            this.setScrollbar();
            this.mapCanvas1.attach(this.bm);
            this.t = null;
            this.doStart();
        }
    }

    public void soundEffect(int n) {
        if (sound) {
            try {
                AudioPlayer.player.start(this.getClass().getResourceAsStream(soundFile[n]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        try {
            this.tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("icon load error");
            return;
        }
        if (showDemo) {
            this.doDemoShow();
        }
        if (showStat) {
            this.doStatShow();
        }
        while (this.t != null) {
            int n = -1;
            if (isOnline) {
                n = this.lp.getPacket();
                this.bm.changed = true;
                this.bm.focus(this.displayScale);
                this.mapCanvas1.update();
                this.setScrollbar();
                int n2 = 0;
                while (n2 < 3) {
                    if (this.sf[n2] != null) {
                        this.sf[n2].update();
                    }
                    ++n2;
                }
                if (this.df != null) {
                    this.df.update();
                }
                this.infoText2.setText("Time = " + n);
            } else {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n = this.lp.loadUpdate();
                if (n == -1) {
                    this.time_inc.setLabel("RESTART");
                    this.stop();
                } else {
                    this.infoText2.setText("Time = " + n);
                    this.bm.changed = true;
                    this.bm.focus(this.displayScale);
                    this.mapCanvas1.update();
                    this.setScrollbar();
                    int n3 = 0;
                    while (n3 < 3) {
                        if (this.sf[n3] != null) {
                            this.sf[n3].update();
                        }
                        ++n3;
                    }
                    if (this.df != null) {
                        this.df.update();
                    }
                }
            }
            if (n != timeLimit) continue;
            System.err.println("T = " + n + ", suppose to be the end of simulation.");
            System.err.println(" --> V = " + DoubleFormat.toString(this.lp.score(), 10, true));
            System.err.println("I hope this is a good score.");
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.logo, 0, 0, this);
    }

    public Image getLogo() {
        return this.logo;
    }

    void setScrollbar() {
        this.horizontalScrollbar1.setValues(0, 0, buildingMap.min.x, (int)((float)buildingMap.max.x - (float)buildingMap.distance.x / this.bm.displayScale));
        this.horizontalScrollbar1.setValue(buildingMap.newOrigin.x);
        this.horizontalScrollbar1.setUnitIncrement((int)((float)buildingMap.distance.x / this.bm.displayScale / 10.0f));
        this.horizontalScrollbar1.setBlockIncrement((int)((float)buildingMap.distance.x / this.bm.displayScale / 2.0f));
        this.verticalScrollbar1.setValues(0, 0, buildingMap.min.y, (int)((float)buildingMap.max.y - (float)buildingMap.distance.y / this.bm.displayScale));
        this.verticalScrollbar1.setValue((int)((float)buildingMap.min.y + ((float)buildingMap.max.y - (float)buildingMap.distance.y / this.bm.displayScale) - (float)buildingMap.newOrigin.y));
        this.verticalScrollbar1.setUnitIncrement((int)((float)buildingMap.distance.y / this.bm.displayScale / 10.0f));
        this.verticalScrollbar1.setBlockIncrement((int)((float)buildingMap.distance.y / this.bm.displayScale / 2.0f));
    }

    void printScrollbarInfo() {
        System.err.println("Scrolling(" + buildingMap.min.x + "," + buildingMap.min.y + ")-(" + (int)((float)buildingMap.max.x - (float)buildingMap.distance.x / this.bm.displayScale) + "," + (int)((float)buildingMap.max.y - (float)buildingMap.distance.y / this.bm.displayScale) + ")");
        System.err.println("Value(" + buildingMap.newOrigin.x + "," + buildingMap.newOrigin.y + ")");
        System.err.println("Increment(" + (int)((float)buildingMap.distance.x / this.bm.displayScale / 10.0f) + "," + (int)((float)buildingMap.distance.y / this.bm.displayScale / 10.0f) + ")");
    }

    void verticalScrollbar1_AdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        switch (adjustmentEvent.getAdjustmentType()) {
            case 1: {
                this.bm.verticalscroll((int)((float)(-buildingMap.distance.y) / this.bm.newDisplayScale / 10.0f));
                break;
            }
            case 2: {
                this.bm.verticalscroll((int)((float)buildingMap.distance.y / this.bm.newDisplayScale / 10.0f));
                break;
            }
            case 4: {
                this.bm.verticalscroll((int)((float)(-buildingMap.distance.y) / this.bm.newDisplayScale / 2.0f));
                break;
            }
            case 3: {
                this.bm.verticalscroll((int)((float)buildingMap.distance.y / this.bm.newDisplayScale / 2.0f));
                break;
            }
            case 5: {
                this.bm.scrollAbsY(this.verticalScrollbar1.getValue());
            }
        }
        if (this.bm.changed) {
            this.mapCanvas1.update();
        }
    }

    void horizontalScrollbar1_AdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        switch (adjustmentEvent.getAdjustmentType()) {
            case 1: {
                this.bm.horizontalscroll((int)((float)buildingMap.distance.x / this.bm.newDisplayScale / 10.0f));
                break;
            }
            case 2: {
                this.bm.horizontalscroll((int)((float)(-buildingMap.distance.x) / this.bm.newDisplayScale / 10.0f));
                break;
            }
            case 4: {
                this.bm.horizontalscroll((int)((float)buildingMap.distance.x / this.bm.newDisplayScale / 2.0f));
                break;
            }
            case 3: {
                this.bm.horizontalscroll((int)((float)(-buildingMap.distance.x) / this.bm.newDisplayScale / 2.0f));
                break;
            }
            case 5: {
                this.bm.scrollAbsX(this.horizontalScrollbar1.getValue());
            }
        }
        if (this.bm.changed) {
            this.mapCanvas1.update();
        }
    }

    void mapCanvas1_MouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 8) > 0) {
            if (!extendedMode) {
                return;
            }
            if (extendMode == 1) {
                // empty if block
            }
        } else if ((mouseEvent.getModifiers() & 4) > 0) {
            if (!extendedMode) {
                return;
            }
            if (extendMode == 1) {
                float f = this.lp.ixx(mouseEvent.getX());
                float f2 = this.lp.iyy(mouseEvent.getY());
                this.bm.cur.update(f, f2);
                this.mapCanvas1.update();
                this.lp.sendCursorPos((int)f, (int)f2);
            }
        } else {
            String string = this.lp.getMovingObjectInfo(mouseEvent.getX(), mouseEvent.getY());
            if (string != null) {
                Pool._Object _Object2;
                this.setInfoText(string);
                if (extendMode == 1 && (_Object2 = this.lp.getMovingObject(mouseEvent.getX(), mouseEvent.getY())) != null) {
                    this.lp.sendHighlightObject(_Object2.id, 1, "ATTN(AGNT) !!~ID = " + _Object2.id + "~HP=" + ((Pool.Humanoid)_Object2).hp);
                }
                return;
            }
            building building2 = this.bm.findBuilding(mouseEvent.getX(), mouseEvent.getY());
            if (building2 != null) {
                this.setInfoText(building2.description(), building2.description2());
                if (extendMode == 1) {
                    this.lp.sendHighlightObject(building2.pb.id, 1, "ATTN(BLDG) !!~ID = " + building2.pb.id + "~Broken=" + building2.pb.brokenness + "~Fireyness=" + building2.pb.fieryness);
                }
                return;
            }
            road road2 = this.bm.findRoad(mouseEvent.getX(), mouseEvent.getY());
            if (road2 != null) {
                this.setInfoText(road2.description(), road2.description2());
                if (extendMode == 1) {
                    this.lp.sendHighlightObject(road2.pr.id, 1, "ATTN(ROAD) !!~ID = " + road2.pr.id + "~%Blocks=" + (double)((float)road2.pr.block / (float)road2.pr.width) * 100.0);
                }
                return;
            }
            this.setInfoText("No simulation object found", " logViewer 1.5.2 (2002/05/03) Copyright(C) 2000-2002 by Y.Kuwata; kuwatay@nttdata.co.jp");
        }
    }

    public void setInfoText(String string, String string2) {
        this.infoText.setText(string);
        this.infoText3.setText(string2);
    }

    public void setInfoText(String string) {
        this.setInfoText(string, " ");
    }

    void config_MouseClicked(MouseEvent mouseEvent) {
        this.doConfig();
    }

    void doConfig() {
        if (this.cf == null) {
            this.cf = new configFrame("Preference", this.bm, this);
            ((Component)this.cf).setSize(300, 500);
        }
        this.cf.show();
    }

    void zoomin_MouseClicked(MouseEvent mouseEvent) {
        this.doZoomin();
    }

    void doZoomin() {
        if (this.bm.zoomIn(this.displayScale)) {
            this.mapCanvas1.update();
            this.setScrollbar();
        }
    }

    void zoomout_MouseClicked(MouseEvent mouseEvent) {
        this.doZoomout();
    }

    void doZoomout() {
        if (this.bm.zoomOut(this.displayScale)) {
            this.mapCanvas1.update();
            this.setScrollbar();
        }
    }

    void doScale(float f) {
        if (this.bm.setDisplayScale(f, this.displayScale)) {
            this.mapCanvas1.update();
            this.setScrollbar();
        }
    }

    void time_inc_MouseClicked(MouseEvent mouseEvent) {
        this.doStartStop();
    }

    void doStartStop() {
        if (isOnline) {
            if (!extendedMode) {
                return;
            }
            if (extendMode == 1) {
                this.follow();
            } else {
                this.takeOver();
            }
        } else if (new String("RESTART").equals(this.time_inc.getLabel())) {
            this.time_inc.setLabel("STOP");
            this.restart();
        } else if (this.t != null) {
            this.doStop();
        } else {
            this.doStart();
        }
    }

    void takeOver() {
        extendMode = 1;
        this.time_inc.setLabel("SEND");
        this.time_inc.setBackground(Color.red);
    }

    void follow() {
        extendMode = 2;
        this.time_inc.setLabel("RECV");
        this.time_inc.setBackground(Color.yellow);
    }

    void doStop() {
        this.stop();
        this.time_inc.setLabel("START");
    }

    void doStart() {
        this.start();
        this.time_inc.setLabel("STOP");
    }

    void statButton_MouseClicked(MouseEvent mouseEvent) {
        this.doStatShow();
    }

    void doStatShow() {
        int n = 0;
        while (n < 3) {
            if (this.sf[n] == null) {
                this.sf[n] = new statFrame("Statistics [" + n + "]", n, this.lp, this, n);
                ((Component)this.sf[n]).setSize(Map.swg.x, Map.swg.y);
                ((Component)this.sf[n]).setLocation(Map.swg.posX, Map.swg.posY + Map.swg.x * n);
                break;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 3) {
            if (this.sf[n2] != null) {
                this.sf[n2].show();
            }
            ++n2;
        }
    }

    public void statFrameDisposed(int n) {
        this.sf[n] = null;
    }

    void demoButton_MouseClicked(MouseEvent mouseEvent) {
        this.doDemoShow();
    }

    void agentListButton_MouseClicked(MouseEvent mouseEvent) {
        this.doAgentListShow();
    }

    void doDemoShow() {
        if (this.df == null) {
            this.df = new demoFrame("Demonstration Panel", this.lp, this);
            ((Component)this.df).setSize(Map.dwg.x, Map.dwg.y);
            ((Component)this.df).setLocation(Map.dwg.posX, Map.dwg.posY);
        }
        this.df.show();
    }

    void doAgentListShow() {
        if (this.alf == null) {
            this.alf = new agentListFrame("Agent List", this.bm, this.lp, this);
            ((Component)this.alf).setSize(Map.alwg.x, Map.alwg.y);
            ((Component)this.alf).setLocation(Map.alwg.posX, Map.alwg.posY);
        }
        this.alf.show();
    }

    public void agentFrameDisposed() {
        this.alf = null;
    }

    public void demoFrameDisposed() {
        this.df = null;
    }

    void canvas1_MouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 8) > 0) {
            if (extendMode == 1) {
                float f = this.lp.ixx(mouseEvent.getX());
                float f2 = this.lp.iyy(mouseEvent.getY());
                this.bm.hw.addPolylinePoint(this.polyid, f, f2);
                this.bm.hw.draw(this.mapCanvas1, this.mapCanvas1.getGraphics());
            }
        } else if ((mouseEvent.getModifiers() & 4) > 0) {
            if (extendMode == 1) {
                float f = this.lp.ixx(mouseEvent.getX());
                float f3 = this.lp.iyy(mouseEvent.getY());
                this.bm.cur.update(f, f3);
                this.mapCanvas1.update();
                this.lp.sendCursorPos((int)f, (int)f3);
            }
        } else {
            Dimension dimension = this.mapCanvas1.getSize();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = (mousePosX - n) * buildingMap.distance.x / (int)this.bm.newDisplayScale / dimension.width;
            int n4 = (mousePosY - n2) * buildingMap.distance.y / (int)this.bm.newDisplayScale / dimension.height;
            this.bm.scrollRelativeXY(n3, n4);
            mousePosX = n;
            mousePosY = n2;
            if (this.bm.changed) {
                this.mapCanvas1.update();
            }
            this.setScrollbar();
        }
    }

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 10: {
                this.doStartStop();
                break;
            }
            case 46: 
            case 1000: {
                this.doStatShow();
                break;
            }
            case 43: 
            case 53: 
            case 1002: {
                this.doZoomin();
                break;
            }
            case 45: 
            case 1003: {
                this.doZoomout();
                break;
            }
            case 44: {
                this.doConfig();
                break;
            }
            case 56: 
            case 1004: {
                this.bm.verticalscroll((int)((float)buildingMap.distance.y / this.bm.newDisplayScale / (event.shiftDown() ? 10.0f : 2.0f)));
                if (this.bm.changed) {
                    this.mapCanvas1.update();
                }
                this.setScrollbar();
                break;
            }
            case 50: 
            case 1005: {
                this.bm.verticalscroll((int)((float)(-buildingMap.distance.y) / this.bm.newDisplayScale / (event.shiftDown() ? 10.0f : 2.0f)));
                if (this.bm.changed) {
                    this.mapCanvas1.update();
                }
                this.setScrollbar();
                break;
            }
            case 52: 
            case 1006: {
                this.bm.horizontalscroll((int)((float)(-buildingMap.distance.x) / this.bm.newDisplayScale / (event.shiftDown() ? 10.0f : 2.0f)));
                if (this.bm.changed) {
                    this.mapCanvas1.update();
                }
                this.setScrollbar();
                break;
            }
            case 54: 
            case 1007: {
                this.bm.horizontalscroll((int)((float)buildingMap.distance.x / this.bm.newDisplayScale / (event.shiftDown() ? 10.0f : 2.0f)));
                if (this.bm.changed) {
                    this.mapCanvas1.update();
                }
                this.setScrollbar();
            }
        }
        return true;
    }

    void choice1_ItemStateChanged(ItemEvent itemEvent) {
        this.bm.cumn = this.choice1.getSelectedIndex();
        if (this.cf != null) {
            this.cf.update();
        }
    }

    public static void main(String[] stringArray) {
        isApplet = false;
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-h")) {
                    try {
                        _host = InetAddress.getByName(stringArray[++n]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    isOnline = true;
                } else if (stringArray[n].equals("-p")) {
                    _port = Integer.parseInt(stringArray[++n]);
                    isOnline = true;
                } else if (stringArray[n].equals("-f")) {
                    lfile = stringArray[++n];
                    isOnline = false;
                } else if (stringArray[n].equals("-v")) {
                    verbose = true;
                } else if (stringArray[n].equals("-l")) {
                    timeLimit = Integer.parseInt(stringArray[++n]);
                } else if (stringArray[n].equals("-s")) {
                    sound = true;
                } else if (stringArray[n].equals("-e")) {
                    extendedMode = true;
                } else if (stringArray[n].equals("-ubv")) {
                    unitBuildingValue = Integer.parseInt(stringArray[++n]);
                } else if (stringArray[n].equals("-urv")) {
                    unitRoadValue = Integer.parseInt(stringArray[++n]);
                } else if (stringArray[n].equals("-b")) {
                    bfile = stringArray[++n];
                } else if (stringArray[n].equals("-n")) {
                    nfile = stringArray[++n];
                } else if (stringArray[n].equals("-r")) {
                    rfile = stringArray[++n];
                } else if (stringArray[n].equals("-d")) {
                    bfile = stringArray[++n] + bfileDefault;
                    nfile = stringArray[n] + nfileDefault;
                    rfile = stringArray[n] + rfileDefault;
                } else if (stringArray[n].equals("-geometry")) {
                    wg.parse(stringArray[++n]);
                } else if (stringArray[n].equals("-demo")) {
                    showDemo = true;
                } else if (stringArray[n].equals("-demogeometry")) {
                    dwg.parse(stringArray[++n]);
                } else if (stringArray[n].equals("-stat")) {
                    showStat = true;
                } else if (stringArray[n].equals("-statgeometry")) {
                    swg.parse(stringArray[++n]);
                } else if (stringArray[n].equals("-lang")) {
                    try {
                        lang = Map.parseLang(stringArray[++n]);
                    }
                    catch (Exception exception) {}
                } else {
                    Map.usage();
                    throw new Exception("Invalid Argument " + stringArray[n]);
                }
                ++n;
            }
            if (_host == null && isOnline) {
                try {
                    _host = InetAddress.getByName("localhost");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isOnline && lfile == null) {
                Map.usage();
                throw new Exception("No file specified");
            }
            viewerFrame viewerFrame2 = new viewerFrame("Rescue Viewer");
            ((Component)viewerFrame2).setSize(Map.wg.x, Map.wg.y);
            ((Component)viewerFrame2).setLocation(Map.wg.posX, Map.wg.posY);
            ((Component)viewerFrame2).setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void usage() {
        System.err.println("Usage: logViewer [args]");
        System.err.println(" args   -h hostname (Online mode)");
        System.err.println("        -p port (Online mode)");
        System.err.println("        -f log filename (Offline mode)");
        System.err.println("        -ubv unit building value ($ per square meter)");
        System.err.println("        -urv unit road value ($ per square meter)");
        System.err.println("        -r road_filename");
        System.err.println("        -n node_filename");
        System.err.println("        -b building_filename");
        System.err.println("        -d path_to_GIS_file with default file name");
        System.err.println("        -v (Verbose mode)");
        System.err.println("\t    -s (sound effect mode)");
        System.err.println("\t    -e (Extended mode)");
        System.err.println("        -geometry [GEOMETRY] (specify geometry of map window)");
        System.err.println("        -demo (Open demo window)");
        System.err.println("        -demogeometry [GEOMETRY] (specify geometry of demo window)");
        System.err.println("        -stat (Open stat window)");
        System.err.println("        -statgeometry [GEOMETRY] (Specify geometry of stat window)");
    }

    private static int parseLang(String string) throws Exception {
        int n = 0;
        if (string.equals("jp")) {
            n = 1;
        } else if (string.equals("en") || string.equals("C") || string.equals("us")) {
            n = 0;
        } else {
            throw new Exception("Invalid language spec.:" + string);
        }
        return n;
    }

    static {
        bfile = "data/10/building";
        nfile = "data/10/node";
        rfile = "data/10/road";
        bfileDefault = "building";
        nfileDefault = "node";
        rfileDefault = "road";
        soundFile = new String[]{"sound/spacemusic.au", "sound/Honk.au", "sound/Popcorn.au", "sound/Xelephone.au", "sound/boomooooh.au", "sound/DumDaDumDum.au", "sound/ARRGH.au", "sound/Gasp.au", "sound/Tribam.au", "sound/Oops.au", "sound/UhOh.au"};
        timeLimit = 180;
        isApplet = true;
        isOnline = false;
        verbose = true;
        sound = false;
        extendedMode = false;
        _host = null;
        _port = 6000;
        showDemo = false;
        showStat = false;
        lang = 0;
        unitBuildingValue = 1;
        unitRoadValue = 1;
        extendMode = 0;
        wg = new windowGeometry("1024x800");
        dwg = new windowGeometry("800x800+0+0");
        swg = new windowGeometry("350x400");
        alwg = new windowGeometry("350x380");
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == Map.this.choice1) {
                Map.this.choice1_ItemStateChanged(itemEvent);
            }
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == Map.this.mapCanvas1) {
                Map.this.canvas1_MouseDragged(mouseEvent);
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == Map.this.mapCanvas1) {
                Map.this.mapCanvas1_MouseClicked(mouseEvent);
            } else if (object == Map.this.zoomin) {
                Map.this.zoomin_MouseClicked(mouseEvent);
            } else if (object == Map.this.zoomout) {
                Map.this.zoomout_MouseClicked(mouseEvent);
            } else if (object == Map.this.time_inc) {
                Map.this.time_inc_MouseClicked(mouseEvent);
            } else if (object == Map.this.statButton) {
                Map.this.statButton_MouseClicked(mouseEvent);
            } else if (object == Map.this.demoButton) {
                Map.this.demoButton_MouseClicked(mouseEvent);
            } else if (object == Map.this.agentListButton) {
                Map.this.agentListButton_MouseClicked(mouseEvent);
            } else if (object == Map.this.config) {
                Map.this.config_MouseClicked(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == Map.this.mapCanvas1) {
                if (extendedMode) {
                    mousePosX = mouseEvent.getX();
                    mousePosY = mouseEvent.getY();
                    return;
                }
                if ((mouseEvent.getModifiers() & 8) > 0) {
                    if (extendMode == 1) {
                        float f = Map.this.lp.ixx(mouseEvent.getX());
                        float f2 = Map.this.lp.iyy(mouseEvent.getY());
                        Map.this.polyid = Map.this.bm.hw.newPolyline(f, f2);
                    }
                } else if ((mouseEvent.getModifiers() & 4) <= 0) {
                    mousePosX = mouseEvent.getX();
                    mousePosY = mouseEvent.getY();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == Map.this.mapCanvas1) {
                if (!extendedMode) {
                    return;
                }
                if ((mouseEvent.getModifiers() & 4) <= 0 && (mouseEvent.getModifiers() & 8) > 0 && extendMode == 1) {
                    Map.this.lp.sendPolygonPos(Map.this.bm.hw.getPolyline(Map.this.polyid));
                }
            }
        }
    }

    class SymAdjustment
    implements AdjustmentListener {
        SymAdjustment() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Object object = adjustmentEvent.getSource();
            if (object == Map.this.verticalScrollbar1) {
                Map.this.verticalScrollbar1_AdjustmentValueChanged(adjustmentEvent);
            } else if (object == Map.this.horizontalScrollbar1) {
                Map.this.horizontalScrollbar1_AdjustmentValueChanged(adjustmentEvent);
            }
        }
    }
}

