/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Enumeration;
import java.util.Hashtable;
import viewer.coordinates;
import viewer.displayObject;
import viewer.mapCanvas;

public class drawing
extends displayObject {
    Hashtable drawings = new Hashtable();
    static int id = 1;
    Hashtable positions = new Hashtable();
    static int pid = 1;
    icon bi = null;

    public int newBubbleIcon(float f, float f2, Image image) {
        this.bi = new icon(f, f2, image);
        this.drawings.put(new Integer(id), this.bi);
        return id++;
    }

    public void changeBubbleIcon(float f, float f2, String string) {
        if (this.bi == null) {
            System.err.println("Eror on icon");
            return;
        }
        this.bi.visible = true;
        this.bi.x = f;
        this.bi.y = f2;
        this.bi.msg = string;
    }

    public int newPolyline(float f, float f2) {
        return this.newPolyline(f, f2, Color.red);
    }

    public int newPolyline(float f, float f2, Color color) {
        int n = this.newPolyline(color);
        this.addPolylinePoint(n, f, f2);
        return n;
    }

    public int newPolyline(Color color) {
        polyline polyline2 = new polyline(color);
        this.drawings.put(new Integer(id), polyline2);
        return id++;
    }

    public int newPolyline() {
        return this.newPolyline(Color.red);
    }

    public polyline getPolyline(int n) {
        return (polyline)this.drawings.get(new Integer(n));
    }

    public boolean addPolylinePoint(int n, float f, float f2) {
        polyline polyline2 = (polyline)this.drawings.get(new Integer(n));
        if (polyline2 == null) {
            System.err.println("id error " + n);
            return false;
        }
        polyline2.addPoint(f, f2);
        return true;
    }

    public void draw(mapCanvas mapCanvas2, Graphics graphics) {
        Enumeration enumeration = this.drawings.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            Object v = this.drawings.get(n);
            if (v instanceof polyline) {
                ((polyline)v).draw(mapCanvas2, graphics);
                continue;
            }
            if (!(v instanceof icon)) continue;
            ((icon)v).draw(mapCanvas2, graphics);
        }
    }

    class icon
    extends displayObject {
        float x;
        float y;
        Image ii;
        String msg;
        int sx = 200;
        int sy = 140;
        boolean visible = false;

        icon(float f, float f2, Image image) {
            this.x = f;
            this.y = f2;
            this.ii = image;
        }

        void setCoordinates(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        void setCoordinates(coordinates coordinates2) {
            this.x = coordinates2.x;
            this.y = coordinates2.y;
        }

        void draw(mapCanvas mapCanvas2, Graphics graphics) {
            if (!this.visible) {
                return;
            }
            int n = this.xx(this.x);
            int n2 = this.yy(this.y);
            if (!this.isOnScreen()) {
                return;
            }
            graphics.drawImage(this.ii, n, n2 - this.sy, this.sx, this.sy, displayObject.bm);
            graphics.setFont(new Font("Helvetica", 3, 20));
            graphics.setColor(Color.black);
            String string = null;
            String string2 = this.msg;
            int n3 = 1;
            while (n3 < 6 && string2.length() > 0) {
                int n4 = string2.indexOf(126);
                if (n4 > 0) {
                    string = string2.substring(0, n4);
                    string2 = string2.substring(n4 + 1, string2.length());
                } else {
                    string = string2;
                    string2 = "";
                }
                if (string.length() > 18) {
                    string = string.substring(0, 18);
                }
                graphics.drawString(string, n + 2, n2 - this.sy + 20 * n3);
                ++n3;
            }
        }

        boolean isOnScreen() {
            return super.isOnScreen(this.x, this.y);
        }
    }

    class polyline
    extends displayObject {
        Polygon p;
        Color c;
        int width = 1000;
        int first;
        int last;
        int cnt;

        polyline(Color color) {
            this.c = color;
            this.cnt = 0;
            this.last = 0;
            this.first = 0;
        }

        void addPoint(float f, float f2) {
            pos pos2 = new pos(this.last, f, f2);
            this.last = pos2.id;
            if (this.first == 0) {
                this.first = pos2.id;
            }
            ++this.cnt;
        }

        int nPoints() {
            return this.cnt;
        }

        pos[] Points() {
            pos[] posArray = new pos[this.cnt];
            int n = this.first;
            int n2 = 0;
            while (n != 0) {
                pos pos2;
                posArray[n2] = pos2 = (pos)drawing.this.positions.get(new Integer(n));
                n = pos2.next;
                ++n2;
            }
            return posArray;
        }

        void draw(mapCanvas mapCanvas2, Graphics graphics) {
            graphics.setColor(this.c);
            if (!this.isOnScreen()) {
                return;
            }
            pos pos2 = null;
            int n = this.first;
            while (n != 0) {
                pos pos3 = (pos)drawing.this.positions.get(new Integer(n));
                if (n != this.first) {
                    float f = pos2.x - pos3.x;
                    float f2 = pos2.y - pos3.y;
                    float f3 = (float)Math.sqrt(f * f + f2 * f2);
                    int n2 = (int)((float)this.width * f2 / 2.0f / f3);
                    int n3 = (int)((float)this.width * f / 2.0f / f3);
                    this.p = new Polygon();
                    this.p.addPoint(this.xx(pos2.x - (float)n2), this.yy(pos2.y + (float)n3));
                    this.p.addPoint(this.xx(pos2.x + (float)n2), this.yy(pos2.y - (float)n3));
                    this.p.addPoint(this.xx(pos3.x + (float)n2), this.yy(pos3.y - (float)n3));
                    this.p.addPoint(this.xx(pos3.x - (float)n2), this.yy(pos3.y + (float)n3));
                    graphics.fillPolygon(this.p);
                }
                pos2 = pos3;
                n = pos3.next;
            }
        }

        boolean isOnScreen() {
            int n = this.first;
            while (n != 0) {
                pos pos2 = (pos)drawing.this.positions.get(new Integer(n));
                if (super.isOnScreen(pos2.x, pos2.y)) {
                    return true;
                }
                n = pos2.next;
            }
            return false;
        }
    }

    class pos {
        float x;
        float y;
        int id;
        int next;

        pos(float f, float f2) {
            this.x = f;
            this.y = f2;
            this.next = 0;
            this.id = pid;
            drawing.this.positions.put(new Integer(pid++), this);
        }

        pos(int n, float f, float f2) {
            this(f, f2);
            if (n == 0) {
                return;
            }
            pos pos2 = (pos)drawing2.positions.get(new Integer(n));
            if (pos2 == null) {
                System.err.println("Error on position hash");
            } else {
                pos2.next = this.id;
            }
        }
    }
}

