/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.List;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import rescue.LongUDPSocket;
import rescue.Pool;
import viewer.building;
import viewer.buildingMap;
import viewer.coordinates;
import viewer.displayObject;
import viewer.drawing;
import viewer.mapCanvas;
import viewer.road;
import viewer.userModel;

public class logPool
extends displayObject {
    URL baseURL;
    InputStream is = null;
    DataInputStream dis = null;
    Pool _pool;
    boolean em = false;
    int _time = -1;
    static final int HEADER_NULL = 0;
    static final int AK_CONNECT = 16;
    static final int AK_ACKNOWLEDGE = 17;
    static final int KA_CONNECT_OK = 80;
    static final int KA_CONNECT_ERROR = 81;
    static final int KA_SENSE = 82;
    static final int SK_CONNECT = 32;
    static final int SK_ACKNOWLEDGE = 33;
    static final int SK_UPDATE = 34;
    static final int KS_CONNECT_OK = 96;
    static final int KS_CONNECT_ERROR = 97;
    static final int KS_COMMANDS = 98;
    static final int KS_UPDATE = 99;
    static final int ZK_CONNECT = 79;
    static final int KZ_DATA = 15;
    static final int VK_CONNECT = 32;
    static final int VK_ACKNOWLEDGE = 33;
    static final int KV_CONNECT_OK = 96;
    static final int KV_CONNECT_ERROR = 97;
    static final int KV_UPDATE = 99;
    static final int VV_REGISTER = 240;
    static final int VV_ACKNOWLEDGE = 241;
    static final int VV_QUERY = 242;
    static final int VV_SEND = 243;
    static final int VV_ATTENTION = 244;
    static final int CONTAINER_NULL = 0;
    static final int CONTAINER_DECLAR = 1;
    static final int CONTAINER_CURPOS = 2;
    static final int CONTAINER_SCREEN = 3;
    static final int CONTAINER_DRPOLY = 4;
    static final int CONTAINER_PUTICN = 5;
    static final int CONTAINER_MESAGE = 6;
    static final int CONTAINER_HLGHT = 7;
    static int cid;
    LongUDPSocket _socket;
    Pool.Humanoid[] agents;

    public logPool(URL uRL, String string, buildingMap buildingMap2) {
        this.baseURL = uRL;
        this._pool = new Pool();
        displayObject.bm = buildingMap2;
        try {
            this.is = new URL(this.baseURL, string).openStream();
            this.dis = new DataInputStream(this.is);
        }
        catch (IOException iOException) {
            System.err.println("Cannot open remote logfile " + string);
            return;
        }
        System.err.println("Open Remote LogFile " + string);
    }

    public logPool(String string, buildingMap buildingMap2) {
        this._pool = new Pool();
        displayObject.bm = buildingMap2;
        try {
            this.is = new FileInputStream(string);
            this.dis = new DataInputStream(this.is);
        }
        catch (IOException iOException) {
            System.err.println("Cannot open local logfile " + string);
            return;
        }
        System.err.println("Open Local LogFile " + string);
    }

    public boolean loadHeader() {
        if (this.dis == null) {
            return false;
        }
        try {
            char[] cArray = new char[32];
            int n = 0;
            while (n < 32) {
                cArray[n] = (char)this.dis.readByte();
                ++n;
            }
            String string = new String(cArray);
            if (!string.equals("RoboCup-Rescue Prototype Log 00\u0000")) {
                System.err.println("Not a RoboCup-Rescue Prototype log file!!");
                return false;
            }
        }
        catch (IOException iOException) {
            System.err.println("EOF");
        }
        return true;
    }

    public int loadUpdate() {
        if (this.dis == null) {
            return 0;
        }
        try {
            int n = this.dis.readInt();
            this.parse(this.dis);
        }
        catch (IOException iOException) {
            System.err.println("EOF");
            try {
                this.dis.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            System.err.println("Log File done");
            return -1;
        }
        return this._time;
    }

    void parse(DataInputStream dataInputStream) {
        try {
            boolean bl = false;
            int n = dataInputStream.readInt();
            while (n != 0) {
                int n2 = dataInputStream.readInt();
                switch (n) {
                    case 96: {
                        this._pool.restructure(dataInputStream);
                        break;
                    }
                    case 99: {
                        this._time = dataInputStream.readInt();
                        this._pool.restructure(dataInputStream);
                        break;
                    }
                    default: {
                        dataInputStream.skipBytes(n2);
                    }
                }
                n = dataInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public logPool(InetAddress inetAddress, int n, buildingMap buildingMap2, boolean bl) {
        this.em = bl;
        this._pool = new Pool();
        displayObject.bm = buildingMap2;
        try {
            this._socket = new LongUDPSocket();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(32);
            dataOutputStream.writeInt(-1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this._socket.send(byArray, inetAddress, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getPacket() {
        try {
            DataInputStream dataInputStream = new DataInputStream(this._socket.receive());
            this.parse(dataInputStream, this._socket.getAddress(), this._socket.getPort());
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this._time;
    }

    void parse(DataInputStream dataInputStream, InetAddress inetAddress, int n) {
        try {
            boolean bl = false;
            int n2 = dataInputStream.readInt();
            while (n2 != 0) {
                int n3 = dataInputStream.readInt();
                switch (n2) {
                    case 96: {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        dataOutputStream.writeInt(33);
                        dataOutputStream.writeInt(-1);
                        dataOutputStream.writeInt(0);
                        dataOutputStream.close();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        this._socket.send(byArray, inetAddress, n);
                        this._pool.restructure(dataInputStream);
                        if (!this.em) break;
                        this.sendRegister();
                        cid = this.receiveRegisterAck();
                        break;
                    }
                    case 99: {
                        this._time = dataInputStream.readInt();
                        this._pool.restructure(dataInputStream);
                        System.err.println("Time = " + this._time);
                        break;
                    }
                    case 244: {
                        byte[] byArray;
                        if (this.em) {
                            System.err.println("VV_ATTENTION from ");
                            int n4 = dataInputStream.readInt();
                            int n5 = dataInputStream.readInt();
                            if (n5 == 0) {
                                byArray = this.readBytes(dataInputStream, n3 - 8);
                                System.err.println("Receive (broadcast) = " + (n3 - 8));
                                this.parseContainer(byArray);
                                break;
                            }
                            byArray = this.readBytes(dataInputStream, n3 - 8);
                            System.err.println("Receive (to " + n5 + ") = " + (n3 - 8));
                            this.parseContainer(byArray);
                            break;
                        }
                        System.err.println("Wops, received VV_ATTENTION in normal mode.., someting wrong");
                        int n6 = dataInputStream.readInt();
                        int n7 = dataInputStream.readInt();
                        byArray = this.readBytes(dataInputStream, n3 - 8);
                        break;
                    }
                    default: {
                        dataInputStream.skipBytes(n3);
                    }
                }
                n2 = dataInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void parseContainer(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            switch (n) {
                case 0: {
                    return;
                }
                case 1: {
                    int n2 = dataInputStream.readInt();
                    String string = this.readString(dataInputStream, n2);
                    System.err.println("CONTAINER_DECLARE:" + string);
                    break;
                }
                case 2: {
                    int n3 = dataInputStream.readInt();
                    int n4 = dataInputStream.readInt();
                    displayObject.bm.cur.update(n3, n4);
                    buildingMap.mp.follow();
                    break;
                }
                case 3: {
                    int n5 = dataInputStream.readInt();
                    int n6 = dataInputStream.readInt();
                    int n7 = dataInputStream.readInt();
                    displayObject.bm.setScreenParam(n5, n6, n7);
                    buildingMap.mp.follow();
                    break;
                }
                case 4: {
                    int n8 = dataInputStream.readInt();
                    int n9 = -1;
                    int n10 = 0;
                    while (n10 < n8) {
                        int n11 = dataInputStream.readInt();
                        int n12 = dataInputStream.readInt();
                        if (n9 == -1) {
                            n9 = displayObject.bm.hw.newPolyline(n11, n12);
                        } else {
                            displayObject.bm.hw.addPolylinePoint(n9, n11, n12);
                        }
                        ++n10;
                    }
                    break;
                }
                case 5: {
                    System.err.println("CONTAINER_PUTICN:");
                    break;
                }
                case 6: {
                    System.err.println("CONTAINER_MESAGE:");
                    break;
                }
                case 7: {
                    int n13 = dataInputStream.readInt();
                    int n14 = dataInputStream.readInt();
                    int n15 = dataInputStream.readInt();
                    String string = this.readString(dataInputStream, n15);
                    System.err.println("CONTAINER_HIGHLIGHT:" + n13 + "," + n14 + "," + string);
                    displayObject.bm.focusObject(n13, n14, string);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    byte[] readBytes(DataInputStream dataInputStream, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                byArray[n2] = dataInputStream.readByte();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return byArray;
    }

    String readString(DataInputStream dataInputStream, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            try {
                stringBuffer.append(dataInputStream.readChar());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    void sendRegister() {
        try {
            String string = "Extended Viewer";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(240);
            dataOutputStream.writeInt(4 + string.length() * 2);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeChars(string);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this._socket.send(byArray, this._socket.getAddress(), this._socket.getPort());
        }
        catch (Exception exception) {
            System.err.print("sendRegister:");
            exception.printStackTrace();
        }
    }

    int receiveRegisterAck() {
        try {
            DataInputStream dataInputStream = new DataInputStream(this._socket.receive());
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            dataInputStream.close();
            System.err.println("registered, CID = " + n4);
            return n4;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return this._time;
        }
    }

    void sendCursorPos(int n, int n2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(243);
            dataOutputStream.writeInt(24);
            dataOutputStream.writeInt(cid);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this._socket.send(byArray, this._socket.getAddress(), this._socket.getPort());
        }
        catch (Exception exception) {
            System.err.print("sendCursorPos:");
            exception.printStackTrace();
        }
    }

    void sendPolygonPos(drawing.polyline polyline2) {
        int n = polyline2.nPoints();
        drawing.pos[] posArray = polyline2.Points();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(243);
            dataOutputStream.writeInt(20 + n * 8);
            dataOutputStream.writeInt(cid);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(4);
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt((int)posArray[n2].x);
                dataOutputStream.writeInt((int)posArray[n2].y);
                ++n2;
            }
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this._socket.send(byArray, this._socket.getAddress(), this._socket.getPort());
        }
        catch (Exception exception) {
            System.err.print("sendCursorPos:");
            exception.printStackTrace();
        }
    }

    void sendScreenPos(int n, int n2, int n3) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(243);
            dataOutputStream.writeInt(28);
            dataOutputStream.writeInt(cid);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(3);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this._socket.send(byArray, this._socket.getAddress(), this._socket.getPort());
        }
        catch (Exception exception) {
            System.err.print("sendCursorPos:");
            exception.printStackTrace();
        }
    }

    void sendHighlightObject(int n, int n2, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(243);
            dataOutputStream.writeInt(24 + string.length() * 2);
            dataOutputStream.writeInt(cid);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(7);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this._socket.send(byArray, this._socket.getAddress(), this._socket.getPort());
        }
        catch (Exception exception) {
            System.err.print("sendHighlightObject:");
            exception.printStackTrace();
        }
    }

    public void attachObject(buildingMap buildingMap2) {
        Enumeration enumeration = this._pool.motionlesses.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            Pool.MotionlessObject motionlessObject;
            Pool._Object _Object2 = (Pool._Object)enumeration.nextElement();
            if (_Object2 instanceof Pool.Building) {
                motionlessObject = (Pool.Building)_Object2;
                object2 = new coordinates(motionlessObject.x, motionlessObject.y).hashValue();
                object = (building)buildingMap2.positionObject.get(object2);
                if (object != null) {
                    ((building)object).pb = motionlessObject;
                    continue;
                }
                System.err.println("warning: building object" + motionlessObject + " at (" + motionlessObject.x + "," + motionlessObject.y + ") is not found in building data");
                continue;
            }
            if (_Object2 instanceof Pool.Road) {
                motionlessObject = (Pool.Road)_Object2;
                object2 = (Pool._Object)this._pool.map.get(((Pool.Edge)motionlessObject).head);
                object = (Pool._Object)this._pool.map.get(((Pool.Edge)motionlessObject).tail);
                if (!(object2 instanceof Pool.PointObject) || !(object instanceof Pool.PointObject)) continue;
                Pool.PointObject pointObject = (Pool.PointObject)object2;
                Pool.PointObject pointObject2 = (Pool.PointObject)object;
                String string = new coordinates((pointObject.x + pointObject2.x) / 2, (pointObject.y + pointObject2.y) / 2).hashValue();
                road road2 = (road)buildingMap2.positionObject.get(string);
                if (road2 != null) {
                    road2.pr = motionlessObject;
                    continue;
                }
                System.err.println("road object" + motionlessObject + "(" + pointObject.x + "," + pointObject.y + ")-(" + pointObject2.x + "," + pointObject2.y + ") Not found in road data");
                continue;
            }
            if (!(_Object2 instanceof Pool.Node)) continue;
            motionlessObject = (Pool.Node)_Object2;
        }
    }

    public boolean drawMovingObject(mapCanvas mapCanvas2, Graphics graphics) {
        this.checkDisplaySize(mapCanvas2);
        boolean bl = false;
        Enumeration enumeration = this._pool.movings.elements();
        int n = this.iconSize();
        while (enumeration.hasMoreElements()) {
            Pool._Object _Object2 = (Pool._Object)enumeration.nextElement();
            if (!(_Object2 instanceof Pool.Humanoid)) continue;
            Pool.Humanoid humanoid = (Pool.Humanoid)_Object2;
            Pool._Object _Object3 = (Pool._Object)this._pool.map.get(humanoid.position);
            coordinates coordinates2 = this.agentPosition(_Object2);
            int n2 = coordinates2.x;
            int n3 = coordinates2.y;
            if (n2 != -1 && this.isOnScreen(n2, n3)) {
                if (displayObject.bm.ums[displayObject.bm.cumn].showAgentICON) {
                    if (humanoid instanceof Pool.FireCompany && displayObject.bm.ums[displayObject.bm.cumn].showAgentFB) {
                        this.drawIcon(graphics, displayObject.bm, n2, n3, humanoid, displayObject.bm.iconFF, n);
                    } else if (humanoid instanceof Pool.AmbulanceTeam && displayObject.bm.ums[displayObject.bm.cumn].showAgentRT) {
                        if (_Object3 instanceof Pool.Building) {
                            if (humanoid.hp > 0) {
                                graphics.setColor(Color.red);
                                graphics.fillRect(this.xx(n2) - n / 2, this.yy(n3) - n / 2, n, n);
                                this.drawIcon(graphics, displayObject.bm, n2, n3, displayObject.bm.iconSearch, n, -n);
                            } else {
                                System.err.println("NOTE: Dead Ambulance Team in Building " + humanoid);
                            }
                        }
                        this.drawIcon(graphics, displayObject.bm, n2, n3, humanoid, displayObject.bm.iconDR, n);
                    } else if (humanoid instanceof Pool.PoliceForce && displayObject.bm.ums[displayObject.bm.cumn].showAgentPF) {
                        this.drawIcon(graphics, displayObject.bm, n2, n3, humanoid, displayObject.bm.iconRM, n);
                    } else if (displayObject.bm.ums[displayObject.bm.cumn].showAgentCV) {
                        this.drawIcon(graphics, displayObject.bm, n2, n3, humanoid, displayObject.bm.iconMan[humanoid.id % 10], n);
                        if (humanoid.justSaved) {
                            this.drawIcon(graphics, displayObject.bm, n2, n3, displayObject.bm.iconSaved, n, -n);
                        }
                    }
                } else if (humanoid instanceof Pool.FireCompany && displayObject.bm.ums[displayObject.bm.cumn].showAgentFB) {
                    this.drawAgentOval(graphics, displayObject.bm, humanoid, Color.blue, n2, n3);
                } else if (humanoid instanceof Pool.AmbulanceTeam && displayObject.bm.ums[displayObject.bm.cumn].showAgentRT) {
                    this.drawAgentOval(graphics, displayObject.bm, humanoid, Color.white, n2, n3);
                } else if (humanoid instanceof Pool.PoliceForce && displayObject.bm.ums[displayObject.bm.cumn].showAgentPF) {
                    this.drawAgentOval(graphics, displayObject.bm, humanoid, Color.yellow, n2, n3);
                } else if (displayObject.bm.ums[displayObject.bm.cumn].showAgentCV) {
                    this.drawAgentOval(graphics, displayObject.bm, humanoid, Color.green, n2, n3);
                }
                if (humanoid.justSaved) {
                    bl = true;
                }
            }
            humanoid.claerStatus();
        }
        return bl;
    }

    public coordinates agentPosition(Pool._Object _Object2) {
        if (_Object2 instanceof Pool.Humanoid) {
            Pool.Humanoid humanoid = (Pool.Humanoid)_Object2;
            Pool._Object _Object3 = (Pool._Object)this._pool.map.get(humanoid.position);
            int n = -1;
            int n2 = -1;
            if (_Object3 instanceof Pool.PointObject) {
                Pool.PointObject pointObject = (Pool.PointObject)_Object3;
                n = pointObject.x;
                n2 = pointObject.y;
            } else if (_Object3 instanceof Pool.Edge) {
                Pool.Edge edge = (Pool.Edge)_Object3;
                Pool._Object _Object4 = (Pool._Object)this._pool.map.get(edge.head);
                Pool._Object _Object5 = (Pool._Object)this._pool.map.get(edge.tail);
                if (_Object4 instanceof Pool.PointObject && _Object5 instanceof Pool.PointObject) {
                    Pool.PointObject pointObject = (Pool.PointObject)_Object4;
                    Pool.PointObject pointObject2 = (Pool.PointObject)_Object5;
                    int n3 = pointObject2.x - pointObject.x;
                    int n4 = pointObject2.y - pointObject.y;
                    double d = (double)humanoid.positionExtra / (double)edge.length;
                    n = (int)((double)pointObject.x + (double)n3 * d);
                    n2 = (int)((double)pointObject.y + (double)n4 * d);
                }
            }
            return new coordinates(n, n2);
        }
        return null;
    }

    private void drawAgentOval(Graphics graphics, buildingMap buildingMap2, Pool.Humanoid humanoid, Color color, int n, int n2) {
        Color color2 = displayObject._blend(color, Color.black, (double)humanoid.hp / 10000.0);
        if (humanoid.hp > 0) {
            color2 = displayObject._blend(Color.red, color2, (double)humanoid.damage / (double)humanoid.hp);
        }
        graphics.setColor(color2);
        int n3 = (int)buildingMap2.displayScale;
        int n4 = n3 / 2;
        graphics.fillOval(this.xx(n) - n4, this.yy(n2) - n4, n3, n3);
    }

    private void drawIcon(Graphics graphics, buildingMap buildingMap2, int n, int n2, Pool.Humanoid humanoid, Image image, int n3) {
        int n4 = this.xx(n);
        int n5 = this.yy(n2);
        int n6 = n3 / 2;
        int n7 = humanoid.hp * n3 / 10000;
        if (humanoid.hp == 0) {
            graphics.setColor(Color.black);
            graphics.fillRect(n4 - n6, n5 - n6, n3, n3);
        }
        graphics.drawImage(image, n4 - n6, n5 - n6, n3, n3, buildingMap2);
        graphics.setColor(Color.blue);
        graphics.drawLine(n4 - n6, n5 + n6, n4 - n6 + n7, n5 + n6);
        graphics.drawLine(n4 - n6, n5 + n6 + 1, n4 - n6 + n7, n5 + n6 + 1);
        graphics.setColor(Color.red);
        graphics.drawLine(n4 - n6 + n7, n5 + n6, n4 + n6, n5 + n6);
        graphics.drawLine(n4 - n6 + n7, n5 + n6 + 1, n4 + n6, n5 + n6 + 1);
        if (humanoid.hp == 0) {
            graphics.setColor(Color.black);
            graphics.drawLine(n4 - n6, n5 + n6, n4 + n6, n5 - n6);
            graphics.drawLine(n4 - n6, n5 - n6, n4 + n6, n5 + n6);
        }
    }

    public coordinates centerOfAgents(userModel userModel2) {
        coordinates coordinates2 = new coordinates();
        int n = 0;
        Enumeration enumeration = this._pool.movings.elements();
        while (enumeration.hasMoreElements()) {
            Pool.MotionlessObject motionlessObject;
            Pool._Object _Object2 = (Pool._Object)enumeration.nextElement();
            if (!(_Object2 instanceof Pool.Humanoid)) continue;
            Pool.Humanoid humanoid = (Pool.Humanoid)_Object2;
            Pool._Object _Object3 = (Pool._Object)this._pool.map.get(humanoid.position);
            int n2 = -1;
            int n3 = -1;
            if (_Object3 instanceof Pool.PointObject) {
                motionlessObject = (Pool.PointObject)_Object3;
                n2 = motionlessObject.x;
                n3 = motionlessObject.y;
            } else if (_Object3 instanceof Pool.Edge) {
                motionlessObject = (Pool.Edge)_Object3;
                Pool._Object _Object4 = (Pool._Object)this._pool.map.get(((Pool.Edge)motionlessObject).head);
                Pool._Object _Object5 = (Pool._Object)this._pool.map.get(((Pool.Edge)motionlessObject).tail);
                if (_Object4 instanceof Pool.PointObject && _Object5 instanceof Pool.PointObject) {
                    Pool.PointObject pointObject = (Pool.PointObject)_Object4;
                    Pool.PointObject pointObject2 = (Pool.PointObject)_Object5;
                    int n4 = pointObject2.x - pointObject.x;
                    int n5 = pointObject2.y - pointObject.y;
                    double d = (double)humanoid.positionExtra / (double)((Pool.Edge)motionlessObject).length;
                    n2 = (int)((double)pointObject.x + (double)n4 * d);
                    n3 = (int)((double)pointObject.y + (double)n5 * d);
                }
            }
            if (!(humanoid instanceof Pool.FireCompany && userModel2.eventFB || humanoid instanceof Pool.AmbulanceTeam && userModel2.eventRT) && (!(humanoid instanceof Pool.PoliceForce) || !userModel2.eventPF)) continue;
            coordinates2.x += n2;
            coordinates2.y += n3;
            ++n;
        }
        if (n > 0) {
            coordinates2.x /= n;
            coordinates2.y /= n;
        }
        return coordinates2;
    }

    public float suitableScale(userModel userModel2) {
        coordinates coordinates2 = new coordinates(Integer.MAX_VALUE, Integer.MAX_VALUE);
        coordinates coordinates3 = new coordinates(Integer.MIN_VALUE, Integer.MIN_VALUE);
        float f = 1.0f;
        int n = 0;
        Enumeration enumeration = this._pool.movings.elements();
        while (enumeration.hasMoreElements()) {
            Pool.MotionlessObject motionlessObject;
            Pool._Object _Object2 = (Pool._Object)enumeration.nextElement();
            if (!(_Object2 instanceof Pool.Humanoid)) continue;
            Pool.Humanoid humanoid = (Pool.Humanoid)_Object2;
            Pool._Object _Object3 = (Pool._Object)this._pool.map.get(humanoid.position);
            int n2 = -1;
            int n3 = -1;
            if (_Object3 instanceof Pool.PointObject) {
                motionlessObject = (Pool.PointObject)_Object3;
                n2 = motionlessObject.x;
                n3 = motionlessObject.y;
            } else if (_Object3 instanceof Pool.Edge) {
                motionlessObject = (Pool.Edge)_Object3;
                Pool._Object _Object4 = (Pool._Object)this._pool.map.get(((Pool.Edge)motionlessObject).head);
                Pool._Object _Object5 = (Pool._Object)this._pool.map.get(((Pool.Edge)motionlessObject).tail);
                if (_Object4 instanceof Pool.PointObject && _Object5 instanceof Pool.PointObject) {
                    Pool.PointObject pointObject = (Pool.PointObject)_Object4;
                    Pool.PointObject pointObject2 = (Pool.PointObject)_Object5;
                    int n4 = pointObject2.x - pointObject.x;
                    int n5 = pointObject2.y - pointObject.y;
                    double d = (double)humanoid.positionExtra / (double)((Pool.Edge)motionlessObject).length;
                    n2 = (int)((double)pointObject.x + (double)n4 * d);
                    n3 = (int)((double)pointObject.y + (double)n5 * d);
                }
            }
            if (!(humanoid instanceof Pool.FireCompany && userModel2.eventFB || humanoid instanceof Pool.AmbulanceTeam && userModel2.eventRT) && (!(humanoid instanceof Pool.PoliceForce) || !userModel2.eventPF)) continue;
            if (n2 < coordinates2.x) {
                coordinates2.x = n2;
            }
            if (n2 > coordinates3.x) {
                coordinates3.x = n2;
            }
            if (n3 < coordinates2.y) {
                coordinates2.y = n3;
            }
            if (n3 > coordinates3.y) {
                coordinates3.y = n3;
            }
            ++n;
        }
        if (n > 0) {
            try {
                float f2 = this.nearScale(buildingMap.distance.x / (coordinates3.x - coordinates2.x));
                float f3 = this.nearScale(buildingMap.distance.y / (coordinates3.y - coordinates2.y));
                f = f2 < f3 ? f2 : f3;
            }
            catch (Exception exception) {
                f = 0.0f;
            }
        }
        return f;
    }

    private float nearScale(float f) {
        if (f < 1.0f) {
            return 1.0f;
        }
        if (f < 4.0f) {
            return 2.0f;
        }
        if (f < 8.0f) {
            return 4.0f;
        }
        return 8.0f;
    }

    public Pool._Object getMovingObject(int n, int n2) {
        int n3 = 8;
        if ((double)displayObject.bm.displayScale > 8.0) {
            n3 = 16;
        }
        Enumeration enumeration = this._pool.movings.elements();
        while (enumeration.hasMoreElements()) {
            Pool._Object _Object2 = (Pool._Object)enumeration.nextElement();
            if (!(_Object2 instanceof Pool.Humanoid)) continue;
            Pool.Humanoid humanoid = (Pool.Humanoid)_Object2;
            Pool._Object _Object3 = (Pool._Object)this._pool.map.get(humanoid.position);
            int n4 = -1;
            int n5 = -1;
            if (_Object3 instanceof Pool.PointObject) {
                Pool.PointObject pointObject = (Pool.PointObject)_Object3;
                n4 = pointObject.x;
                n5 = pointObject.y;
            } else if (_Object3 instanceof Pool.Edge) {
                Pool.Edge edge = (Pool.Edge)_Object3;
                Pool._Object _Object4 = (Pool._Object)this._pool.map.get(edge.head);
                Pool._Object _Object5 = (Pool._Object)this._pool.map.get(edge.tail);
                if (_Object4 instanceof Pool.PointObject && _Object5 instanceof Pool.PointObject) {
                    Pool.PointObject pointObject = (Pool.PointObject)_Object4;
                    Pool.PointObject pointObject2 = (Pool.PointObject)_Object5;
                    int n6 = pointObject2.x - pointObject.x;
                    int n7 = pointObject2.y - pointObject.y;
                    double d = (double)humanoid.positionExtra / (double)edge.length;
                    n4 = (int)((double)pointObject.x + (double)n6 * d);
                    n5 = (int)((double)pointObject.y + (double)n7 * d);
                }
            }
            if (n4 == -1) continue;
            int n8 = this.xx(n4);
            int n9 = this.yy(n5);
            if (n <= n8 - n3 || n >= n8 + n3 || n2 <= n9 - n3 || n2 >= n9 + n3) continue;
            return _Object2;
        }
        return null;
    }

    public List getMovingObjectList(int n, boolean bl) {
        int n2 = this.getNumberOfMovingObject();
        this.agents = new Pool.Humanoid[n2];
        List list = new List(n, bl);
        Enumeration enumeration = this._pool.movings.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            Pool._Object _Object2 = (Pool._Object)enumeration.nextElement();
            if (!(_Object2 instanceof Pool.Humanoid)) continue;
            Pool.Humanoid humanoid = (Pool.Humanoid)_Object2;
            list.addItem(this.objectName(_Object2));
            this.agents[n3++] = humanoid;
        }
        return list;
    }

    public Pool.Humanoid getMovingObject(int n) {
        return this.agents[n];
    }

    public int getNumberOfMovingObject() {
        int n = 0;
        Enumeration enumeration = this._pool.movings.elements();
        while (enumeration.hasMoreElements()) {
            Pool._Object _Object2 = (Pool._Object)enumeration.nextElement();
            if (!(_Object2 instanceof Pool.Humanoid)) continue;
            ++n;
        }
        return n;
    }

    public String getMovingObjectInfo(int n, int n2) {
        String string = null;
        int n3 = 8;
        if ((double)displayObject.bm.displayScale > 8.0) {
            n3 = 16;
        }
        Enumeration enumeration = this._pool.movings.elements();
        while (enumeration.hasMoreElements()) {
            Pool._Object _Object2 = (Pool._Object)enumeration.nextElement();
            if (!(_Object2 instanceof Pool.Humanoid)) continue;
            Pool.Humanoid humanoid = (Pool.Humanoid)_Object2;
            coordinates coordinates2 = this.agentPosition(_Object2);
            if (coordinates2.x == -1) continue;
            int n4 = this.xx(coordinates2.x);
            int n5 = this.yy(coordinates2.y);
            if (n <= n4 - n3 || n >= n4 + n3 || n2 <= n5 - n3 || n2 >= n5 + n3) continue;
            string = string == null ? this.objectInfo(_Object2) : string + "," + this.objectInfo(_Object2);
        }
        return string;
    }

    public String objectName(Pool._Object _Object2) {
        String string = null;
        if (_Object2 instanceof Pool.Humanoid) {
            Pool.Humanoid humanoid = (Pool.Humanoid)_Object2;
            string = humanoid instanceof Pool.FireCompany ? "FireCompany" : (_Object2 instanceof Pool.AmbulanceTeam ? "AmbulanceTeam" : (_Object2 instanceof Pool.PoliceForce ? "PoloceForce" : "Civilian"));
            string = string + "#" + humanoid.id;
        }
        return string;
    }

    public String objectInfo(Pool._Object _Object2) {
        return this.objectName(_Object2) + "at" + this.agentPosition(_Object2).info() + ",(HP=" + ((Pool.Humanoid)_Object2).hp + ")";
    }

    public boolean isOnScreen(int n, int n2) {
        return super.isOnScreen(n, n2);
    }

    public String statLine() {
        return "Prople:L/D = " + this._pool.livings + "/" + this._pool.deads + ",Brk =" + this._pool.buildingBroken[0] + "/" + this._pool.buildingBroken[1] + "/" + this._pool.buildingBroken[2] + "/" + this._pool.buildingBroken[3] + "/" + this._pool.buildingBroken[4] + ",Brn =" + this._pool.buildingBurned[0] + "/" + this._pool.buildingBurned[1] + "/" + this._pool.buildingBurned[2] + "/" + this._pool.buildingBurned[3] + "/" + this._pool.buildingBurned[4];
    }

    public double score2001() {
        return (double)(this._pool.deads + 1) - (double)this._pool.allHp * (displayObject.bm.areaAll - displayObject.bm.areaBurned) / displayObject.bm.areaAll / (double)this._pool.hp0;
    }

    public double score() {
        return (double)(this._pool.livings + this._pool.allHp / this._pool.hp0) * Math.sqrt((displayObject.bm.areaAll - displayObject.bm.areaBurned) / displayObject.bm.areaAll);
    }
}

