/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import rescue.Pool;
import viewer.CookedDataInputStream;
import viewer.buildingMap;
import viewer.coordinates;
import viewer.displayObject;
import viewer.mapCanvas;
import viewer.node;

class road
extends displayObject {
    int size;
    Integer startNodeID;
    Integer endNodeID;
    int length;
    int kind;
    int nCars1;
    int nCars2;
    int nPeople1;
    int nPeople2;
    int width;
    int crossWidth;
    int repairCost;
    int hasSeparator;
    int nLane1;
    int nLane2;
    int CrosswalkWidth;
    Polygon p = null;
    public Pool.Road pr = null;

    public road(CookedDataInputStream cookedDataInputStream, buildingMap buildingMap2) {
        displayObject.bm = buildingMap2;
        this.size = cookedDataInputStream.readCookedUnsigned();
        this.id = new Integer(cookedDataInputStream.readCookedUnsigned());
        this.startNodeID = new Integer(cookedDataInputStream.readCookedUnsigned());
        this.endNodeID = new Integer(cookedDataInputStream.readCookedUnsigned());
        this.length = cookedDataInputStream.readCookedUnsigned();
        this.kind = cookedDataInputStream.readCookedUnsigned();
        this.nCars1 = cookedDataInputStream.readCookedUnsigned();
        this.nCars2 = cookedDataInputStream.readCookedUnsigned();
        this.nPeople1 = cookedDataInputStream.readCookedUnsigned();
        this.nPeople2 = cookedDataInputStream.readCookedUnsigned();
        this.width = cookedDataInputStream.readCookedUnsigned();
        this.crossWidth = cookedDataInputStream.readCookedUnsigned();
        this.repairCost = cookedDataInputStream.readCookedUnsigned();
        this.hasSeparator = cookedDataInputStream.readCookedUnsigned();
        this.nLane1 = cookedDataInputStream.readCookedUnsigned();
        this.nLane2 = cookedDataInputStream.readCookedUnsigned();
        this.CrosswalkWidth = cookedDataInputStream.readCookedUnsigned();
    }

    void createPobject(mapCanvas mapCanvas2, Graphics graphics) {
        this.checkDisplaySize(mapCanvas2);
        this.p = new Polygon();
        node node2 = (node)displayObject.bm.nodes.get(this.startNodeID);
        node node3 = (node)displayObject.bm.nodes.get(this.endNodeID);
        if (node2 == null || node3 == null) {
            System.err.println("FATAL: No node information " + this.startNodeID + " " + this.endNodeID);
            return;
        }
        if (displayObject.bm.ums[displayObject.bm.cumn].showRoadOutline) {
            int n = this.width * (node3.pos.y - node2.pos.y) / 2 / this.length;
            int n2 = this.width * (node3.pos.x - node2.pos.x) / 2 / this.length;
            this.p.addPoint(this.xx(node2.pos.x - n), this.yy(node2.pos.y + n2));
            this.p.addPoint(this.xx(node2.pos.x + n), this.yy(node2.pos.y - n2));
            this.p.addPoint(this.xx(node3.pos.x + n), this.yy(node3.pos.y - n2));
            this.p.addPoint(this.xx(node3.pos.x - n), this.yy(node3.pos.y + n2));
        } else {
            this.p.addPoint(this.xx(node2.pos.x), this.yy(node2.pos.y));
            this.p.addPoint(this.xx(node3.pos.x), this.yy(node3.pos.y));
        }
    }

    public Color statColor() {
        if (this.pr != null) {
            if (displayObject.bm.ums[displayObject.bm.cumn].showRaodBlock) {
                return displayObject._blend(Color.black, Color.white, (double)this.pr.block / (double)this.pr.width);
            }
            return Color.white;
        }
        return Color.green;
    }

    public boolean draw(mapCanvas mapCanvas2, Graphics graphics) {
        if (!this.isOnScreen()) {
            this.p = null;
            return false;
        }
        if (displayObject.bm.changed || this.p == null) {
            this.createPobject(mapCanvas2, graphics);
        }
        graphics.setColor(this.statColor());
        if (displayObject.bm.ums[displayObject.bm.cumn].showRoadOutline && displayObject.bm.ums[displayObject.bm.cumn].showRaodBlock) {
            graphics.fillPolygon(this.p);
        } else {
            graphics.drawPolygon(this.p);
        }
        if (displayObject.bm.ums[displayObject.bm.cumn].showRoadDetails && (double)displayObject.bm.displayScale > 16.0) {
            coordinates coordinates2 = this.center();
            graphics.setColor(Color.black);
            graphics.drawString("ID:" + this.id, this.xx(coordinates2.x), this.yy(coordinates2.y));
        }
        return true;
    }

    public void print() {
        System.out.println("** ROAD INFOMATION **");
        System.out.println("ID=" + this.id);
    }

    public String description() {
        return "ROAD ID=" + this.pr.id + "(GID=" + this.id + "), kind =" + this.kind + ", width = " + this.width + ", length = " + this.length;
    }

    public String description2() {
        if (this.pr != null) {
            return "% Block = " + (double)((float)this.pr.block / (float)this.pr.width) * 100.0;
        }
        return " ";
    }

    public String descriptionAll() {
        return this.description() + ", " + this.description2();
    }

    public boolean inside(int n, int n2) {
        if (this.p == null) {
            return false;
        }
        return this.p.contains(n, n2);
    }

    public coordinates center() {
        node node2 = (node)displayObject.bm.nodes.get(this.startNodeID);
        node node3 = (node)displayObject.bm.nodes.get(this.endNodeID);
        int n = (node2.pos.x + node3.pos.x) / 2;
        int n2 = (node2.pos.y + node3.pos.y) / 2;
        return new coordinates(n, n2);
    }

    public double damage(double d) {
        if (this.pr == null) {
            return 0.0;
        }
        return (double)this.pr.block * d * (double)this.length / 1000000.0;
    }

    public boolean isOnScreen() {
        node node2 = (node)displayObject.bm.nodes.get(this.startNodeID);
        node node3 = (node)displayObject.bm.nodes.get(this.endNodeID);
        int n = this.width * (node3.pos.y - node2.pos.y) / 2 / this.length;
        int n2 = this.width * (node3.pos.x - node2.pos.x) / 2 / this.length;
        if (super.isOnScreen(node2.pos.x, node2.pos.y)) {
            return true;
        }
        if (super.isOnScreen(node3.pos.x, node3.pos.y)) {
            return true;
        }
        if (super.isOnScreen(node2.pos.x - n, node2.pos.y + n2)) {
            return true;
        }
        if (super.isOnScreen(node2.pos.x + n, node2.pos.y - n2)) {
            return true;
        }
        if (super.isOnScreen(node3.pos.x + n, node3.pos.y - n2)) {
            return true;
        }
        return super.isOnScreen(node3.pos.x - n, node3.pos.y + n2);
    }
}

