/*
 * Decompiled with CFR 0.152.
 */
package viewerServer;

import java.awt.Component;
import java.net.InetAddress;
import viewerServer.logReceiver;
import viewerServer.mainFrame;
import viewerServer.viewerServer;

public class logController
implements Runnable {
    private static String version = "1.1";
    private static String lfile;
    private static InetAddress _host;
    private static int viewerPort;
    private static int hostPort;
    private static boolean isOnline;
    static boolean verbose;
    private Thread t;
    logReceiver lr;
    int masterTime = 0;
    mainFrame mf;
    viewerServer vs;

    public logController() {
        try {
            this.mf = new mainFrame(this);
            ((Component)this.mf).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (isOnline) {
            if (verbose) {
                System.err.println("Trying to connect .. " + _host);
            }
            try {
                this.lr = new logReceiver(_host, hostPort, this.mf);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.lr == null) {
                System.err.println("Can't connect server");
            }
            this.lr.start();
        } else {
            boolean bl = false;
            this.lr = new logReceiver(lfile, this.mf);
            if (this.lr == null) {
                System.err.println("Can't load logfile");
            }
            this.lr.loadFully();
        }
        this.vs = new viewerServer(viewerPort, this, this.mf, this.lr);
        this.vs.start();
        this.doStart();
    }

    synchronized void doStart() {
        System.err.println("Start controller");
        if (this.t == null) {
            this.t = new Thread(this);
        }
        this.t.start();
    }

    synchronized void doStop() {
        System.err.println("Stop controller");
        if (this.t != null) {
            this.t.stop();
            this.t = null;
        }
    }

    public void setMasterTime(int n) {
        this.masterTime = n;
    }

    public int getMasterTime() {
        return this.masterTime;
    }

    public void run() {
        int n = -1;
        while (this.t != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n = this.lr.receivedTime();
            if (verbose) {
                System.err.println("logController.run(), time = " + this.masterTime + " received = " + n);
            }
            if (n < this.masterTime) continue;
            this.mf.setMasterTime(this.masterTime);
            this.vs.catchUpAllClients(this.masterTime, this.lr);
            ++this.masterTime;
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-h")) {
                    try {
                        _host = InetAddress.getByName(stringArray[++n]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    isOnline = true;
                } else if (stringArray[n].equals("-p")) {
                    hostPort = Integer.parseInt(stringArray[++n]);
                } else if (stringArray[n].equals("-P")) {
                    viewerPort = Integer.parseInt(stringArray[++n]);
                    isOnline = true;
                } else if (stringArray[n].equals("-f")) {
                    lfile = stringArray[++n];
                    isOnline = false;
                } else if (stringArray[n].equals("-v")) {
                    verbose = true;
                } else {
                    logController.usage();
                    throw new Exception("Invalid Argument " + stringArray[n]);
                }
                ++n;
            }
            if (_host == null && isOnline) {
                try {
                    _host = InetAddress.getByName("localhost");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isOnline && lfile == null) {
                logController.usage();
                throw new Exception("No file specified");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (verbose) {
            System.err.println("viewerServer " + version + " started");
            System.err.println(" mode = " + (isOnline ? "Online" : "Offline"));
            if (isOnline) {
                System.err.println(" host = " + _host + " hostPort = " + hostPort);
            } else {
                System.err.println(" file = " + lfile);
            }
            System.err.println(" viewerPort = " + viewerPort);
        }
        new logController();
    }

    private static void usage() {
        System.err.println("Usage: viewerServer [args]");
        System.err.println(" args   -h hostname (Online mode)");
        System.err.println("        -p port (Online mode, default=6000)");
        System.err.println("        -f log filename (Offline mode)");
        System.err.println("        -P port (for Viewers, default=6060)");
        System.err.println("        -v (Verbose mode)");
    }

    static {
        _host = null;
        viewerPort = 6060;
        hostPort = 6000;
        isOnline = false;
        verbose = false;
    }
}

