/*
 * Decompiled with CFR 0.152.
 */
package viewerServer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import rescue.LongUDPSocket;
import viewerServer.mainFrame;

public class logReceiver
extends Thread {
    InputStream is = null;
    DataInputStream dis = null;
    int _time = -1;
    static byte[] data;
    mainFrame mf;
    messageQueue mq;
    static final int MAX_MESSAGE = 5000;
    static final int HEADER_NULL = 0;
    static final int AK_CONNECT = 16;
    static final int AK_ACKNOWLEDGE = 17;
    static final int KA_CONNECT_OK = 80;
    static final int KA_CONNECT_ERROR = 81;
    static final int KA_SENSE = 82;
    static final int SK_CONNECT = 32;
    static final int SK_ACKNOWLEDGE = 33;
    static final int SK_UPDATE = 34;
    static final int KS_CONNECT_OK = 96;
    static final int KS_CONNECT_ERROR = 97;
    static final int KS_COMMANDS = 98;
    static final int KS_UPDATE = 99;
    static final int ZK_CONNECT = 79;
    static final int KZ_DATA = 15;
    static final int VK_CONNECT = 32;
    static final int VK_ACKNOWLEDGE = 33;
    static final int KV_CONNECT_OK = 96;
    static final int KV_CONNECT_ERROR = 97;
    static final int KV_UPDATE = 99;
    LongUDPSocket _socket;

    public logReceiver(String string, mainFrame mainFrame2) {
        this.mf = mainFrame2;
        this.mq = new messageQueue();
        try {
            this.is = new FileInputStream(string);
            this.dis = new DataInputStream(this.is);
        }
        catch (IOException iOException) {
            System.err.println("Cannot open local logfile " + string);
            return;
        }
        System.err.println("Open Local LogFile " + string);
    }

    public byte[] getMessage(int n) {
        return this.mq.getMessage(n);
    }

    public byte[] getConnectMessage() {
        return this.mq.getMessage(0);
    }

    public void loadFully() {
        int n = 0;
        boolean bl = false;
        this.loadHeader();
        while (!bl) {
            try {
                n = this.loadUpdate();
            }
            catch (IOException iOException) {
                System.err.println("EOF");
                bl = true;
            }
            this.mf.setKernelTime(n);
        }
    }

    public boolean loadHeader() {
        if (this.dis == null) {
            return false;
        }
        try {
            char[] cArray = new char[32];
            int n = 0;
            while (n < 32) {
                cArray[n] = (char)this.dis.readByte();
                ++n;
            }
            String string = new String(cArray);
            if (!string.equals("RoboCup-Rescue Prototype Log 00\u0000")) {
                System.err.println("Not a RoboCup-Rescue Prototype log file!!");
                return false;
            }
        }
        catch (IOException iOException) {
            System.err.println("EOF");
        }
        return true;
    }

    public synchronized int loadUpdate() throws IOException {
        if (this.dis == null) {
            return 0;
        }
        int n = this.dis.readInt();
        data = this.read(this.dis, n);
        this.parse(data);
        this.mq.insertMessage(this._time, data);
        return this._time;
    }

    synchronized byte[] read(DataInputStream dataInputStream, int n) {
        byte[] byArray = new byte[n];
        try {
            dataInputStream.readFully(byArray, 0, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    synchronized void parse(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            while (n != 0) {
                int n2 = dataInputStream.readInt();
                switch (n) {
                    case 96: {
                        this._time = 0;
                        dataInputStream.skipBytes(n2);
                        break;
                    }
                    case 99: {
                        this._time = dataInputStream.readInt();
                        dataInputStream.skipBytes(n2 - 4);
                        break;
                    }
                    default: {
                        dataInputStream.skipBytes(n2);
                    }
                }
                n = dataInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public logReceiver(InetAddress inetAddress, int n, mainFrame mainFrame2) {
        this.mf = mainFrame2;
        this.mq = new messageQueue();
        try {
            this._socket = new LongUDPSocket();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.sendKvConnect(inetAddress, n);
    }

    private void sendKvConnect(InetAddress inetAddress, int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(32);
            dataOutputStream.writeInt(-1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this._socket.send(byArray, inetAddress, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void sendKvAcknowledge(InetAddress inetAddress, int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(33);
            dataOutputStream.writeInt(-1);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this._socket.send(byArray, inetAddress, n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void run() {
        while (true) {
            int n = this.getPacket();
            this.mf.setKernelTime(n);
        }
    }

    public int receivedTime() {
        return this._time;
    }

    public synchronized int getPacket() {
        try {
            DataInputStream dataInputStream = new DataInputStream(this._socket.receive());
            this.parse(dataInputStream, this._socket.getAddress(), this._socket.getPort());
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this._time;
    }

    void parse(DataInputStream dataInputStream, InetAddress inetAddress, int n) {
        try {
            int n2 = dataInputStream.readInt();
            while (n2 != 0) {
                int n3 = dataInputStream.readInt();
                switch (n2) {
                    case 96: {
                        data = this.createKvConnectOK(dataInputStream, n3);
                        this.sendKvAcknowledge(inetAddress, n);
                        this.mq.insertMessage(0, data);
                        break;
                    }
                    case 99: {
                        this._time = dataInputStream.readInt();
                        data = this.createKvUpdate(dataInputStream, n3, this._time);
                        this.mq.insertMessage(this._time, data);
                        break;
                    }
                }
                n2 = dataInputStream.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private byte[] createKvConnectOK(DataInputStream dataInputStream, int n) {
        byte[] byArray = new byte[n + 8 + 4];
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(96);
            dataOutputStream.writeInt(n);
            dataOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            System.arraycopy(byArray2, 0, byArray, 0, 8);
            dataInputStream.readFully(byArray, 8, n);
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byArray2 = byteArrayOutputStream.toByteArray();
            System.arraycopy(byArray2, 0, byArray, n + 8, 4);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    private byte[] createKvUpdate(DataInputStream dataInputStream, int n, int n2) {
        byte[] byArray = new byte[n + 8 + 4];
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(99);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            System.arraycopy(byArray2, 0, byArray, 0, 12);
            dataInputStream.readFully(byArray, 12, n - 4);
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
            byArray2 = byteArrayOutputStream.toByteArray();
            System.arraycopy(byArray2, 0, byArray, n + 8, 4);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    class messageQueue {
        message[] mq = new message[5000];

        messageQueue() {
        }

        public void insertMessage(int n, byte[] byArray) {
            this.mq[n] = new message(n, byArray);
        }

        public byte[] getMessage(int n) {
            return this.mq[n].body;
        }
    }

    class message {
        byte[] body;
        int time;

        message(int n, byte[] byArray) {
            this.time = n;
            this.body = byArray;
        }
    }
}

