/*
 * Header    :
 * File      : CivilianController.cxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/11/19
 * Time-stamp: <2002-04-28 01:28:55 kshinoda>
 * Comment   :
 * End       :
 */
/*
 * Copyright (C) 2001 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#include "../itk/itk.h"
#include "../rescuelang/AgentBase.h"
#include "CivilianController.hxx"

using namespace Rescue;
using namespace Itk;
using namespace RescueCivilian;

void CivilianController::needToCycle2(Sexp* result) {
  //if(result->equal(RescueAgentBase::noAction) 
  //|| result->equal(RescueAgentBase::bodyAction))
    needto_cyclep = False;
    //  else
    //needto_cyclep = True;
};

void CivilianController::nextstep(){
  needto_cyclep = True;
};

Sexp* CivilianController::cycle() {
  //env().agentbase().traceOn();
  Sexp* result = env().agentbase().cycle();
  //env().agentbase().traceOff();
  return result;
};

void CivilianController::sensed(S32 time,
				LongUDPSocket& socket, 
				Input& input, Output& output){
  // restructure objectpool with new object information
  m_time = time;

  env().setEnvironmentalInformation(m_time, input);
  // get own information
  env()._self() = dynamic_cast<Humanoid*>(env().map().get(m_selfId));
};


void CivilianController::heard(LongUDPSocket& socket,
			       Id speaker,
			       const char* message,
			       Input& input,
			       Output& output){
  //env().addMessageBuffer(message);
  printf("heard %s form %ld\n", message, speaker);
};

//------------------------------------------------------------
//
Path CivilianController::circuitWalk(){
  MotionlessObject* current = env().current();
  MotionlessObject* next    = 0;
  Path path;
  S32 num_of_visited = m_NumOfVisited[current];
  S32 path_length = (num_of_visited < 3)? 2 : ((num_of_visited < 10)? 5 : 1);

  for(; path_length != 0; path_length--){
    next = selectNode(current);
    path.push_back(next);
    current = next;
  }
  return path;
};

MotionlessObject* CivilianController::selectNode(MotionlessObject* current){
  MotionlessObject* nextPosition = 0;
  S32 min = S32_MAX;
  
  // search next moving target :: least visited position
  for(Objects::const_iterator it = current->neighbors().begin();
      it != current->neighbors().end(); it++){
    MotionlessObject* pos = dynamic_cast<MotionlessObject*>(*it);
    if(pos){
      Building* building = dynamic_cast<Building*>(pos);
      Refuge*   refuge   = dynamic_cast<Refuge*>(pos);
      if(building && !refuge) continue;
      S32 num_of_visit = 0;
      if(m_NumOfVisited.find(pos) != m_NumOfVisited.end()){
	num_of_visit = m_NumOfVisited[pos];
	if(num_of_visit < min){
	  min = num_of_visit;
	  nextPosition = pos;
	}
      } else {
	num_of_visit = min = 0;
	nextPosition = pos;
	break;
      }     
    }
  }
  // If next position can select
  if(nextPosition){
    if(m_NumOfVisited.find(current) != m_NumOfVisited.end()){
      S32 num_of_visit = m_NumOfVisited[current] + 1;
      m_NumOfVisited[current] = num_of_visit;
    } else {
      m_NumOfVisited[current] = 1;
    }
  }
  return nextPosition;
};


//------------------------------------------------------------
// Civilian::setRoadPath
Path CivilianController::setRoadPath(MotionlessObject* from, 
				     MotionlessObject* to){
  Bool success = False;

  Path open;
  Path closed;
  CounterTable cost;
  CounterTable heuristic;
  map<MotionlessObject*, MotionlessObject*> solution;

  Path plan;

  cost[from] = 0;
  heuristic[from] = distance(from, to);
  
  open.push_back(from);

  S32 counter = 0;
  S32 counter_max = (S32)(20.0 + fltRand(-10.0,20.0));

  //printf("counter max : %ld  ", counter_max);
  for(; counter < counter_max ; counter++){
    if(open.size() == 0){
      success = False;
      break;
    } else {
      MotionlessObject* node = dynamic_cast<MotionlessObject*>(open.front());
      open.erase(open.begin());
      if(node == to){
	success = True;
	break;
      } else {
	closed.push_back(node);
	open.remove(node);
	for(Objects::const_iterator it = node->neighbors().begin();
	    it != node->neighbors().end(); it++){
	  MotionlessObject* obj = dynamic_cast<MotionlessObject*>(*it);
	  Road* road = dynamic_cast<Road*>(obj);
	  if(road){
	    //S32 update_time = road->getTimeBlockUpdated();
	    //if(update_time == 0){
	      ;//obj = 0;
	      //} else {
	      int aliveLines = 0;
	      if(road->head() == node){
		aliveLines = getAliveLinesToTail(road);
		if(road->tail() != 0)
		  obj = dynamic_cast<MotionlessObject*>(road->tail());
		else
		  printf(" no tail node-----------\n");
	      } 
	      else if(road->tail() == node){
		aliveLines = getAliveLinesToHead(road);
		if(road->head())
		  obj = dynamic_cast<MotionlessObject*>(road->head());
		else
		  printf(" no head node-----------\n");
				  
	      }
	      if(aliveLines == 0)
		continue;
	      //}
	  }
	  Building* building = dynamic_cast<Building*>(obj);
	  if(building != 0){
	    if(obj != to)
	      continue;
	  }
	  if(obj){
	    S32 cost_tmp = cost[node] + distance(node, obj);
	    Path::iterator open_it   = find(open.begin(), open.end(),obj);
	    Path::iterator closed_it = find(closed.begin(), closed.end(), obj);
	    if(open_it == open.end() && closed_it == closed.end()){
	      cost[obj] = cost_tmp;
	    } else {
	      if(cost_tmp < cost[obj])
		cost[obj] = cost_tmp;
	    }
	    S32 heuristic_tmp = cost_tmp + distance(obj, to);
	    if(open_it == open.end() && closed_it == closed.end()){
	      heuristic[obj] = heuristic_tmp;
	      open.push_back(obj);
	      if(road != 0 && obj != dynamic_cast<MotionlessObject*>(road)) {
		solution[dynamic_cast<MotionlessObject*>(road)] = node;
		solution[obj] = dynamic_cast<MotionlessObject*>(road);
	      } else
		solution[obj] = node;
	    }
	    if(open_it != open.end() && heuristic_tmp < heuristic[obj]){
	      heuristic[obj] = heuristic_tmp;
	      if(road != 0 && dynamic_cast<MotionlessObject*>(road)) {
		solution[dynamic_cast<MotionlessObject*>(road)] = node;
		solution[obj] = dynamic_cast<MotionlessObject*>(road);
	      } else
		solution[obj] = node;
	    }
	    if(closed_it != closed.end() && heuristic_tmp < heuristic[obj]){
	      heuristic[obj] = heuristic_tmp;
	      closed.remove(obj);
	      open.push_back(obj);
	      if(road != 0) {
		solution[dynamic_cast<MotionlessObject*>(road)] = node;
		solution[obj] = dynamic_cast<MotionlessObject*>(road);
	      } else
		solution[obj] = node;
	    }
	  }
	}
      }
    }
    sortByHeuristicValue(open, heuristic);
  }
  //printf("counter %ld\n", counter);

  if(success){
    MotionlessObject* node = to;
    for(;;){
      if(node == from) break;
      plan.push_front(node);
      node = solution[node];
    }
  } else {
    if(open.size() > 0){
      S32 min_dist = S32_MAX;
      MotionlessObject* node = open.front();
      for(Path::const_iterator it = open.begin();
	it != open.end(); it++){
	S32 dist = distance(*it, to);
	if(dist < min_dist){
	  min_dist = dist;
	  node = *it;
	}
      }    
      for(;;){
	if(node == from) break;
	plan.push_front(node);
	node = solution[node];
      }
    }
  }
  return plan;
};
#if 0
void CivilianController::setRoadPath(MotionlessObject* prev,
				     Building* start, 
				     MotionlessObject* goal,
				     Path& open,
				     Path& closed,
				     CounterTable& cost,
				     CounterTable& heuristic){
  if(start == goal){
    open.push_front(gorl);
  }
  S32 cost_tmp = cost[prev] + distance(prev, start);
  S32 heuristic_tmp = cost_tmp + distance(prev, start);

  Road* road = dynamic_cast<Road*>(start);
  Node* node = dynamic_cast<Node*>(start);

  if(road != 0){
    MotionlessObject* next;
    if(prev != road()->head())
      next = road()->head();
    else if(prev != road->tail())
      next = road()->tail();
    else {
      ITK_WRN("there is no hear/tail this road id : " << road->id());
    }
    
  } else if(node != 0){
  }
}; 

void CivilianController::setRoadPath(MotionlessObject* prev,
				     Road* start, 
				     MotionlessObject* goal,
				     Path& open,
				     Path& closed,
				     CounterTable& cost,
				     CounterTable& heuristic){
  if(start->id() == goal->id()
    open.push_front(gorl);
  }
  S32 cost_tmp = cost[prev] + distance(prev, start);
  S32 heuristic_tmp = cost_tmp + distance(prev, start);
  if(start != 0){
    MotionlessObject* next;
    if(prev != start->head())
      next = start->head();
    else if(prev != road->tail())
      next = start->tail();
    else {
      ITK_WRN("there is no hear/tail this road id : " << road->id());
    }
    Node* node = dynamic_cast<Node*>(next);
    if(node != 0)
      setRoadPath(dynamic_cast<MotionlessObject*>(start), 
		  node,
		  goal,
		  open
  }
}; 

void CivilianController::setRoadPath(MotionlessObject* prev,
				     Node* start, 
				     MotionlessObject* goal,
				     Path& open,
				     Path& closed,
				     CounterTable& cost,
				     CounterTable& heuristic){
  if(start == goal){
    open.push_front(gorl);
  }
  S32 cost_tmp = cost[prev] + distance(prev, start);
  S32 heuristic_tmp = cost_tmp + distance(prev, start);

  Road* road = dynamic_cast<Road*>(start);
  Node* node = dynamic_cast<Node*>(start);

  if(road != 0){
    MotionlessObject* next;
    if(prev != road()->head())
      next = road()->head();
    else if(prev != road->tail())
      next = road()->tail();
    else {
      ITK_WRN("there is no hear/tail this road id : " << road->id());
    }
    
  } else if(node != 0){
  }
}; 

#endif

S32 CivilianController::distance(MotionlessObject* from, MotionlessObject* to){
  return (S32)(fabs(from->x() - to->x()) + fabs(from->y() - to->y()));
};

S32 CivilianController::getAliveLinesToHead(Road* road){
  double lineWidth =
    ((double)road->width())/((double)(road->linesToHead()+road->linesToTail()));
  double blockWidth = ((double)road->block())/2.0;
  double linesBlockedRate = blockWidth/lineWidth;
  S32 linesBlocked = (S32)floor(linesBlockedRate + 0.5);
  S32 linesAliveHead = road->linesToHead() - linesBlocked;
  if(linesAliveHead < 0) linesAliveHead = 0;
  return linesAliveHead;
};
S32 CivilianController::getAliveLinesToTail(Road* road){
  double lineWidth =
    ((double)road->width())/((double)(road->linesToHead()+road->linesToTail()));
  double blockWidth = ((double)road->block())/2.0;
  double linesBlockedRate = blockWidth/lineWidth;
  S32 linesBlocked = (S32)floor(linesBlockedRate + 0.5);
  S32 linesAliveTail = road->linesToHead() - linesBlocked;
  if(linesAliveTail < 0) linesAliveTail = 0;
  return linesAliveTail;
};

void CivilianController::sortByHeuristicValue(Path open, 
					      CounterTable heuristic){
  Path newTable;
  MotionlessObject* min;
  MotionlessObject* tmp;

  while(open.size() > 0){
    min = open.front();
    for(int i = 1; i < (signed int)open.size();i++){
      Path::iterator it = open.begin();
      advance(it, i);
      tmp = *it;
      if(heuristic[min] > heuristic[tmp])
	min = tmp;
    }
    newTable.push_back(min);
    open.remove(min);
  }
  *&open = *&newTable;
};

//----------------------------------------------------------------------
// CivilianController :: agent action command

//------------------------------------------------------------
// CivilianController::move_to_refuge
//  move to nearest refuge : distance
void CivilianController::move_to_refuge(){
  // set id of nearest refuge from current position
  Refuge* near_refuge = 0;
  double min_dist = (double)S32_MAX;
  for(Objects::const_iterator it = env().pool().objects().begin();
      it != env().pool().objects().end(); it++){
    Refuge* refuge = dynamic_cast<Refuge*>(*it);
    if(refuge){
      double dist = env().distance(refuge);
      if(dist < min_dist){
	min_dist = dist;
	near_refuge = refuge;
      }
    }
  }
  if(near_refuge){
    Path path = setRoadPath(env().current(), near_refuge);
    if(path.size() == 0){
      path = circuitWalk();
    }
    move(socket(), path, output());
  } else {
    Path path = circuitWalk();
    move(socket(), path, output());
  }  
};

//------------------------------------------------------------
//
void CivilianController::move_to_refuge(Id refuge_id){
  MotionlessObject* refuge = 
    dynamic_cast<MotionlessObject*>(env().pool().get(refuge_id));
  if(refuge){
    Path path = setRoadPath(env().current(), refuge);
    if(path.size() == 0)
      path = circuitWalk();
    move(socket(), path, output());
  } else {
    Path path = circuitWalk();
    move(socket(), path, output());
  }
};

void CivilianController::move_to(Id target_id){
  MotionlessObject* target =
    dynamic_cast<MotionlessObject*>(env().pool().get(target_id));
  if(target){
    Path path = setRoadPath(env().current(), target);
    if(path.size() == 0){
      path = circuitWalk();
    }
    move(socket(), path, output());
  } else {
    Path path = circuitWalk();
    move(socket(), path, output());
  }
};


void CivilianController::say_message(Sexp* message){
  SubString str = message->symVal();
  char msg[str.length()];
  str.copyTo(msg, str.length());
  say(socket(), msg, output());
};

