/*
 * Header    :
 * File      : Controller.cxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/11/19
 * Time-stamp: "2001-12-10 16:47:14 kshinoda"
 * Comment   :
 * End       :
 */
/*
 * Copyright (C) 2001 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#include "Controller.hxx"

using namespace Rescue;
using namespace RescueCivilian;

void Controller::move(LongUDPSocket& socket, 
		      Path& path,
		      Output& output){
  output.clear();
  output.put(AK_MOVE);
  Output::Cursor base = output.put(~(S32)0);
  output.put(m_selfId);
  Path::const_iterator it = path.begin();
  for(; it != path.end(); it++){
    Road* road = dynamic_cast<Road*>(*it);
    if(road){
      it++;
      if(it != path.end()){
	Node* node = dynamic_cast<Node*>(*it);
	if(node){
	  output.put(road->id());
	  output.put(node->id());
	} else {
	  Building* building = dynamic_cast<Building*>(*it);
	  output.put(building->id());
	  break;
	}
      } else {
	break;
      }
    } else {
      MotionlessObject* obj = dynamic_cast<MotionlessObject*>(*it);
      output.put(obj->id());
    }
  }
  output.put((Id)0);
  output.setSize(base);
  output.put(HEADER_NULL);
  socket.send(output, m_to, m_time);
};

void Controller::say(LongUDPSocket& socket, 
		     const char* message,
		     Output& output){
  output.clear();
  output.put(AK_SAY);
  Output::Cursor base = output.put(~(S32)0);
  output.put(m_selfId);
  output.putString(message);
  output.setSize(base);
  output.put(HEADER_NULL);
  socket.send(output, m_to, m_time);
};

void Controller::tell(LongUDPSocket& socket,
		      const char* message,
		      Output& output){
  output.clear();
  output.put(AK_TELL);
  Output::Cursor base = output.put(~(S32)0);
  output.put(m_selfId);
  output.putString(message);
  output.setSize(base);
  output.put(HEADER_NULL);
  socket.send(output, m_to, m_time);
};

void Controller::extinguish(LongUDPSocket& socket,
			    Id id,
			    S32 x,
			    S32 y,
			    S32 amount_of_water,
			    Output& output){
  output.clear();
  output.put(AK_EXTINGUISH);
  Output::Cursor base = output.put(~(S32)0);
  output.put(m_selfId);
  output.put(id);
  output.put(0);
  output.put(x);
  output.put(y);
  output.put(amount_of_water); // amount of water per min.
  output.setSize(base);
  output.put(HEADER_NULL);
  socket.send(output, m_to, m_time);
};
