/*
 * Header    :
 * File      : Environment.hxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/11/17
 * LastUpdate: 2001/11/17
 * Comment   :
 * End       :
 */
/*
 * Copyright (C) 2001 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#include <fstream>
#include "../itk/itk.h"
#include "Environment.hxx"
#include "Controller.hxx"
#include "CivilianController.hxx"

using namespace Itk;
using namespace Rescue;
using namespace RescueCivilian;

//--------------------------------------------------
// Environment :: Environmental Information]
ObjectPool Environment::m_map;
RescueObjectPool Environment::m_meshmap;
Bool       Environment::m_initialize = True;

//--------------------------------------------------
//
void Environment::setEnvironmentalInformation(S32 time, Input& input, 
				     CivilianController* civilianp){
  m_controller = civilianp;
  agentbase().rescueengine()._env() = this;
  if(m_initialize){
    m_initialize = False;
    return setEnvironmentalInformation(time, input);
  }
  if(time == 0){
    for(Objects::const_iterator it = map().objects().begin(); 
	it != map().objects().end(); it++){
      Building* building = dynamic_cast<Building*>(*it);
      if(!isNull(building)){
	buildings().push_back(building);
      }
      Refuge* refuge = dynamic_cast<Refuge*>(*it);
      if(!isNull(refuge)){
	refuges().push_back(refuge);
      }
    }
  } else {
    buildings().clear();
    civilians().clear();
    for(Objects::const_iterator it = map().objects().begin();
	it != map().objects().end(); it++){
      Building* building = dynamic_cast<Building*>(*it);
      if(!isNull(building)){
	buildings().push_back(building);
      }
      Humanoid* civilian = dynamic_cast<Humanoid*>(*it);
      if(!isNull(civilian)){
	civilians().push_back(civilian);
      }
    }
    //ITK_DBG(civilians().size());
  }
};

void Environment::setEnvironmentalInformation(S32 time, Input& input){
  map().restructure(time, input);
  if(time == 0){
    for(Objects::const_iterator it = map().objects().begin(); 
	it != map().objects().end(); it++){
      Building* building = dynamic_cast<Building*>(*it);
      if(!isNull(building)){
	buildings().push_back(building);
      }
      Refuge* refuge = dynamic_cast<Refuge*>(*it);
      if(!isNull(refuge)){
	refuges().push_back(refuge);
      }
    }
  } else {
    buildings().clear();
    civilians().clear();
    for(Objects::const_iterator it = map().objects().begin();
	it != map().objects().end(); it++){
      Building* building = dynamic_cast<Building*>(*it);
      if(!isNull(building)){
	buildings().push_back(building);
      }
      Humanoid* civilian = dynamic_cast<Humanoid*>(*it);
      if(!isNull(civilian)){
	civilians().push_back(civilian);
      }
    }
    //ITK_DBG(civilians().size());
  }
}

//--------------------------------------------------
//
void Environment::scanRuleText(const char* filename){

  agentbase().setPositTable(filename, scenarioHeap());
  
  Posit* init = agentbase().getPosit("init");

  agentbase().situation().add(init);
  
};

double Environment::distance(MotionlessObject* from, MotionlessObject* to){
  double x_diff = (double)from->x() - (double)to->x();
  double y_diff = (double)from->y() - (double)to->y();
  return  sqrt(x_diff * x_diff + y_diff * y_diff);
};

double Environment::distance(MotionlessObject* from, Humanoid* to){
  return distance(from, dynamic_cast<MotionlessObject*>(to->position()));
};

double Environment::distance(Humanoid* from, MotionlessObject* to){
  return distance(dynamic_cast<MotionlessObject*>(from->position()), to);
};
double Environment::distance(Humanoid* from, Humanoid* to){
  return distance(from, dynamic_cast<MotionlessObject*>(to->position()));
}
double Environment::distance(MotionlessObject* to){
  return distance(m_self, to);
};
double Environment::distance(Humanoid* to){
  return distance(m_self, to);
};
