/*
 * Header    :
 * File      : Environment.hxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/11/16
 * Time-stamp: <2002-04-16 04:27:22 kshinoda>
 * Comment   :
 * End       :
 */
/*
 * Copyright (C) 2001 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef __Environment_hxx__
#define __Environment_hxx__

#include <math.h>
#include <string>
#include <list>
#include "../itk/itk.h"
#include "../librescue/librescue.hxx"
#include "../rescuelang/Posit.h"
#include "../rescuelang/AgentBase.h"
#include "RescueAgentBase.hxx"
#include "RescueObjectPool.hxx"

namespace RescueCivilian {

using namespace Itk;
using namespace Rescue;

  class CivilianController;

  typedef RingBufferT<string> LocalMessageBuffer;
  
  typedef list<Refuge*>   Refuges;
  typedef list<Building*> Buildings;
  typedef list<Humanoid*> Humanoids;
  
  class Environment {
    //--------------------------------------------------
    // Environment :: typedef

    //--------------------------------------------------
    // Environment :: Environmental Information
  public:
    static ObjectPool m_map;
    static RescueObjectPool m_meshmap;
    static Bool       m_initialize;
    ITK_DEF_ACCESS(ObjectPool&  pool(), { return  m_map; });
    ITK_DEF_ACCESS(ObjectPool* _pool(), { return &m_map; });
    ITK_DEF_ACCESS(ObjectPool&  map(), { return  m_map; });
    ITK_DEF_ACCESS(ObjectPool* _map(), { return &m_map; });

  public:
    Refuges   refuges_;
    Buildings buildings_;
    Humanoids civilians_;

    ITK_DEF_ACCESS(Refuges&   refuges(),   { return refuges_;   });
    ITK_DEF_ACCESS(Buildings& buildings(), { return buildings_; });
    ITK_DEF_ACCESS(Humanoids& civilians(), { return civilians_; });

    //--------------------------------------------------
    // Environment :: Self Information
  public:
    Humanoid*  m_self;
    ITK_DEF_ACCESS(Humanoid &  self(), { return *m_self; });
    ITK_DEF_ACCESS3(Humanoid*, & _self(), { return  m_self; });
    MotionlessObject* current(){
      return dynamic_cast<MotionlessObject*>(self().position());
    };
    
    //--------------------------------------------------
    // Environment :: Rules
    //----------------------------------------
    // agentbase
  public:
    RescueAgentBase m_agentbase;
    ITK_DEF_ACCESS(RescueAgentBase& agentbase(), { return m_agentbase; });

    //----------------------------------------
    // Sexp::Heap heap
  public:
    Sexp::Heap heap;
    ITK_DEF_ACCESS(Sexp::Heap& scenarioHeap(), { return heap; });

    Sexp::Heap m_messageHeap;
    ITK_DEF_ACCESS(Sexp::Heap& messageHeap(), { return m_messageHeap; });

    //----------------------------------------
    // Agent Controller
  public:
    CivilianController* m_controller;
    ITK_DEF_ACCESS(CivilianController& controller(),{ return *m_controller; });
    ITK_DEF_ACCESS3(CivilianController*,&_controller(),{return m_controller;});
    
    //--------------------------------------------------
    // Environment :: LocalMessageBuffer
  private:
    LocalMessageBuffer m_buf;
    ITK_DEF_ACCESS(LocalMessageBuffer messagebuffer(), { return m_buf; });
    ITK_DEF_ACCESS(string& messagebufffer(UInt i), { return m_buf[i]; });

    //--------------------------------------------------
    //  Environment:: constructor
  public:
    Environment(Input& input){

      map().restructure(0, input);
      //map().setUpMesh(1000, 1000);
      
    }
  public:
    Environment(){ 
      m_buf = LocalMessageBuffer("messagebuffer",4);
    };

  public:
    void setEnvironmentalInformation(S32 time, Input& input, 
				     CivilianController* civilianp);
    void setEnvironmentalInformation(S32 time, Input& input);
    
    //--------------------------------------------------
    // message buffer operator
  public:
    void addMessageBuffer(const char* msg){
      string message(msg);
      return addMessageBuffer(message);
    }
    void addMessageBuffer(string& msg){
      messagebuffer().put(msg);
    }
    void clearMessageBuffer() {
      messagebuffer().clear();
    }
    
    //--------------------------------------------------
    //
  public:
    void scanRuleText(const char* filename);

    //--------------------------------------------------
    //
  public:
    double distance(MotionlessObject* from, MotionlessObject* to);
    double distance(MotionlessObject* from, Humanoid* to);
    double distance(Humanoid* from, MotionlessObject* to);
    double distance(Humanoid* from, Humanoid* to);
    double distance(MotionlessObject* to);
    double distance(Humanoid* to);
  };
};

#endif //__Environment_hxx__
