/*
 * Header    :
 * File      : RescueAgentBase.hxx
 * Auther    : Kosuke Shinoda
 * Since     :
 * Time-stamp: <2002-04-28 01:15:40 kshinoda>
 * Comment   :
 * End       :
 */
/*
 * Copyright (C) 2001 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */

#ifndef __RescueAgentBase_hxx__
#define __RescueAgentBase_hxx__

#include "../itk/itk.h"
#include "../rescuelang/AgentBase.h"
#include "RescueEvalEngine.hxx"

namespace RescueCivilian {
  using namespace Itk;
  using namespace Rescue;
  
  class RescueAgentBase : public AgentBase {
  public:
    static Sexp  bodyAction_;
    static Sexp* bodyAction;
    static Sexp  sayAction_;
    static Sexp* sayAction;
    static Sexp  changeSituation_;
    static Sexp* changeSituation;
    
    //----------------------------------------
    //
    RescueEvalEngine m_rescueengine;
    ITK_DEF_ACCESS(RescueEvalEngine& rescueengine(),{return m_rescueengine;});

  public:
    RescueAgentBase() : AgentBase() {
      setEvalEngine(&m_rescueengine);
      rescueengine()._agentbase() = this;
      //ITK_DBG(rescueengine());
    };

  public:
    void init();
    
    //--------------------------------------------------
    // PositTable Operator
    Bool find(Sexp* posit_name);

    //--------------------------------------------------
    // PositTable
    void setPositTable(const char* filename, Sexp::Heap* heap = ITK_NULLPTR);
    void setPositTable(const char* filename, Sexp::Heap& heap){
      return setPositTable(filename, &heap);
    };
    void setPositTable(istream* is, Sexp::Heap* heap = ITK_NULLPTR);
    void setPositTable(istream& is, Sexp::Heap* heap){
      return setPositTable(&is, heap);
    };
    void setPositTable(istream* is, Sexp::Heap& heap){
      return setPositTable(is, &heap);
    };
    void setPositTable(istream& is, Sexp::Heap& heap){
      return setPositTable(is, &heap);
    };
    void setPositTable(Sexp* posit, Sexp::Heap* heap = ITK_NULLPTR);
    void setPositTable(Sexp* posit, Sexp::Heap& heap){
      return setPositTable(posit, &heap);
    };

    Posit* getPosit(const char* positname);
    Posit* getPosit(SubString& positname);
    Posit* getPosit(Sexp* positname);
    
  public:
    Bool situation_add(Sexp* in_positname);
    Bool situation_remove(Sexp* out_positname);
    Bool situation_swap(Sexp* in_positname, Sexp* out_positname);
    void situation_clear();
  };
};

#endif//__CivilianAgentBase_hxx__
