/*
 * Header    :
 * File      : RescueEvalEngine.hxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/11/25
 * Time-stamp: "2002-04-16 04:28:37 kshinoda"
 * Comment   :
 * End       :
 */
#ifndef __RescueEvalEngine_hxx__
#define __RescueEvalEngine_hxx__

#include "../itk/itk.h"
#include "../librescue/librescue.hxx"
#include "../rescuelang/FrameSexp.h"
#include "../rescuelang/Posit.h"
#include "../rescuelang/EvalEngine.h"

namespace RescueCivilian {
  using namespace Itk;
  using namespace Rescue;

  class Environment;
  class RescueAgentBase;

  //==================================================
  // Class RescueEvalEngine
  class RescueEvalEngine : public EvalEngine {

    //--------------------------------------------------
    // RescueEvalEngine:: member
  public:
    Bool sight_limited_;
    ITK_DEF_ACCESS(Bool& sight_limited(), { return sight_limited_; });
    
    //--------------------------------------------------
    // RescueEvalEngine :: Environment*
  public:
    Environment* m_env;
    ITK_DEF_ACCESS(Environment& env(), { return *m_env; } );
    ITK_DEF_ACCESS3(Environment*, &_env(), { return m_env; } );

    //--------------------------------------------------
    // RescueEvalEngine :: RescueAgentBase
    RescueAgentBase* m_agentbase;
    ITK_DEF_ACCESS3(RescueAgentBase*, &_agentbase(), { return m_agentbase; }); 

    //============================================================
    // RescueEvalEngine Constructor
  public:
    RescueEvalEngine();
    RescueEvalEngine(Environment* env);

    //--------------------------------------------------
    // RescueEvalEngine::initFuncTable(Bool::False);
    //   initialize function table
    //      add RescueEvalEngine original function to EvalEngine
    ///  - INPUT
    ///    - ?see   .... check visual information at one time
    ///    - ?hear  .... check audio information
    ///    - ?know  .... check knowledge information since several past time
    ///  - RESCUEOBJECT(defined in librescue)
    ///    - building 
    ///    - refuge
    ///    - humanoid
    ///    - road
    ///  - OUTPUT
    ///    - !search .... search target object through random walk
    ///    - !move   .... move to target object pointed id.
    ///    - !say    .... say your message.
    static void initFuncTable(Bool forcep = False);


    //--------------------------------------------------
    // RescueEvalEngine :: map()
  public:
    ObjectPool& objectpool();

  };
  //------------------------------------------------------------
  // sysfunc: for inputsensor
  Sexp* sysfunc_see (Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_hear(Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_know(Sexp* form, EvalEngine* engine);

  //------------------------------------------------------------
  // sysfunc: for object
  Sexp* sysfunc_world   (Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_self    (Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_building(Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_refuge  (Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_road    (Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_humanoid(Sexp* form, EvalEngine* engine);

  //------------------------------------------------------------
  // sysfunc: for outputsensor
  Sexp* sysfunc_search(Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_move(Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_say(Sexp* form, EvalEngine* engine);

  //------------------------------------------------------------
  // sysfunc: for situation control sequence
  Sexp* sysfunc_stituation_add(Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_stituation_remove(Sexp* form, EvalEngine* engine);
  Sexp* sysfunc_stituation_swap(Sexp* from, EvalEngine* engine);

  //--------------------------------------------------
  //
  Bool check_attribute(FrameSexp* attr, RescueEvalEngine* engine, Flt& v);
};

//#include "Environment.hxx"

#endif// __RescueEvalEngine_hxx__
