/*
 * Header    :
 * File      : RescueObjectPool.cxx
 * Auther    : Kosuke Shinoda
 * Since     : 2001/12/26
 * Time-stamp: <2002-01-21 13:56:27 kshinoda>
 * Comment   : based source in RoboCupRescue Kernel source (C)koto
 * End       :
 */
/*
 * Copyright (C) 2001,2002 SHINODA, Kosuke. Jaist,Japan & CARC, AIST, JAPAN
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 */
// RescueObjectPool.hxx
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __RESCUEOBJECTPOOL_HXX__
#define __RESCUEOBJECTPOOL_HXX__

#include "../librescue/librescue.hxx"

namespace Rescue {
  /////////////////////////////////////////////////////////////////////////
  // RescueObjectPool

  class Input;
  class Output;

  /** management of set of object in meshed array*/
  class RescueObjectPool : public ObjectPool {
    private:
        
    protected:
        /** MotionlessObject 򤽤ΰ֤˱ƥåϿ */
        int m_meshXBase;    // åθ֤ɸ
        int m_meshYBase;
        int m_meshXSize;    // åΣޥΥ
        int m_meshYSize;
        int m_meshXCount;   // åΥޥο
        int m_meshYCount;
        typedef std::vector< std::vector< Objects > > Mesh;
        Mesh m_mesh;
        Objects m_movingObjects;
        Objects m_firedObjects;
        /*
         * XSize
         * <--->
         * +---+---+  <-- YBase
         * |   |   |
         * +---+---+
         * |   |   |
         * +---+---+
         *
         */

    public:
        virtual ~RescueObjectPool();
        RescueObjectPool();

        /**
        * ֥ȤϿ롣
        * @param    newObject
        *               Ͽ륪֥ȡΥ֥Ȥ      
        *               ObjectPool ˤä delete 롣id ѤߤǤ뤳ȡ
        */
        virtual void add(Object* newObject);

        void addFiredObject(Object* object);
        void clearFiredObjects();

        /** fieryness Ѳä֥ȤΥꥹ */
        const Objects& firedObjects() const;

        /** αߤˤǽΤ륪֥Ȥ󤹤 */
        class Enumerator {
            friend RescueObjectPool;
        private:
            RescueObjectPool* m_owner;
            double m_centerX;
            double m_centerY;
            double m_squaredRadius;
            int m_x;
            int m_y;
            int m_xMin;
            int m_xMaz;
            int m_yMin;
            int m_yMaz;
            Objects::const_iterator m_it;
            Enumerator(RescueObjectPool* owner, S32 x, S32 y, S32 r);
            Object* nextCore();
        public:
            Object* next();
        };
        friend Enumerator;
        /** αߤˤƤΥ֥Ȥ󤹤 */
        Enumerator objectsInRound(S32 x, S32 y, S32 r);
        /** å()ۤ */
        void setUpMesh(int meshX, int meshY);
    public:

    private:
        RescueObjectPool(const RescueObjectPool& source);
        RescueObjectPool& operator= (const RescueObjectPool& rhs);
        bool operator== (const RescueObjectPool& rhs) const;
    };
    
    /////////////////////////////////////////////////////////////////////////
} // namespace Rescue

#endif // RESCUEOBJECTPOOL_HXX__INCLUDED

