// -*- Mode:C++ -*-
//Header:
//File: Buffer.cc
//Author: NODA, Itsuki
//Date: 2000/03/12
//

//ModifyHistory:
// 2000/03/12: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#include "itk/Buffer.h"

namespace Itk {

   //--------------------------------------------------
   // alloc

   Bool Buffer::alloc(const UInt l, Bool forcep) {
      if(!original.alloc(l,forcep)) return False ;
      clear() ;
      return True;
   } 

   //--------------------------------------------------
   // set

   Buffer& Buffer::set(const Buffer& src) {
      SubString::set(src) ;
      original.set(src.original) ;
      return *this ;
   } 

   Buffer& Buffer::set(const SubString& src) { /* ??? */
      SubString::set(src) ;
      original.set(src) ;
      return *this ;
   } 

   //--------------------------------------------------
   // safety put

   char Buffer::putCharSafe(const char c) {
      if(tail == original.tail) {
	 SubString oldoriginal = original ;
	 SubString oldsubstr(head,tail) ;
	       
	 alloc(size() * 2.0) ;
	 head = original.head + (oldsubstr.head - oldoriginal.head) ;
	 copy(oldsubstr,False) ;
	       
	 delete oldoriginal.head ;
      }
      SubString::putChar(c) ;
      return c;
   }






}
