// -*- Mode:C++ -*-
//Header:
//File: FxpT.h
//Author: NODA, Itsuki
//Date: 2000/01/31
//

//ModifyHistory:
// 2000/01/31: Start to create this file
//EndModifyHistory:

//Memo:
//  FiXed Point real value.
//	FxpT<shift> means 
//		bbbbbb.bbbbb
//	where the number of binary of the right of the point is equal to 
//	shift.
//EndMemo:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_FxpT_h_
#define _itk_FxpT_h_
////////////////////////////////////////////////////////////////////////
#include "itk/btype.h"

namespace Itk {

   /*--------------------*/
   /**
    *
    */

   template <int shift>
      class FxpT {
	    //--------------------------------------------------
	    // the amount of shift 
	 public:
	    static const int _shift = shift ;
	    static const Flt _enshift = (Flt)(1 << _shift) ;
	    static const Flt _deshift = (1.0 / _enshift) ;

	    typedef FxpT<shift> Fxp ;
	    
	    //--------------------------------------------------
	    // the value
	 public:
	    Int v ;

	    //--------------------------------------------------
	    // constructor
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    FxpT<shift>() { v = 0 ; } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    FxpT<shift>(const Fxp & src) { v = src.v ; } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    FxpT<shift>(const Flt & src) { set(src) ; } ;

	    //--------------------------------------------------
	    // casting
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    operator Flt () const { return (Flt)v * _deshift ; } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    operator Int () const { return (Int)((Flt)*this) ; } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Fxp & set(const Flt & src) {
	       v = (Int)rint(src * _enshift) ;
	       return *this ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Fxp & set(const Int & src) {
	       v = src << _shift ;
	       return *this ;
	    } ;

	    //--------------------------------------------------
	    // ntoh
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Fxp & cvtNtoH() {
	       v = ntohl(v) ;
	       return *this ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Fxp & cvtHtoN() {
	       v = htonl(v) ;
	       return *this ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Fxp ntoh() const {
	       Fxp r(*this) ;
	       return r.cvtNtoH() ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Fxp hton() const {
	       Fxp r(*this) ;
	       return r.cvtHtoN() ;
	    } ;
      } ;

   /*--------------------*/
   /**
    *
    */
   template <int shift>
      operator FxpT<shift> (const Flt & src) { return FxpT<shift>(src) ; } ;

} ;
