// -*- Mode:C++ -*-
//Header:
//File: GetOpt.cc
//Author: NODA, Itsuki
//Date: 2000/03/12
//

//ModifyHistory:
// 2000/03/12: Start to create this file
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#include "itk/GetOpt.h"

namespace Itk {

   //======================================================================
   // scan
   
   Bool myGetOptScan(OptArg & opt, const char * valstr) {
      opt.str.copy(valstr) ;
      switch(opt.type) {
	 case OptArg::OnOff : {
	    if(!strcmp(valstr,OptArg::onStr)) {
	       *((Bool *)opt.dest) = True ; 
	    } else if(!strcmp(valstr,OptArg::offStr)) {
	       *((Bool *)opt.dest) = False ; 
	    } else {
	       return False ;
	    }
	    return True ;
	 }
	 case OptArg::cstringVal : {
	    *((char **)opt.dest) = strdup(valstr) ; 
	    return True ;
	 }
	 case OptArg::SStringVal : {
	    *((SString *)opt.dest) = strdup(valstr) ;
	    return True ;
	 }
	 case OptArg::IntVal : {
	    *((Int *)opt.dest) = strtol(valstr, ITK_NULLPTR, 10) ;
	    return True ;
	 }
	 case OptArg::UIntVal : {
	    *((UInt *)opt.dest) = strtoul(valstr, ITK_NULLPTR, 10) ;
	    return True ;
	 }
	 case OptArg::FltVal : {
	    *((Flt *)opt.dest) = strtod(valstr, ITK_NULLPTR) ;
	    return True ;
	 }
	 case OptArg::FunctionCall : {
	    Bool (*f)(void *, const char *) 
	       = (Bool (*)(void *, const char *))(opt.dest) ;
	    return (*f)(opt.aux,valstr) ;
	 }
	 default : { 
	    return False ; 
	 }
      }
   }
      
   //======================================================================
   // output

   void myGetOptPrint(const OptArg & opt, ostream & ostr) {
      switch(opt.type) {
	 case OptArg::OnOff : { 
	    ostr << ( *((Bool *)opt.dest) ? "on" : "off" ) ;
	       break ;
	 }
	 case OptArg::cstringVal : ostr << *((char**)opt.dest) ; break ;
	 case OptArg::SStringVal : ostr << *((SString*)opt.dest) ; break ;
	 case OptArg::IntVal : ostr << *((Int*)opt.dest) ; break ;
	 case OptArg::UIntVal : ostr << *((UInt*)opt.dest) ; break ;
	 case OptArg::FltVal : ostr << *((Flt*)opt.dest) ; break ;
	 case OptArg::FunctionCall : ostr << "(function call)" ; break ;
	 default : ostr << "unknown" ; break ;
	 }
   } 
   
   //======================================================================
   // help

   void myGetOptHelp(OptArg * optlist, char * commandname) {
      cerr << "Usage:" << endl ;
      cerr << "\t% " << commandname << "[options]" << endl ;
      cerr << "\t    [options]" << endl ;
      for(OptArg * opt = optlist ; !isNull(opt->name) ; opt++) {
	 cerr << "\t\t" << OptArg::prefixChr << opt->name << " "
	      << opt->help << endl ;
	 cerr << "\t\t\t" << " [default=" ;
	 myGetOptPrint(*opt,cerr) ;
	 cerr << "]" << endl ;
      }
      cerr << "\t\t" << "-conf FILE ; read config from FILE" << endl ;
      cerr << "\t\t" << "-make_conf FILE ; output default config file to FILE"
	   << endl ;
      cerr << "\t\t" << "-help ; show this message." << endl ;
      exit(1) ;
   }
   
   //======================================================================
   // load config file

   void myGetOptLoadConfig(OptArg * optlist, char * filename) {
      ifstream istr(filename) ;
      Int bufsize = 1024 ;
      Buffer buffer(bufsize) ;

      while(istr.good()) {
	 buffer.clear() ;
	 istr.getline(buffer.tail,buffer.size()) ;
	 buffer.adjustLength() ;

	 /* chop comment */
	 Int i = buffer.index('%') ; /* *** */
	 if( i >= 0 ) buffer.setLength((UInt)i) ;

	 if(buffer.isNullStr()) continue ;

	 /* get option name */
	 buffer.skipWhile(" \t\n") ; /* *** skip spaces */
	 char* h = buffer.head ;
	 buffer.skipUntil(": \t\n") ; /* *** jump after optname */
	 char* t = buffer.head ;
	 SubString optname(h,t) ;
	 
	 /* get option value */
	 buffer.skipWhile(": \t\n") ; /* *** skip separator */
	 h = buffer.head ;
	 buffer.skipUntil(": \t\n") ; /* *** jump after optvalue */
	 t = buffer.head ;
	 SubString optvalue(h,t) ;

	 if(optname.isNullStr()) continue ;

	 Bool findp = False ;
	 for(OptArg * opt = optlist ; !isNull(opt->name) ; opt++) {
	    if(optname == opt->name) {
	       myGetOptScan(*opt,optvalue) ;
	       findp = True ;
	       break ;
	    }
	 }
	 if(!findp) {
	    ITK_WRN("Unknown option label : " << optname) ;
	 }
      }
   }

   //======================================================================
   // load config file
   
   void myGetOptMakeConfig(OptArg * optlist, ostream & ostr) {
      ostr << "%% config set" << endl ;
      for(OptArg * opt = optlist ; !isNull(opt->name) ; opt++) {
	 ostr << endl ;
	 ostr << "%% " << opt->name << " : " << opt->help << endl ;
	 ostr << opt->name << " : " ;
	 switch(opt->type) {
	    case OptArg::OnOff : { 
	       ostr << ( *((Bool *)opt->dest) ? "on" : "off" ) ;
	       break ;
	    }
	    case OptArg::cstringVal : ostr << *((char**)opt->dest) ; break ;
	    case OptArg::SStringVal : ostr << *((SString*)opt->dest) ; break ;
	    case OptArg::IntVal : ostr << *((Int*)opt->dest) ; break ;
	    case OptArg::UIntVal : ostr << *((UInt*)opt->dest) ; break ;
	    case OptArg::FltVal : ostr << *((Flt*)opt->dest) ; break ;
	    case OptArg::FunctionCall : ostr << "function call" ; break ;
	    default : ostr << "unknown" ; break ;
	 }
	 ostr << endl ;
      }
   }

   void myGetOptMakeConfig(OptArg * optlist, char * filename = ITK_NULLPTR) {
      if(isNull(filename) || !strcmp(filename,"-")) {
	 myGetOptMakeConfig(optlist, cout) ;
      } else {
	 ofstream ostr(filename) ;
	 myGetOptMakeConfig(optlist, ostr) ;
      }
   }

   //======================================================================
   // myGetOpt

   void myGetOpt(OptArg * optlist, int & argc, char** argv) {
      int shift = 1 ;
      char ** cargv = argv ;
      Bool skip = False ;

      while(shift < argc) {
	 cargv++ ; argc-- ;
	 if(!strcmp(*cargv,OptArg::optHelpStr)) {
	    myGetOptHelp(optlist,argv[0]) ;
	 } 
	 else if (!strcmp(*cargv,OptArg::optConfStr)) {
	    if(shift >= argc) myGetOptHelp(optlist,argv[0]) ;
	    cargv++; argc-- ;
	    myGetOptLoadConfig(optlist,*cargv) ;
	 } 
	 else if (!strcmp(*cargv,OptArg::optMakeConfStr)) {
	    if(shift >= argc) myGetOptHelp(optlist,argv[0]) ;
	    cargv++; argc-- ;
	    myGetOptMakeConfig(optlist,*cargv) ;
	    exit(0) ;
	 } 
	 else if (!strcmp(*cargv,OptArg::optSkipRestStr)) {
	    skip = True ;
	 } 
	 else if (skip) {
	    argv[shift] = *cargv ;
	    shift++ ;
	 }
	 else {
	    Bool r = False ;
	    if(**cargv == OptArg::prefixChr) { // check prefix
	       for(OptArg * opt = optlist ; !isNull(opt->name) ; opt++) {
		  if(!strcmp(&((*cargv)[1]),opt->name)) { // match optname
		     if(shift < argc) {	// found param value
			cargv++ ; argc-- ;
			if(myGetOptScan(*opt,*cargv)) {
			   r = True ;
			   break ;
			} else {  // can not scan opt arg
			   ITK_WRN("can not scan option value" << *cargv) ;
			   myGetOptHelp(optlist,argv[0]) ; // will exit
			}
		     } else { // not found param value
			ITK_WRN("no option value for " << *cargv) ;
			myGetOptHelp(optlist,argv[0]) ; // will exit
		     } 
		  }
	       }
	       if(!r) {
		  ITK_WRN("unknown option " << *cargv) ;
		  myGetOptHelp(optlist,argv[0]) ;
	       }
	    }
	    if(!r) {
	       argv[shift] = *cargv ;
	       shift++ ;
	    }
	 }
      }
   }
}



