// -*- Mode:C++ -*-
//Header:
//File: StackT.h
//Author: NODA, Itsuki
//Date: 1999/09/06
//

//ModifyHistory:
// 1999/09/06: Start to create this file
// 1999/09/06: Split cc file
// 1999/11/08: separate into files for each class
//EndModifyHistory:

/*
 * Copyright (C) 2001 NODA, Itsuki, CARC, AIST, JAPAN
 * Copyright (C) 1999, 2000 Itsuki Noda, Electrotechnical Laboratory, Japan
 */

#ifndef _itk_HeapT_h_
#define _itk_HeapT_h_
////////////////////////////////////////////////////////////////////////
#include "itk/btype.h"
#include "itk/Exception.h"
#include "itk/MemPtrArrayT.h"

namespace Itk {
//======================================================================
// Heap

#ifndef ITK_DFLT_HEAP_NAME
#define ITK_DFLT_HEAP_NAME  "Heap"
#endif
#ifndef ITK_DFLT_HEAP_SIZE
#define ITK_DFLT_HEAP_SIZE  ITK_DFLT_MEMARRAY_SIZE
#endif


//------------------------------------------------------------
// DFLT initializer

   /*--------------------*/
   /**
    *
    */

   inline void initHeapEntity(char * c) { *c = ITK_NULLCHR ; }

   /*--------------------*/
   /**
    *
    */

   inline void initHeapEntity(UInt * i) { *i = 0 ; }

   /*--------------------*/
   /**
    *
    */

   inline void initHeapEntity(Int * i) { *i = 0 ; }

   /*--------------------*/
   /**
    *
    */

   inline void initHeapEntity(void ** ptr) { *ptr = ITK_NULLPTR ; } 

   /*--------------------*/
   /**
    *
    */

   inline void initHeapEntity(void * ptr) {} 

//------------------------------------------------------------
// class template

   /*--------------------*/
   /**
    *
    */

   template <class Content>
      class HeapT : public MemPtrArrayT<Content> {
	 public:
	    //--------------------------------------------------
	    // local typedef

	    typedef HeapT<Content> Heap ;

	    //--------------------------------------------------
	    // constructor
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    HeapT<Content>(char * const nm = ITK_DFLT_HEAP_NAME,
			   UInt const sz = ITK_DFLT_HEAP_SIZE,
			   UInt const ef = ITK_DFLT_EXPAND_FACTOR) {
	       init(nm,sz,ef) ;
	    } ;

	    //--------------------------------------------------
	    // get new entity
	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content * getPtr(Bool initializep = True) {
	       if(edge >= size) expand() ;
	       Content * r = table[edge] ;
	       if(initializep) initHeapEntity(r) ;
	       edge++ ;
	       return r ;
	    } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    Content & get(Bool initializep = True) {
	       return *(getPtr(initializep)) ;
	    } ;

	    //--------------------------------------------------
	    // access to top position

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    UInt toppos() const { return edge ; } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void rewind(UInt const newtop) { edge = newtop ; } ;

	    /*--------------------*/
	    /**
	     *
	     */
	 public:
	    void reset() { rewind(0) ; } ;

      } ;
}


////////////////////////////////////////////////////////////////////////
#endif
